/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.PowerManager;
import android.os.WorkSource;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=PowerManager.class, looseSignatures=true)
public class ShadowPowerManager {
    private boolean isScreenOn = true;
    private boolean isInteractive = true;
    private boolean isPowerSaveMode = false;
    private boolean isDeviceIdleMode = false;
    private boolean isLightDeviceIdleMode = false;
    private int locationMode = 2;
    private List<String> rebootReasons = new ArrayList<String>();
    private Map<String, Boolean> ignoringBatteryOptimizations = new HashMap<String, Boolean>();
    private int thermalStatus = 0;
    private final Set<Object> thermalListeners = new HashSet<Object>();
    private Map<Integer, Boolean> supportedWakeLockLevels = new HashMap<Integer, Boolean>();

    @Implementation
    protected PowerManager.WakeLock newWakeLock(int flags, String tag) {
        PowerManager.WakeLock wl = (PowerManager.WakeLock)Shadow.newInstanceOf(PowerManager.WakeLock.class);
        ((ShadowWakeLock)Shadow.extract((Object)wl)).setTag(tag);
        ShadowApplication.getInstance().addWakeLock(wl);
        return wl;
    }

    @Implementation
    protected boolean isScreenOn() {
        return this.isScreenOn;
    }

    public void setIsScreenOn(boolean screenOn) {
        this.isScreenOn = screenOn;
    }

    @Implementation(minSdk=21)
    protected boolean isInteractive() {
        return this.isInteractive;
    }

    public void setIsInteractive(boolean interactive) {
        this.isInteractive = interactive;
    }

    @Implementation(minSdk=21)
    protected boolean isPowerSaveMode() {
        return this.isPowerSaveMode;
    }

    public void setIsPowerSaveMode(boolean powerSaveMode) {
        this.isPowerSaveMode = powerSaveMode;
    }

    @Implementation(minSdk=21)
    protected boolean isWakeLockLevelSupported(int level) {
        return this.supportedWakeLockLevels.containsKey(level) ? this.supportedWakeLockLevels.get(level) : false;
    }

    public void setIsWakeLockLevelSupported(int level, boolean supported) {
        this.supportedWakeLockLevels.put(level, supported);
    }

    @Implementation(minSdk=23)
    protected boolean isDeviceIdleMode() {
        return this.isDeviceIdleMode;
    }

    public void setIsDeviceIdleMode(boolean isDeviceIdleMode) {
        this.isDeviceIdleMode = isDeviceIdleMode;
    }

    @Implementation(minSdk=24)
    protected boolean isLightDeviceIdleMode() {
        return this.isLightDeviceIdleMode;
    }

    public void setIsLightDeviceIdleMode(boolean lightDeviceIdleMode) {
        this.isLightDeviceIdleMode = lightDeviceIdleMode;
    }

    @Implementation(minSdk=28)
    protected int getLocationPowerSaveMode() {
        if (!this.isPowerSaveMode()) {
            return 0;
        }
        return this.locationMode;
    }

    public void setLocationPowerSaveMode(int locationMode) {
        Preconditions.checkState((locationMode >= 0 ? 1 : 0) != 0, (Object)"Location Power Save Mode must be at least 0");
        Preconditions.checkState((locationMode <= 4 ? 1 : 0) != 0, (Object)"Location Power Save Mode must be no more than 4");
        this.locationMode = locationMode;
    }

    @Implementation(minSdk=29)
    protected int getCurrentThermalStatus() {
        return this.thermalStatus;
    }

    @Implementation(minSdk=29)
    protected void addThermalStatusListener(Object listener) {
        Preconditions.checkState((boolean)(listener instanceof PowerManager.OnThermalStatusChangedListener), (Object)"Listener must implement PowerManager.OnThermalStatusChangedListener");
        this.thermalListeners.add(listener);
    }

    @Implementation(minSdk=29)
    protected void removeThermalStatusListener(Object listener) {
        Preconditions.checkState((boolean)(listener instanceof PowerManager.OnThermalStatusChangedListener), (Object)"Listener must implement PowerManager.OnThermalStatusChangedListener");
        this.thermalListeners.remove(listener);
    }

    public void setCurrentThermalStatus(int thermalStatus) {
        Preconditions.checkState((thermalStatus >= 0 ? 1 : 0) != 0, (Object)"Thermal status must be at least 0");
        Preconditions.checkState((this.locationMode <= 6 ? 1 : 0) != 0, (Object)"Thermal status must be no more than 6");
        this.thermalStatus = thermalStatus;
        for (Object listener : this.thermalListeners) {
            ((PowerManager.OnThermalStatusChangedListener)listener).onThermalStatusChanged(thermalStatus);
        }
    }

    @Resetter
    public static void reset() {
        ShadowApplication shadowApplication = ShadowApplication.getInstance();
        if (shadowApplication != null) {
            shadowApplication.clearWakeLocks();
        }
    }

    public static PowerManager.WakeLock getLatestWakeLock() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.application);
        return shadowApplication.getLatestWakeLock();
    }

    @Implementation(minSdk=23)
    protected boolean isIgnoringBatteryOptimizations(String packageName) {
        Boolean result = this.ignoringBatteryOptimizations.get(packageName);
        return result == null ? false : result;
    }

    public void setIgnoringBatteryOptimizations(String packageName, boolean value) {
        this.ignoringBatteryOptimizations.put(packageName, value);
    }

    @Implementation
    protected void reboot(String reason) {
        this.rebootReasons.add(reason);
    }

    public int getTimesRebooted() {
        return this.rebootReasons.size();
    }

    public ImmutableList<String> getRebootReasons() {
        return ImmutableList.copyOf(this.rebootReasons);
    }

    @Implements(value=PowerManager.WakeLock.class)
    public static class ShadowWakeLock {
        private boolean refCounted = true;
        private int refCount = 0;
        private boolean locked = false;
        private WorkSource workSource = null;
        private int timesHeld = 0;
        private String tag = null;

        @Implementation
        protected void acquire() {
            this.acquire(0L);
        }

        @Implementation
        protected synchronized void acquire(long timeout) {
            ++this.timesHeld;
            if (this.refCounted) {
                ++this.refCount;
            } else {
                this.locked = true;
            }
        }

        @Implementation
        protected synchronized void release() {
            if (this.refCounted) {
                if (--this.refCount < 0) {
                    throw new RuntimeException("WakeLock under-locked");
                }
            } else {
                this.locked = false;
            }
        }

        @Implementation
        protected synchronized boolean isHeld() {
            return this.refCounted ? this.refCount > 0 : this.locked;
        }

        public boolean isReferenceCounted() {
            return this.refCounted;
        }

        @Implementation
        protected void setReferenceCounted(boolean value) {
            this.refCounted = value;
        }

        @Implementation
        protected synchronized void setWorkSource(WorkSource ws) {
            this.workSource = ws;
        }

        public synchronized WorkSource getWorkSource() {
            return this.workSource;
        }

        public int getTimesHeld() {
            return this.timesHeld;
        }

        @HiddenApi
        @Implementation(minSdk=26)
        public String getTag() {
            return this.tag;
        }

        private void setTag(String tag) {
            this.tag = tag;
        }
    }
}

