/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Process;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Process.class)
public class ShadowProcess {
    private static int pid;
    private static int uid;
    private static int tid;
    private static final Object threadPrioritiesLock;
    private static final Object killedProcessesLock;
    @GuardedBy(value="threadPrioritiesLock")
    private static final Map<Integer, Integer> threadPriorities;
    @GuardedBy(value="killedProcessesLock")
    private static final Set<Integer> killedProcesses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static final void killProcess(int pid) {
        Object object = killedProcessesLock;
        synchronized (object) {
            killedProcesses.add(pid);
        }
    }

    @Implementation
    protected static final int myPid() {
        return pid;
    }

    @Implementation
    protected static final int myUid() {
        return uid;
    }

    @Implementation
    protected static final int myTid() {
        return (int)Thread.currentThread().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static final void setThreadPriority(int priority) {
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.put(ShadowProcess.myTid(), priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static final void setThreadPriority(int tid, int priority) {
        Preconditions.checkArgument((priority >= -19 && priority <= 19 ? 1 : 0) != 0, (String)"priority %s out of range. Use a Process.THREAD_PRIORITY_* constant.", (int)priority);
        if (tid == 0) {
            tid = ShadowProcess.myTid();
        }
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.put(tid, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static final int getThreadPriority(int tid) {
        if (tid == 0) {
            tid = ShadowProcess.myTid();
        }
        Object object = threadPrioritiesLock;
        synchronized (object) {
            return threadPriorities.getOrDefault(tid, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearKilledProcesses() {
        Object object = killedProcessesLock;
        synchronized (object) {
            killedProcesses.clear();
        }
    }

    public static void setUid(int uid) {
        ShadowProcess.uid = uid;
    }

    public static void setPid(int pid) {
        ShadowProcess.pid = pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        pid = 0;
        ShadowProcess.clearKilledProcesses();
        Object object = threadPrioritiesLock;
        synchronized (object) {
            threadPriorities.clear();
        }
    }

    static int getRandomApplicationUid() {
        return ThreadLocalRandom.current().nextInt(10000, 20000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wasKilled(int pid) {
        Object object = killedProcessesLock;
        synchronized (object) {
            return killedProcesses.contains(pid);
        }
    }

    static {
        uid = ShadowProcess.getRandomApplicationUid();
        tid = ShadowProcess.getRandomApplicationUid();
        threadPrioritiesLock = new Object();
        killedProcessesLock = new Object();
        threadPriorities = new HashMap<Integer, Integer>();
        killedProcesses = new HashSet<Integer>();
    }
}

