/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.MacAddress;
import android.net.wifi.rtt.RangingResult;
import org.robolectric.annotation.Config;
import org.robolectric.annotation.Implements;
import org.robolectric.util.ReflectionHelpers;

@Config(minSdk=28)
@Implements(value=RangingResult.class)
public class ShadowRangingResult {
    private static RangingResult asRangingResult(int status, MacAddress mac, int distanceMm, int distanceStdDevMm, int rssi, int numAttemptedMeasurements, int numSuccessfulMeasurements, byte[] lci, byte[] lcr, long timestamp) {
        return (RangingResult)ReflectionHelpers.callConstructor(RangingResult.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)status), ReflectionHelpers.ClassParameter.from(MacAddress.class, (Object)mac), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)distanceStdDevMm), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)rssi), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numAttemptedMeasurements), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)numSuccessfulMeasurements), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lci), ReflectionHelpers.ClassParameter.from(byte[].class, (Object)lcr), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)timestamp)});
    }

    public static final class Builder {
        private final int status;
        private final MacAddress mac;
        private final int distanceMm;
        private final long timestamp;
        private int distanceStdDevMm = 0;
        private int rssi = 0;
        private int numAttemptedMeasurements = 0;
        private int numSuccessfulMeasurements = 0;
        private byte[] lci = new byte[0];
        private byte[] lcr = new byte[0];

        public Builder(int status, MacAddress mac, long timestamp, int distanceMm) {
            this.status = status;
            this.mac = mac;
            this.timestamp = timestamp;
            this.distanceMm = distanceMm;
        }

        public Builder setDistanceStandardDeviation(int stddev) {
            this.distanceStdDevMm = stddev;
            return this;
        }

        public Builder setRssi(int rssi) {
            this.rssi = rssi;
            return this;
        }

        public Builder setNumAttemptedMeasurements(int num) {
            this.numAttemptedMeasurements = num;
            return this;
        }

        public Builder setNumSuccessfulMeasurements(int num) {
            this.numSuccessfulMeasurements = num;
            return this;
        }

        public Builder setLci(byte[] lci) {
            this.lci = lci;
            return this;
        }

        public Builder setLcr(byte[] lcr) {
            this.lcr = lcr;
            return this;
        }

        public RangingResult build() {
            return ShadowRangingResult.asRangingResult(this.status, this.mac, this.distanceMm, this.distanceStdDevMm, this.rssi, this.numAttemptedMeasurements, this.numSuccessfulMeasurements, this.lci, this.lcr, this.timestamp);
        }
    }
}

