/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.IAccountManager;
import android.app.IAlarmManager;
import android.app.INotificationManager;
import android.app.ISearchManager;
import android.app.IUiModeManager;
import android.app.IWallpaperManager;
import android.app.admin.IDevicePolicyManager;
import android.app.job.IJobScheduler;
import android.app.role.IRoleManager;
import android.app.slice.ISliceManager;
import android.app.trust.ITrustManager;
import android.app.usage.IUsageStatsManager;
import android.content.IClipboard;
import android.content.IRestrictionsManager;
import android.content.pm.ICrossProfileApps;
import android.content.pm.IShortcutService;
import android.content.rollback.IRollbackManager;
import android.hardware.biometrics.IBiometricService;
import android.hardware.fingerprint.IFingerprintService;
import android.hardware.input.IInputManager;
import android.hardware.location.IContextHubService;
import android.hardware.usb.IUsbManager;
import android.location.ICountryDetector;
import android.location.ILocationManager;
import android.media.IAudioService;
import android.media.IMediaRouterService;
import android.media.session.ISessionManager;
import android.net.IConnectivityManager;
import android.net.INetworkPolicyManager;
import android.net.INetworkScoreService;
import android.net.nsd.INsdManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.aware.IWifiAwareManager;
import android.net.wifi.p2p.IWifiP2pManager;
import android.net.wifi.rtt.IWifiRttManager;
import android.os.Binder;
import android.os.IBatteryPropertiesRegistrar;
import android.os.IBinder;
import android.os.IDumpstate;
import android.os.IInterface;
import android.os.IPowerManager;
import android.os.IThermalService;
import android.os.IUserManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.storage.IStorageManager;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IBatteryStats;
import com.android.internal.appwidget.IAppWidgetService;
import com.android.internal.os.IDropBoxManagerService;
import com.android.internal.view.IInputMethodManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ServiceManager.class, isInAndroidSdk=false)
public class ShadowServiceManager {
    private static final Map<String, BinderService> binderServices = new HashMap<String, BinderService>();
    private static final Set<String> unavailableServices = new HashSet<String>();

    protected static void addBinderService(String name, Class<? extends IInterface> clazz) {
        ShadowServiceManager.addBinderService(name, clazz, clazz.getCanonicalName(), false);
    }

    protected static void addBinderService(String name, Class<? extends IInterface> clazz, boolean useDeepBinder) {
        ShadowServiceManager.addBinderService(name, clazz, clazz.getCanonicalName(), useDeepBinder);
    }

    protected static void addBinderService(String name, String className) {
        Class<IInterface> clazz;
        try {
            clazz = Class.forName(className).asSubclass(IInterface.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ShadowServiceManager.addBinderService(name, clazz, className, false);
    }

    protected static void addBinderService(String name, Class<? extends IInterface> clazz, String className, boolean useDeepBinder) {
        binderServices.put(name, new BinderService(clazz, className, useDeepBinder));
    }

    @Implementation
    protected static IBinder getService(String name) {
        if (unavailableServices.contains(name)) {
            return null;
        }
        BinderService binderService = binderServices.get(name);
        if (binderService == null) {
            return null;
        }
        return binderService.getBinder();
    }

    @Implementation
    protected static void addService(String name, IBinder service) {
    }

    @Implementation
    protected static IBinder checkService(String name) {
        return null;
    }

    @Implementation
    protected static String[] listServices() throws RemoteException {
        return null;
    }

    @Implementation
    protected static void initServiceCache(Map<String, IBinder> cache) {
    }

    public static void setServiceAvailability(String service, boolean available) {
        if (available) {
            unavailableServices.remove(service);
        } else {
            unavailableServices.add(service);
        }
    }

    @Resetter
    public static void reset() {
        unavailableServices.clear();
    }

    static {
        ShadowServiceManager.addBinderService("clipboard", IClipboard.class);
        ShadowServiceManager.addBinderService("wifip2p", IWifiP2pManager.class);
        ShadowServiceManager.addBinderService("account", IAccountManager.class);
        ShadowServiceManager.addBinderService("usb", IUsbManager.class);
        ShadowServiceManager.addBinderService("location", ILocationManager.class);
        ShadowServiceManager.addBinderService("input_method", IInputMethodManager.class);
        ShadowServiceManager.addBinderService("alarm", IAlarmManager.class);
        ShadowServiceManager.addBinderService("power", IPowerManager.class);
        ShadowServiceManager.addBinderService("batterystats", IBatteryStats.class);
        ShadowServiceManager.addBinderService("dropbox", IDropBoxManagerService.class);
        ShadowServiceManager.addBinderService("device_policy", IDevicePolicyManager.class);
        ShadowServiceManager.addBinderService("connectivity", IConnectivityManager.class);
        ShadowServiceManager.addBinderService("wifi", IWifiManager.class);
        ShadowServiceManager.addBinderService("search", ISearchManager.class);
        ShadowServiceManager.addBinderService("uimode", IUiModeManager.class);
        ShadowServiceManager.addBinderService("netpolicy", INetworkPolicyManager.class);
        ShadowServiceManager.addBinderService("input", IInputManager.class);
        ShadowServiceManager.addBinderService("country_detector", ICountryDetector.class);
        ShadowServiceManager.addBinderService("servicediscovery", INsdManager.class);
        ShadowServiceManager.addBinderService("audio", IAudioService.class);
        ShadowServiceManager.addBinderService("appwidget", IAppWidgetService.class);
        ShadowServiceManager.addBinderService("notification", INotificationManager.class);
        ShadowServiceManager.addBinderService("wallpaper", IWallpaperManager.class);
        if (RuntimeEnvironment.getApiLevel() >= 17) {
            ShadowServiceManager.addBinderService("user", IUserManager.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 18) {
            ShadowServiceManager.addBinderService("appops", IAppOpsService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            ShadowServiceManager.addBinderService("batteryproperties", IBatteryPropertiesRegistrar.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            ShadowServiceManager.addBinderService("restrictions", IRestrictionsManager.class);
            ShadowServiceManager.addBinderService("trust", ITrustManager.class);
            ShadowServiceManager.addBinderService("jobscheduler", IJobScheduler.class);
            ShadowServiceManager.addBinderService("network_score", INetworkScoreService.class);
            ShadowServiceManager.addBinderService("usagestats", IUsageStatsManager.class);
            ShadowServiceManager.addBinderService("media_router", IMediaRouterService.class);
            ShadowServiceManager.addBinderService("media_session", ISessionManager.class, true);
        }
        if (RuntimeEnvironment.getApiLevel() >= 23) {
            ShadowServiceManager.addBinderService("fingerprint", IFingerprintService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            ShadowServiceManager.addBinderService("contexthub", IContextHubService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 25) {
            ShadowServiceManager.addBinderService("shortcut", IShortcutService.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 26) {
            ShadowServiceManager.addBinderService("mount", IStorageManager.class);
            ShadowServiceManager.addBinderService("wifiaware", IWifiAwareManager.class);
        } else {
            ShadowServiceManager.addBinderService("mount", "android.os.storage.IMountService");
        }
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            ShadowServiceManager.addBinderService("slice", ISliceManager.class);
            ShadowServiceManager.addBinderService("crossprofileapps", ICrossProfileApps.class);
            ShadowServiceManager.addBinderService("wifirtt", IWifiRttManager.class);
        }
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            ShadowServiceManager.addBinderService("biometric", IBiometricService.class);
            ShadowServiceManager.addBinderService("role", IRoleManager.class);
            ShadowServiceManager.addBinderService("rollback", IRollbackManager.class);
            ShadowServiceManager.addBinderService("thermalservice", IThermalService.class);
            ShadowServiceManager.addBinderService("bugreport", IDumpstate.class);
        }
    }

    private static class BinderService {
        private final Class<? extends IInterface> clazz;
        private final String className;
        private final boolean useDeepBinder;
        private Binder cachedBinder;

        BinderService(Class<? extends IInterface> clazz, String className, boolean useDeepBinder) {
            this.clazz = clazz;
            this.className = className;
            this.useDeepBinder = useDeepBinder;
        }

        IBinder getBinder() {
            if (this.cachedBinder == null) {
                this.cachedBinder = new Binder();
                this.cachedBinder.attachInterface(this.useDeepBinder ? (IInterface)ReflectionHelpers.createDeepProxy(this.clazz) : (IInterface)ReflectionHelpers.createNullProxy(this.clazz), this.className);
            }
            return this.cachedBinder;
        }
    }
}

