/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.telephony.SmsManager;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SmsManager.class, minSdk=18)
public class ShadowSmsManager {
    protected TextSmsParams lastTextSmsParams;
    protected TextMultipartParams lastTextMultipartParams;
    protected DataMessageParams lastDataParams;
    private SendMultimediaMessageParams lastSentMultimediaMessageParams;
    private DownloadMultimediaMessageParams lastDownloadedMultimediaMessageParams;

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() >= 22) {
            Map sSubInstances = (Map)ReflectionHelpers.getStaticField(SmsManager.class, (String)"sSubInstances");
            sSubInstances.clear();
        }
    }

    @Implementation
    protected void sendDataMessage(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        this.lastDataParams = new DataMessageParams(destinationAddress, scAddress, destinationPort, data, sentIntent, deliveryIntent);
    }

    @Implementation
    protected void sendTextMessage(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (TextUtils.isEmpty((CharSequence)text)) {
            throw new IllegalArgumentException("Invalid message body");
        }
        this.lastTextSmsParams = new TextSmsParams(destinationAddress, scAddress, text, sentIntent, deliveryIntent);
    }

    @Implementation
    protected void sendMultipartTextMessage(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
        if (TextUtils.isEmpty((CharSequence)destinationAddress)) {
            throw new IllegalArgumentException("Invalid destinationAddress");
        }
        if (parts == null) {
            throw new IllegalArgumentException("Invalid message parts");
        }
        this.lastTextMultipartParams = new TextMultipartParams(destinationAddress, scAddress, parts, sentIntents, deliveryIntents);
    }

    public DataMessageParams getLastSentDataMessageParams() {
        return this.lastDataParams;
    }

    public void clearLastSentDataMessageParams() {
        this.lastDataParams = null;
    }

    public TextSmsParams getLastSentTextMessageParams() {
        return this.lastTextSmsParams;
    }

    public void clearLastSentTextMessageParams() {
        this.lastTextSmsParams = null;
    }

    public TextMultipartParams getLastSentMultipartTextMessageParams() {
        return this.lastTextMultipartParams;
    }

    public void clearLastSentMultipartTextMessageParams() {
        this.lastTextMultipartParams = null;
    }

    @Implementation(minSdk=21)
    protected void sendMultimediaMessage(Context context, Uri contentUri, @Nullable String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent sentIntent) {
        if (contentUri == null || TextUtils.isEmpty((CharSequence)contentUri.getHost())) {
            throw new IllegalArgumentException("Invalid contentUri");
        }
        this.lastSentMultimediaMessageParams = new SendMultimediaMessageParams(contentUri, locationUrl, configOverrides, sentIntent);
    }

    @Implementation(minSdk=21)
    protected void downloadMultimediaMessage(Context context, String locationUrl, Uri contentUri, @Nullable Bundle configOverrides, @Nullable PendingIntent sentIntent) {
        if (contentUri == null || TextUtils.isEmpty((CharSequence)contentUri.getHost())) {
            throw new IllegalArgumentException("Invalid contentUri");
        }
        if (TextUtils.isEmpty((CharSequence)locationUrl)) {
            throw new IllegalArgumentException("Invalid locationUrl");
        }
        this.lastDownloadedMultimediaMessageParams = new DownloadMultimediaMessageParams(contentUri, locationUrl, configOverrides, sentIntent);
    }

    public SendMultimediaMessageParams getLastSentMultimediaMessageParams() {
        return this.lastSentMultimediaMessageParams;
    }

    public void clearLastSentMultimediaMessageParams() {
        this.lastSentMultimediaMessageParams = null;
    }

    public DownloadMultimediaMessageParams getLastDownloadedMultimediaMessageParams() {
        return this.lastDownloadedMultimediaMessageParams;
    }

    public void clearLastDownloadedMultimediaMessageParams() {
        this.lastDownloadedMultimediaMessageParams = null;
    }

    public static final class DownloadMultimediaMessageParams
    extends MultimediaMessageParams {
        protected DownloadMultimediaMessageParams(Uri contentUri, String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent pendingIntent) {
            super(contentUri, locationUrl, configOverrides, pendingIntent);
        }

        public String getLocationUrl() {
            return this.locationUrl;
        }

        @Nullable
        public PendingIntent getDownloadedIntent() {
            return this.pendingIntent;
        }
    }

    public static final class SendMultimediaMessageParams
    extends MultimediaMessageParams {
        protected SendMultimediaMessageParams(Uri contentUri, @Nullable String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent pendingIntent) {
            super(contentUri, locationUrl, configOverrides, pendingIntent);
        }

        @Nullable
        public String getLocationUrl() {
            return this.locationUrl;
        }

        @Nullable
        public PendingIntent getSentIntent() {
            return this.pendingIntent;
        }
    }

    public static abstract class MultimediaMessageParams {
        private final Uri contentUri;
        protected final String locationUrl;
        @Nullable
        private final Bundle configOverrides;
        @Nullable
        protected final PendingIntent pendingIntent;

        protected MultimediaMessageParams(Uri contentUri, String locationUrl, @Nullable Bundle configOverrides, @Nullable PendingIntent pendingIntent) {
            this.contentUri = contentUri;
            this.locationUrl = locationUrl;
            this.configOverrides = configOverrides;
            this.pendingIntent = pendingIntent;
        }

        public Uri getContentUri() {
            return this.contentUri;
        }

        @Nullable
        public Bundle getConfigOverrides() {
            return this.configOverrides;
        }
    }

    public static class TextMultipartParams {
        private final String destinationAddress;
        private final String scAddress;
        private final List<String> parts;
        private final List<PendingIntent> sentIntents;
        private final List<PendingIntent> deliveryIntents;
        private final long messageId;

        public TextMultipartParams(String destinationAddress, String scAddress, ArrayList<String> parts, ArrayList<PendingIntent> sentIntents, ArrayList<PendingIntent> deliveryIntents) {
            this(destinationAddress, scAddress, parts, sentIntents, deliveryIntents, 0L);
        }

        public TextMultipartParams(String destinationAddress, String scAddress, List<String> parts, List<PendingIntent> sentIntents, List<PendingIntent> deliveryIntents, long messageId) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.parts = parts;
            this.sentIntents = sentIntents;
            this.deliveryIntents = deliveryIntents;
            this.messageId = messageId;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public List<String> getParts() {
            return this.parts;
        }

        public List<PendingIntent> getSentIntents() {
            return this.sentIntents;
        }

        public List<PendingIntent> getDeliveryIntents() {
            return this.deliveryIntents;
        }

        public long getMessageId() {
            return this.messageId;
        }
    }

    public static class TextSmsParams {
        private final String destinationAddress;
        private final String scAddress;
        private final String text;
        private final PendingIntent sentIntent;
        private final PendingIntent deliveryIntent;
        private final long messageId;

        public TextSmsParams(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent) {
            this(destinationAddress, scAddress, text, sentIntent, deliveryIntent, 0L);
        }

        public TextSmsParams(String destinationAddress, String scAddress, String text, PendingIntent sentIntent, PendingIntent deliveryIntent, long messageId) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.text = text;
            this.sentIntent = sentIntent;
            this.deliveryIntent = deliveryIntent;
            this.messageId = messageId;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public String getText() {
            return this.text;
        }

        public PendingIntent getSentIntent() {
            return this.sentIntent;
        }

        public PendingIntent getDeliveryIntent() {
            return this.deliveryIntent;
        }

        public long getMessageId() {
            return this.messageId;
        }
    }

    public static class DataMessageParams {
        private final String destinationAddress;
        private final String scAddress;
        private final short destinationPort;
        private final byte[] data;
        private final PendingIntent sentIntent;
        private final PendingIntent deliveryIntent;

        public DataMessageParams(String destinationAddress, String scAddress, short destinationPort, byte[] data, PendingIntent sentIntent, PendingIntent deliveryIntent) {
            this.destinationAddress = destinationAddress;
            this.scAddress = scAddress;
            this.destinationPort = destinationPort;
            this.data = data;
            this.sentIntent = sentIntent;
            this.deliveryIntent = deliveryIntent;
        }

        public String getDestinationAddress() {
            return this.destinationAddress;
        }

        public String getScAddress() {
            return this.scAddress;
        }

        public short getDestinationPort() {
            return this.destinationPort;
        }

        public byte[] getData() {
            return this.data;
        }

        public PendingIntent getSentIntent() {
            return this.sentIntent;
        }

        public PendingIntent getDeliveryIntent() {
            return this.deliveryIntent;
        }
    }
}

