/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.speech.tts.TextToSpeech;
import android.speech.tts.UtteranceProgressListener;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=TextToSpeech.class)
public class ShadowTextToSpeech {
    private static final Set<Locale> languageAvailabilities = new HashSet<Locale>();
    @RealObject
    private TextToSpeech tts;
    private Context context;
    private TextToSpeech.OnInitListener listener;
    private String lastSpokenText;
    private boolean shutdown = false;
    private boolean stopped = true;
    private int queueMode = -1;
    private Locale language = null;
    private String lastSynthesizeToFileText;

    @Implementation
    protected void __constructor__(Context context, TextToSpeech.OnInitListener listener) {
        this.context = context;
        this.listener = listener;
    }

    @Implementation
    protected int speak(String text, int queueMode, HashMap<String, String> params) {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return ((TextToSpeech)Shadow.directlyOn((Object)this.tts, TextToSpeech.class)).speak(text, queueMode, params);
        }
        return this.speak(text, queueMode, null, params == null ? null : params.get("utteranceId"));
    }

    @Implementation(minSdk=21)
    protected int speak(CharSequence text, int queueMode, Bundle params, String utteranceId) {
        this.stopped = false;
        this.lastSpokenText = text.toString();
        this.queueMode = queueMode;
        if (RuntimeEnvironment.getApiLevel() >= 15 && utteranceId != null) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(() -> {
                UtteranceProgressListener utteranceProgressListener = this.getUtteranceProgressListener();
                if (utteranceProgressListener != null) {
                    utteranceProgressListener.onStart(utteranceId);
                }
                handler.post(() -> {
                    UtteranceProgressListener utteranceProgressListener2 = this.getUtteranceProgressListener();
                    if (utteranceProgressListener2 != null) {
                        utteranceProgressListener2.onDone(utteranceId);
                    }
                });
            });
        }
        return 0;
    }

    @Implementation
    protected void shutdown() {
        this.shutdown = true;
    }

    @Implementation
    protected int stop() {
        this.stopped = true;
        return 0;
    }

    @Implementation
    protected int isLanguageAvailable(Locale lang) {
        for (Locale locale : languageAvailabilities) {
            if (!locale.getISO3Language().equals(lang.getISO3Language())) continue;
            if (locale.getISO3Country().equals(lang.getISO3Country())) {
                if (locale.getVariant().equals(lang.getVariant())) {
                    return 2;
                }
                return 1;
            }
            return 0;
        }
        return -2;
    }

    @Implementation
    protected int setLanguage(Locale locale) {
        this.language = locale;
        return this.isLanguageAvailable(locale);
    }

    @Implementation(minSdk=21)
    protected int synthesizeToFile(CharSequence text, Bundle params, File file, String utteranceId) {
        this.lastSynthesizeToFileText = text.toString();
        return 0;
    }

    private UtteranceProgressListener getUtteranceProgressListener() {
        return (UtteranceProgressListener)ReflectionHelpers.getField((Object)this.tts, (String)"mUtteranceProgressListener");
    }

    public Context getContext() {
        return this.context;
    }

    public TextToSpeech.OnInitListener getOnInitListener() {
        return this.listener;
    }

    public String getLastSpokenText() {
        return this.lastSpokenText;
    }

    public void clearLastSpokenText() {
        this.lastSpokenText = null;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public int getQueueMode() {
        return this.queueMode;
    }

    public Locale getCurrentLanguage() {
        return this.language;
    }

    public String getLastSynthesizeToFileText() {
        return this.lastSynthesizeToFileText;
    }

    public static void addLanguageAvailability(Locale locale) {
        languageAvailabilities.add(locale);
    }

    @Resetter
    public static void clearLanguageAvailabilities() {
        languageAvailabilities.clear();
    }
}

