/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.animation.AnimationHandler;
import android.animation.ValueAnimator;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ValueAnimator.class)
public class ShadowValueAnimator {
    @RealObject
    private ValueAnimator realObject;
    private int actualRepeatCount;

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            ThreadLocal animatorHandlerTL = (ThreadLocal)ReflectionHelpers.getStaticField(AnimationHandler.class, (String)"sAnimatorHandler");
            animatorHandlerTL.remove();
        } else {
            ReflectionHelpers.callStaticMethod(ValueAnimator.class, (String)"clearAllAnimations", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            ThreadLocal animatorHandlerTL = (ThreadLocal)ReflectionHelpers.getStaticField(ValueAnimator.class, (String)"sAnimationHandler");
            animatorHandlerTL.remove();
        }
    }

    @Implementation
    protected void setRepeatCount(int count) {
        this.actualRepeatCount = count;
        if (count == -1) {
            count = 1;
        }
        ((ValueAnimator)Shadow.directlyOn((Object)this.realObject, ValueAnimator.class)).setRepeatCount(count);
    }

    public int getActualRepeatCount() {
        return this.actualRepeatCount;
    }
}

