/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.fakes;

import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import org.robolectric.RuntimeEnvironment;

public class RoboMenuItem
implements MenuItem {
    private int itemId;
    private int groupId;
    private CharSequence title;
    private boolean enabled = true;
    private boolean checked = false;
    private boolean checkable = false;
    private boolean visible = true;
    private boolean expanded = false;
    private MenuItem.OnMenuItemClickListener menuItemClickListener;
    public Drawable icon;
    private Intent intent;
    private SubMenu subMenu;
    private View actionView;
    private MenuItem.OnActionExpandListener actionExpandListener;
    private int order;
    private Context context;

    public RoboMenuItem() {
        this((Context)RuntimeEnvironment.application);
    }

    public RoboMenuItem(Context context) {
        this.context = context;
    }

    public RoboMenuItem(int itemId) {
        this.itemId = itemId;
    }

    public void setItemId(int itemId) {
        this.itemId = itemId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public MenuItem setTitle(CharSequence title) {
        this.title = title;
        return this;
    }

    public MenuItem setTitle(int title) {
        return this;
    }

    public CharSequence getTitle() {
        return this.title;
    }

    public MenuItem setTitleCondensed(CharSequence title) {
        return this;
    }

    public CharSequence getTitleCondensed() {
        return null;
    }

    public MenuItem setIcon(Drawable icon) {
        this.icon = icon;
        return this;
    }

    public MenuItem setIcon(int iconRes) {
        this.icon = iconRes == 0 ? null : this.context.getResources().getDrawable(iconRes);
        return this;
    }

    public Drawable getIcon() {
        return this.icon;
    }

    public MenuItem setIntent(Intent intent) {
        this.intent = intent;
        return this;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public MenuItem setShortcut(char numericChar, char alphaChar) {
        return this;
    }

    public MenuItem setNumericShortcut(char numericChar) {
        return this;
    }

    public char getNumericShortcut() {
        return '\u0000';
    }

    public MenuItem setAlphabeticShortcut(char alphaChar) {
        return this;
    }

    public char getAlphabeticShortcut() {
        return '\u0000';
    }

    public MenuItem setCheckable(boolean checkable) {
        this.checkable = checkable;
        return this;
    }

    public boolean isCheckable() {
        return this.checkable;
    }

    public MenuItem setChecked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public MenuItem setVisible(boolean visible) {
        this.visible = visible;
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public MenuItem setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasSubMenu() {
        return this.subMenu != null;
    }

    public SubMenu getSubMenu() {
        return this.subMenu;
    }

    public void setSubMenu(SubMenu subMenu) {
        this.subMenu = subMenu;
    }

    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.menuItemClickListener = menuItemClickListener;
        return this;
    }

    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return null;
    }

    public void click() {
        if (this.enabled && this.menuItemClickListener != null) {
            this.menuItemClickListener.onMenuItemClick((MenuItem)this);
        } else if (this.enabled && this.intent != null) {
            this.context.startActivity(this.intent);
        }
    }

    public void setShowAsAction(int actionEnum) {
    }

    public MenuItem setShowAsActionFlags(int actionEnum) {
        return this;
    }

    public MenuItem setActionView(View view) {
        this.actionView = view;
        return this;
    }

    public MenuItem setActionView(int resId) {
        this.actionView = LayoutInflater.from((Context)this.context).inflate(resId, null);
        return this;
    }

    public View getActionView() {
        return this.actionView;
    }

    public MenuItem setActionProvider(ActionProvider actionProvider) {
        return this;
    }

    public ActionProvider getActionProvider() {
        return null;
    }

    public boolean expandActionView() {
        if (this.actionView != null) {
            if (this.actionExpandListener != null) {
                this.actionExpandListener.onMenuItemActionExpand((MenuItem)this);
            }
            this.expanded = true;
            return true;
        }
        return false;
    }

    public boolean collapseActionView() {
        if (this.actionView != null) {
            if (this.actionExpandListener != null) {
                this.actionExpandListener.onMenuItemActionCollapse((MenuItem)this);
            }
            this.expanded = false;
            return true;
        }
        return false;
    }

    public boolean isActionViewExpanded() {
        return this.expanded;
    }

    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener listener) {
        this.actionExpandListener = listener;
        return this;
    }
}

