/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowMessage;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Message.class, isInAndroidSdk=false)
public class ShadowLegacyMessage
extends ShadowMessage {
    @RealObject
    private Message realMessage;
    private Runnable scheduledRunnable;

    private void unschedule() {
        Handler target = this.realMessage.getTarget();
        if (target != null && this.scheduledRunnable != null) {
            ShadowLegacyMessage.shadowOf(target.getLooper()).getScheduler().remove(this.scheduledRunnable);
            this.scheduledRunnable = null;
        }
    }

    @Override
    @HiddenApi
    @Implementation(minSdk=21)
    public void recycleUnchecked() {
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            this.unschedule();
            Shadow.directlyOn((Object)this.realMessage, Message.class, (String)"recycleUnchecked", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        } else {
            this.recycle();
        }
    }

    @Implementation(maxSdk=20)
    protected void recycle() {
        this.unschedule();
        Shadow.directlyOn((Object)this.realMessage, Message.class, (String)"recycle", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Override
    public void setScheduledRunnable(Runnable r) {
        this.scheduledRunnable = r;
    }

    @Implementation
    protected boolean isInUse() {
        return (Boolean)Shadow.directlyOn((Object)this.realMessage, Message.class, (String)"isInUse", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    @Override
    public Message getNext() {
        return ((_Message_)Reflector.reflector(_Message_.class, (Object)this.realMessage)).getNext();
    }

    @Override
    public void setNext(Message next) {
        ((_Message_)Reflector.reflector(_Message_.class, (Object)this.realMessage)).setNext(next);
    }

    private static ShadowLooper shadowOf(Looper looper) {
        return (ShadowLooper)Shadow.extract((Object)looper);
    }

    @ForType(value=Message.class)
    static interface _Message_ {
        public void markInUse();

        public void recycleUnchecked();

        public void recycle();

        @Accessor(value="next")
        public Message getNext();

        @Accessor(value="next")
        public void setNext(Message var1);
    }
}

