/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.VersionedPackage;
import android.content.rollback.PackageRollbackInfo;
import android.util.IntArray;
import android.util.SparseLongArray;
import androidx.annotation.Nullable;
import androidx.test.internal.util.Checks;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public final class PackageRollbackInfoBuilder {
    @Nullable
    private VersionedPackage packageRolledBackFrom;
    @Nullable
    private VersionedPackage packageRolledBackTo;
    private final IntArray pendingBackups = new IntArray();
    private final ArrayList<PackageRollbackInfo.RestoreInfo> pendingRestores = new ArrayList();
    private boolean isApex;
    private boolean isApkInApex;
    private final IntArray installedUsers = new IntArray();
    private final IntArray snapshottedUsers = new IntArray();
    private SparseLongArray ceSnapshotInodes = new SparseLongArray();

    private PackageRollbackInfoBuilder() {
    }

    public static PackageRollbackInfoBuilder newBuilder() {
        return new PackageRollbackInfoBuilder();
    }

    public PackageRollbackInfoBuilder setPackageRolledBackFrom(VersionedPackage packageRolledBackFrom) {
        this.packageRolledBackFrom = packageRolledBackFrom;
        return this;
    }

    public PackageRollbackInfoBuilder setPackageRolledBackTo(VersionedPackage packageRolledBackTo) {
        this.packageRolledBackTo = packageRolledBackTo;
        return this;
    }

    public PackageRollbackInfoBuilder addPendingBackup(int pendingBackup) {
        this.pendingBackups.add(pendingBackup);
        return this;
    }

    public PackageRollbackInfoBuilder addPendingRestore(int userId, int appId, String seInfo) {
        this.pendingRestores.add(new PackageRollbackInfo.RestoreInfo(userId, appId, seInfo));
        return this;
    }

    public PackageRollbackInfoBuilder setIsApex(boolean isApex) {
        this.isApex = isApex;
        return this;
    }

    public PackageRollbackInfoBuilder setIsApkInApex(boolean isApkInApex) {
        this.isApkInApex = isApkInApex;
        return this;
    }

    public PackageRollbackInfoBuilder addInstalledUser(int installedUser) {
        this.installedUsers.add(installedUser);
        return this;
    }

    public PackageRollbackInfoBuilder addSnapshottedUser(int snapshottedUser) {
        this.snapshottedUsers.add(snapshottedUser);
        return this;
    }

    public PackageRollbackInfoBuilder setCeSnapshotInodes(SparseLongArray ceSnapshotInodes) {
        Checks.checkNotNull((Object)ceSnapshotInodes, (Object)"Field 'packageRolledBackFrom' not allowed to be null.");
        this.ceSnapshotInodes = ceSnapshotInodes;
        return this;
    }

    private List<Integer> getPendingBackupsList() {
        ArrayList<Integer> pendingBackupsList = new ArrayList<Integer>();
        for (int pendingBackup : this.pendingBackups.toArray()) {
            pendingBackupsList.add(pendingBackup);
        }
        return pendingBackupsList;
    }

    private List<Integer> getSnapshottedUsersList() {
        ArrayList<Integer> snapshottedUsersList = new ArrayList<Integer>();
        for (int snapshottedUser : this.snapshottedUsers.toArray()) {
            snapshottedUsersList.add(snapshottedUser);
        }
        return snapshottedUsersList;
    }

    public PackageRollbackInfo build() {
        Checks.checkNotNull((Object)this.packageRolledBackFrom, (Object)"Mandatory field 'packageRolledBackFrom' missing.");
        Checks.checkNotNull((Object)this.packageRolledBackTo, (Object)"Mandatory field 'packageRolledBackTo' missing.");
        Preconditions.checkState((RuntimeEnvironment.getApiLevel() >= 29 ? 1 : 0) != 0);
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel == 29) {
            return (PackageRollbackInfo)ReflectionHelpers.callConstructor(PackageRollbackInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.packageRolledBackFrom), ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.packageRolledBackTo), ReflectionHelpers.ClassParameter.from(IntArray.class, (Object)this.pendingBackups), ReflectionHelpers.ClassParameter.from(ArrayList.class, this.pendingRestores), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isApex), ReflectionHelpers.ClassParameter.from(IntArray.class, (Object)this.installedUsers), ReflectionHelpers.ClassParameter.from(SparseLongArray.class, (Object)this.ceSnapshotInodes)});
        }
        if (apiLevel == 30) {
            return new PackageRollbackInfo(this.packageRolledBackFrom, this.packageRolledBackTo, this.pendingBackups, this.pendingRestores, this.isApex, this.isApkInApex, this.snapshottedUsers, this.ceSnapshotInodes);
        }
        if (apiLevel > 30) {
            return (PackageRollbackInfo)ReflectionHelpers.callConstructor(PackageRollbackInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.packageRolledBackFrom), ReflectionHelpers.ClassParameter.from(VersionedPackage.class, (Object)this.packageRolledBackTo), ReflectionHelpers.ClassParameter.from(List.class, this.getPendingBackupsList()), ReflectionHelpers.ClassParameter.from(ArrayList.class, this.pendingRestores), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isApex), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.isApkInApex), ReflectionHelpers.ClassParameter.from(List.class, this.getSnapshottedUsersList())});
        }
        throw new UnsupportedOperationException("PackageRollbacakInfoBuilder requires SDK >= Q");
    }
}

