/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.media.session.MediaController;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public class PlaybackInfoBuilder {
    private int volumeType;
    private int volumeControl;
    private int maxVolume;
    private int currentVolume;
    private AudioAttributes audioAttrs;

    private PlaybackInfoBuilder() {
    }

    public static PlaybackInfoBuilder newBuilder() {
        return new PlaybackInfoBuilder();
    }

    public PlaybackInfoBuilder setVolumeType(int volumeType) {
        this.volumeType = volumeType;
        return this;
    }

    public PlaybackInfoBuilder setVolumeControl(int volumeControl) {
        this.volumeControl = volumeControl;
        return this;
    }

    public PlaybackInfoBuilder setMaxVolume(int maxVolume) {
        this.maxVolume = maxVolume;
        return this;
    }

    public PlaybackInfoBuilder setCurrentVolume(int currentVolume) {
        this.currentVolume = currentVolume;
        return this;
    }

    public PlaybackInfoBuilder setAudioAttributes(AudioAttributes audioAttrs) {
        this.audioAttrs = audioAttrs;
        return this;
    }

    public MediaController.PlaybackInfo build() {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel == 29) {
            return new MediaController.PlaybackInfo(this.volumeType, this.volumeControl, this.maxVolume, this.currentVolume, this.audioAttrs);
        }
        if (apiLevel > 29) {
            return new MediaController.PlaybackInfo(this.volumeType, this.volumeControl, this.maxVolume, this.currentVolume, this.audioAttrs, null);
        }
        return (MediaController.PlaybackInfo)ReflectionHelpers.callConstructor(MediaController.PlaybackInfo.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.volumeType), ReflectionHelpers.ClassParameter.from(AudioAttributes.class, (Object)this.audioAttrs), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.volumeControl), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.maxVolume), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.currentVolume)});
    }
}

