/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.ActivityThread;
import android.app.Application;
import android.app.Instrumentation;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.IBinder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ActivityThread.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowActivityThread {
    private static ApplicationInfo applicationInfo;
    @RealObject
    protected ActivityThread realActivityThread;

    @Implementation
    public static Object getPackageManager() {
        Class<?> iPackageManagerClass;
        ClassLoader classLoader = ShadowActivityThread.class.getClassLoader();
        try {
            iPackageManagerClass = classLoader.loadClass("android.content.pm.IPackageManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iPackageManagerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Exception {
                if (method.getName().equals("getApplicationInfo")) {
                    String packageName = (String)args[0];
                    int flags = (Integer)args[1];
                    if (packageName.equals(applicationInfo.packageName)) {
                        return applicationInfo;
                    }
                    try {
                        return RuntimeEnvironment.getApplication().getPackageManager().getApplicationInfo(packageName, flags);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        return null;
                    }
                }
                if (method.getName().equals("notifyPackageUse")) {
                    return null;
                }
                if (method.getName().equals("getPackageInstaller")) {
                    return null;
                }
                String string2 = String.valueOf(method);
                throw new UnsupportedOperationException(new StringBuilder(27 + String.valueOf(string2).length()).append("sorry, not supporting ").append(string2).append(" yet!").toString());
            }
        });
    }

    @Implementation
    public static Object currentActivityThread() {
        return RuntimeEnvironment.getActivityThread();
    }

    @Implementation
    protected static Application currentApplication() {
        return ((ActivityThread)ShadowActivityThread.currentActivityThread()).getApplication();
    }

    @Implementation
    protected Application getApplication() {
        Application currentApplication = ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).getInitialApplication();
        if (currentApplication == null) {
            return RuntimeEnvironment.getApplication();
        }
        return currentApplication;
    }

    @Implementation(minSdk=30)
    public static Object getPermissionManager() {
        Class<?> iPermissionManagerClass;
        ClassLoader classLoader = ShadowActivityThread.class.getClassLoader();
        try {
            iPermissionManagerClass = classLoader.loadClass("android.permission.IPermissionManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iPermissionManagerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Exception {
                if (method.getName().equals("getSplitPermissions")) {
                    return Collections.emptyList();
                }
                return method.getDefaultValue();
            }
        });
    }

    IBinder registerActivityLaunch(Intent intent, ActivityInfo activityInfo, Activity activity) {
        Binder token = new Binder();
        ActivityThread.ActivityClientRecord record = new ActivityThread.ActivityClientRecord();
        ActivityClientRecordReflector recordReflector = (ActivityClientRecordReflector)Reflector.reflector(ActivityClientRecordReflector.class, (Object)record);
        recordReflector.setToken((IBinder)token);
        recordReflector.setIntent(intent);
        recordReflector.setActivityInfo(activityInfo);
        recordReflector.setActivity(activity);
        ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).getActivities().put((IBinder)token, record);
        return token;
    }

    void removeActivity(IBinder token) {
        ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).getActivities().remove(token);
    }

    @Deprecated
    public static void setApplicationInfo(ApplicationInfo applicationInfo) {
        ShadowActivityThread.applicationInfo = applicationInfo;
    }

    public void setCompatConfiguration(Configuration androidConfiguration) {
        ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)this.realActivityThread)).setCompatConfiguration(androidConfiguration);
    }

    @Resetter
    public static void reset() {
        ((_ActivityThread_)Reflector.reflector(_ActivityThread_.class, (Object)RuntimeEnvironment.getActivityThread())).getActivities().clear();
    }

    @ForType(value=ActivityThread.ActivityClientRecord.class)
    private static interface ActivityClientRecordReflector {
        @Accessor(value="activity")
        public void setActivity(Activity var1);

        @Accessor(value="token")
        public void setToken(IBinder var1);

        @Accessor(value="intent")
        public void setIntent(Intent var1);

        @Accessor(value="activityInfo")
        public void setActivityInfo(ActivityInfo var1);
    }

    @ForType(className="android.app.ActivityThread$AppBindData")
    public static interface _AppBindData_ {
        @Accessor(value="appInfo")
        public void setAppInfo(ApplicationInfo var1);

        @Accessor(value="processName")
        public void setProcessName(String var1);
    }

    @ForType(value=ActivityThread.class)
    public static interface _ActivityThread_ {
        @Accessor(value="mBoundApplication")
        public void setBoundApplication(Object var1);

        @Accessor(value="mBoundApplication")
        public Object getBoundApplication();

        @Accessor(value="mCompatConfiguration")
        public void setCompatConfiguration(Configuration var1);

        @Accessor(value="mInitialApplication")
        public void setInitialApplication(Application var1);

        @Accessor(value="mInitialApplication")
        public Application getInitialApplication();

        @Accessor(value="mInstrumentation")
        public void setInstrumentation(Instrumentation var1);

        @Accessor(value="mActivities")
        public Map<IBinder, ActivityThread.ActivityClientRecord> getActivities();
    }
}

