/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.util.LongSparseArray;
import android.util.LongSparseLongArray;
import com.android.internal.app.IAppOpsService;
import com.google.auto.value.AutoValue;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.AutoValue_ShadowAppOpsManager_Key;
import org.robolectric.shadows.ShadowApplicationPackageManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AppOpsManager.class)
public class ShadowAppOpsManager {
    protected static final long OP_TIME = 1400000000L;
    protected static final long REJECT_TIME = 0L;
    protected static final int DURATION = 10;
    protected static final int PROXY_UID = 0;
    protected static final String PROXY_PACKAGE = "";
    @RealObject
    private AppOpsManager realObject;
    private static boolean staticallyInitialized = false;
    private final Multimap<Key, Integer> storedOps = HashMultimap.create();
    private final Map<Key, Integer> appModeMap = new HashMap<Key, Integer>();
    private final Set<Key> longRunningOp = new HashSet<Key>();
    private final BiMap<Key, AppOpsManager.OnOpChangedListener> appOpListeners = HashBiMap.create();
    private final Map<Integer, ModeAndException> audioRestrictions = new HashMap<Integer, ModeAndException>();
    private Context context;

    @Implementation(minSdk=19)
    protected void __constructor__(Context context, IAppOpsService service) {
        this.context = context;
        Shadow.invokeConstructor(AppOpsManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(IAppOpsService.class, (Object)service)});
    }

    @Implementation(minSdk=19)
    protected static void __staticInitializer__() {
        staticallyInitialized = true;
        Shadow.directInitialize(AppOpsManager.class);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    @SystemApi
    public void setMode(String op, int uid, String packageName, int mode) {
        this.setMode(AppOpsManager.strOpToOp((String)op), uid, packageName, mode);
    }

    @Implementation(minSdk=19)
    @HiddenApi
    public void setMode(int op, int uid, String packageName, int mode) {
        Integer oldMode = this.appModeMap.put(Key.create(uid, packageName, op), mode);
        AppOpsManager.OnOpChangedListener listener = (AppOpsManager.OnOpChangedListener)this.appOpListeners.get((Object)Key.create(null, packageName, op));
        if (listener != null && !Objects.equals(oldMode, mode)) {
            String[] sOpToString = (String[])ReflectionHelpers.getStaticField(AppOpsManager.class, (String)"sOpToString");
            listener.onOpChanged(sOpToString[op], packageName);
        }
    }

    @Implementation(minSdk=29)
    @HiddenApi
    @SystemApi
    protected List<AppOpsManager.PackageOps> getPackagesForOps(String[] ops) {
        List<Object> result = null;
        if (ops == null) {
            int[] intOps = null;
            result = this.getPackagesForOps(intOps);
        } else {
            ArrayList<Integer> intOpsList = new ArrayList<Integer>();
            for (String op : ops) {
                intOpsList.add(AppOpsManager.strOpToOp((String)op));
            }
            result = this.getPackagesForOps(intOpsList.stream().mapToInt(i -> i).toArray());
        }
        return result != null ? result : new ArrayList();
    }

    @Implementation(minSdk=19)
    @HiddenApi
    protected List<AppOpsManager.PackageOps> getPackagesForOps(int[] ops) {
        Set<Object> relevantOps = ops != null ? IntStream.of(ops).boxed().collect(Collectors.toSet()) : new HashSet();
        SetMultimap perPackageMap = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Map.Entry<Key, Integer> appOpInfo : this.appModeMap.entrySet()) {
            Key key = appOpInfo.getKey();
            if (ops != null && !relevantOps.contains(key.getOpCode())) continue;
            Key packageKey = Key.create(key.getUid(), key.getPackageName(), null);
            AppOpsManager.OpEntry opEntry = this.toOpEntry(key.getOpCode(), appOpInfo.getValue());
            perPackageMap.put((Object)packageKey, (Object)opEntry);
        }
        ArrayList<AppOpsManager.PackageOps> result = new ArrayList<AppOpsManager.PackageOps>();
        for (Map.Entry packageInfo : perPackageMap.asMap().entrySet()) {
            Key key = (Key)packageInfo.getKey();
            result.add(new AppOpsManager.PackageOps(key.getPackageName(), key.getUid().intValue(), new ArrayList((Collection)packageInfo.getValue())));
        }
        return result.isEmpty() ? null : result;
    }

    @Implementation(minSdk=29)
    public int unsafeCheckOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp((String)op), uid, packageName);
    }

    private int unsafeCheckOpRawNoThrow(int op, int uid, String packageName) {
        Integer mode = this.appModeMap.get(Key.create(uid, packageName, op));
        if (mode == null) {
            return 0;
        }
        return mode;
    }

    @Implementation(minSdk=30)
    protected int startOp(String op, int uid, String packageName, String attributionTag, String message) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        if (mode == 0) {
            this.longRunningOp.add(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
        }
        return mode;
    }

    @Implementation(minSdk=19, maxSdk=29)
    protected int startOpNoThrow(int op, int uid, String packageName) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        if (mode == 0) {
            this.longRunningOp.add(Key.create(uid, packageName, op));
        }
        return mode;
    }

    @Implementation(minSdk=30)
    protected int startOpNoThrow(String op, int uid, String packageName, String attributionTag, String message) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        if (mode == 0) {
            this.longRunningOp.add(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
        }
        return mode;
    }

    @Implementation(minSdk=19, maxSdk=29)
    protected void finishOp(int op, int uid, String packageName) {
        this.longRunningOp.remove(Key.create(uid, packageName, op));
    }

    @Implementation(minSdk=30)
    protected void finishOp(String op, int uid, String packageName, String attributionTag) {
        this.longRunningOp.remove(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
    }

    @Implementation(minSdk=30)
    protected int checkOp(String op, int uid, String packageName) {
        return this.checkOpNoThrow(op, uid, packageName);
    }

    @Implementation(minSdk=30)
    protected boolean isOpActive(String op, int uid, String packageName) {
        return this.longRunningOp.contains(Key.create(uid, packageName, AppOpsManager.strOpToOp((String)op)));
    }

    @Implementation(minSdk=29)
    public int unsafeCheckOpRawNoThrow(String op, int uid, String packageName) {
        return this.unsafeCheckOpRawNoThrow(AppOpsManager.strOpToOp((String)op), uid, packageName);
    }

    @Implementation(minSdk=28)
    @Deprecated
    protected int checkOpNoThrow(String op, int uid, String packageName) {
        return this.checkOpNoThrow(AppOpsManager.strOpToOp((String)op), uid, packageName);
    }

    @Implementation(minSdk=19)
    @HiddenApi
    public int checkOpNoThrow(int op, int uid, String packageName) {
        int mode = this.unsafeCheckOpRawNoThrow(op, uid, packageName);
        return mode == 4 ? 0 : mode;
    }

    @Implementation(minSdk=19)
    public int noteOp(int op, int uid, String packageName) {
        this.storedOps.put((Object)Key.create(uid, packageName, null), (Object)op);
        return 0;
    }

    @Implementation(minSdk=30)
    protected int noteOp(int op, int uid, String packageName, String attributionTag, String message) {
        return this.noteOp(op, uid, packageName);
    }

    @Implementation(minSdk=19)
    protected int noteOpNoThrow(int op, int uid, String packageName) {
        this.storedOps.put((Object)Key.create(uid, packageName, null), (Object)op);
        return this.checkOpNoThrow(op, uid, packageName);
    }

    @Implementation(minSdk=30)
    protected int noteOpNoThrow(int op, int uid, String packageName, String attributionTag, String message) {
        return this.noteOpNoThrow(op, uid, packageName);
    }

    @Implementation(minSdk=23, maxSdk=29)
    @HiddenApi
    protected int noteProxyOpNoThrow(int op, String proxiedPackageName) {
        this.storedOps.put((Object)Key.create(Binder.getCallingUid(), proxiedPackageName, null), (Object)op);
        return this.checkOpNoThrow(op, Binder.getCallingUid(), proxiedPackageName);
    }

    @Implementation(minSdk=29, maxSdk=29)
    @HiddenApi
    protected int noteProxyOpNoThrow(int op, String proxiedPackageName, int proxiedUid) {
        this.storedOps.put((Object)Key.create(proxiedUid, proxiedPackageName, null), (Object)op);
        return this.checkOpNoThrow(op, proxiedUid, proxiedPackageName);
    }

    @Implementation(minSdk=30)
    @HiddenApi
    protected int noteProxyOpNoThrow(int op, String proxiedPackageName, int proxiedUid, String proxiedAttributionTag, String message) {
        this.storedOps.put((Object)Key.create(proxiedUid, proxiedPackageName, null), (Object)op);
        return this.checkOpNoThrow(op, proxiedUid, proxiedPackageName);
    }

    @Implementation(minSdk=19)
    @HiddenApi
    public List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, int[] ops) {
        HashSet<Integer> opFilter = new HashSet<Integer>();
        if (ops != null) {
            for (int op : ops) {
                opFilter.add(op);
            }
        }
        ArrayList<AppOpsManager.OpEntry> opEntries = new ArrayList<AppOpsManager.OpEntry>();
        for (Integer op : this.storedOps.get((Object)Key.create(uid, packageName, null))) {
            if (!opFilter.isEmpty() && !opFilter.contains(op)) continue;
            opEntries.add(this.toOpEntry(op, 0));
        }
        return ImmutableList.of((Object)new AppOpsManager.PackageOps(packageName, uid, opEntries));
    }

    @Implementation(minSdk=29)
    @HiddenApi
    @SystemApi
    protected List<AppOpsManager.PackageOps> getOpsForPackage(int uid, String packageName, String[] ops) {
        if (ops == null) {
            int[] intOps = null;
            return this.getOpsForPackage(uid, packageName, intOps);
        }
        Map strOpToIntOp = (Map)ReflectionHelpers.getStaticField(AppOpsManager.class, (String)"sOpStrToOp");
        ArrayList<Integer> intOpsList = new ArrayList<Integer>();
        for (String op : ops) {
            Integer intOp = (Integer)strOpToIntOp.get(op);
            if (intOp == null) continue;
            intOpsList.add(intOp);
        }
        return this.getOpsForPackage(uid, packageName, intOpsList.stream().mapToInt(i -> i).toArray());
    }

    @Implementation(minSdk=19)
    protected void checkPackage(int uid, String packageName) {
        try {
            ShadowApplicationPackageManager shadowApplicationPackageManager = (ShadowApplicationPackageManager)Shadow.extract((Object)this.context.getPackageManager());
            int packageUid = shadowApplicationPackageManager.getPackageUid(packageName, 0);
            if (packageUid == uid) {
                return;
            }
            throw new SecurityException(new StringBuilder(31 + String.valueOf(packageName).length()).append("Package ").append(packageName).append(" belongs to ").append(packageUid).toString());
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new SecurityException(new StringBuilder(38 + String.valueOf(packageName).length()).append("Package ").append(packageName).append(" doesn't belong to ").append(uid).toString(), e);
        }
    }

    @Implementation(minSdk=21)
    @HiddenApi
    public void setRestriction(int code, int usage, int mode, String[] exceptionPackages) {
        this.audioRestrictions.put(ShadowAppOpsManager.getAudioRestrictionKey(code, usage), new ModeAndException(mode, exceptionPackages));
    }

    public ModeAndException getRestriction(int code, int usage) {
        return this.audioRestrictions.get(ShadowAppOpsManager.getAudioRestrictionKey(code, usage));
    }

    @Implementation(minSdk=19)
    @HiddenApi
    protected void startWatchingMode(int op, String packageName, AppOpsManager.OnOpChangedListener callback) {
        this.appOpListeners.put((Object)Key.create(null, packageName, op), (Object)callback);
    }

    @Implementation(minSdk=19)
    protected void stopWatchingMode(AppOpsManager.OnOpChangedListener callback) {
        this.appOpListeners.inverse().remove((Object)callback);
    }

    protected AppOpsManager.OpEntry toOpEntry(Integer op, int mode) {
        if (RuntimeEnvironment.getApiLevel() < 23) {
            return (AppOpsManager.OpEntry)ReflectionHelpers.callConstructor(AppOpsManager.OpEntry.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)op), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)1400000000L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)10)});
        }
        if (RuntimeEnvironment.getApiLevel() < 29) {
            return (AppOpsManager.OpEntry)ReflectionHelpers.callConstructor(AppOpsManager.OpEntry.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)op), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)1400000000L), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)0L), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)10), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(String.class, (Object)PROXY_PACKAGE)});
        }
        if (RuntimeEnvironment.getApiLevel() < 30) {
            long key = AppOpsManager.makeKey((int)200, (int)1);
            LongSparseLongArray accessTimes = new LongSparseLongArray();
            accessTimes.put(key, 1400000000L);
            LongSparseLongArray rejectTimes = new LongSparseLongArray();
            rejectTimes.put(key, 0L);
            LongSparseLongArray durations = new LongSparseLongArray();
            durations.put(key, 10L);
            LongSparseLongArray proxyUids = new LongSparseLongArray();
            proxyUids.put(key, 0L);
            LongSparseArray proxyPackages = new LongSparseArray();
            proxyPackages.put(key, (Object)PROXY_PACKAGE);
            return (AppOpsManager.OpEntry)ReflectionHelpers.callConstructor(AppOpsManager.OpEntry.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)op), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)accessTimes), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)rejectTimes), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)durations), ReflectionHelpers.ClassParameter.from(LongSparseLongArray.class, (Object)proxyUids), ReflectionHelpers.ClassParameter.from(LongSparseArray.class, (Object)proxyPackages)});
        }
        long key = AppOpsManager.makeKey((int)200, (int)1);
        LongSparseArray accessEvents = new LongSparseArray();
        LongSparseArray rejectEvents = new LongSparseArray();
        accessEvents.put(key, (Object)new AppOpsManager.NoteOpEvent(1400000000L, 10L, new AppOpsManager.OpEventProxyInfo(0, PROXY_PACKAGE, null)));
        rejectEvents.put(key, (Object)new AppOpsManager.NoteOpEvent(0L, -1L, null));
        return new AppOpsManager.OpEntry(op.intValue(), mode, Collections.singletonMap(null, new AppOpsManager.AttributedOpEntry(op.intValue(), false, accessEvents, rejectEvents)));
    }

    private static int getAudioRestrictionKey(int code, int usage) {
        return code | usage << 8;
    }

    @Resetter
    public static void reset() {
        if (RuntimeEnvironment.getApiLevel() >= 30 && staticallyInitialized) {
            ReflectionHelpers.setStaticField(AppOpsManager.class, (String)"sOnOpNotedCallback", null);
        }
    }

    public static class ModeAndException {
        public final int mode;
        public final List<String> exceptionPackages;

        public ModeAndException(int mode, String[] exceptionPackages) {
            this.mode = mode;
            this.exceptionPackages = exceptionPackages == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(exceptionPackages));
        }
    }

    @AutoValue
    static abstract class Key {
        Key() {
        }

        abstract Integer getUid();

        abstract String getPackageName();

        abstract Integer getOpCode();

        static Key create(Integer uid, String packageName, Integer opCode) {
            return new AutoValue_ShadowAppOpsManager_Key(uid, packageName, opCode);
        }
    }
}

