/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.util.TypedValue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ImageUtil;
import org.robolectric.shadows.ShadowAssetInputStream;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.util.Join;
import org.robolectric.util.Logger;
import org.robolectric.util.NamedStream;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=BitmapFactory.class)
public class ShadowBitmapFactory {
    private static Map<String, Point> widthAndHeightMap = new HashMap<String, Point>();
    private static boolean allowInvalidImageData = true;

    @Implementation
    protected static Bitmap decodeResourceStream(Resources res, TypedValue value, InputStream is, Rect pad, BitmapFactory.Options opts) {
        Bitmap bitmap = (Bitmap)Shadow.directlyOn(BitmapFactory.class, (String)"decodeResourceStream", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)res), ReflectionHelpers.ClassParameter.from(TypedValue.class, (Object)value), ReflectionHelpers.ClassParameter.from(InputStream.class, (Object)is), ReflectionHelpers.ClassParameter.from(Rect.class, (Object)pad), ReflectionHelpers.ClassParameter.from(BitmapFactory.Options.class, (Object)opts)});
        if (value != null && value.string != null && value.string.toString().contains(".9.")) {
            ReflectionHelpers.callInstanceMethod((Object)bitmap, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)new byte[0])});
        }
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeResource(Resources res, int id2, BitmapFactory.Options options) {
        if (id2 == 0) {
            return null;
        }
        TypedValue value = new TypedValue();
        InputStream is = res.openRawResource(id2, value);
        ImageUtil.RobolectricBufferedImage image = ImageUtil.getImageFromStream(is);
        if (!allowInvalidImageData && image == null) {
            if (options != null) {
                options.outWidth = -1;
                options.outHeight = -1;
            }
            return null;
        }
        String string2 = String.valueOf(res.getResourceName(id2));
        Bitmap bitmap = ShadowBitmapFactory.create(string2.length() != 0 ? "resource:".concat(string2) : new String("resource:"), options, image);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromResId = id2;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeFile(String pathName) {
        return ShadowBitmapFactory.decodeFile(pathName, null);
    }

    @Implementation
    protected static Bitmap decodeFile(String pathName, BitmapFactory.Options options) {
        ImageUtil.RobolectricBufferedImage image = null;
        if (pathName != null && new File(pathName).exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(pathName);
                 BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
                image = ImageUtil.getImageFromStream(bufferedInputStream);
            }
            catch (IOException e) {
                Logger.warn((String)"Error getting size of bitmap file", (Object[])new Object[]{e});
            }
        }
        if (!allowInvalidImageData && image == null) {
            if (options != null) {
                options.outWidth = -1;
                options.outHeight = -1;
            }
            return null;
        }
        String string2 = String.valueOf(pathName);
        Bitmap bitmap = ShadowBitmapFactory.create(string2.length() != 0 ? "file:".concat(string2) : new String("file:"), options, image);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromPath = pathName;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeFileDescriptor(FileDescriptor fd, Rect outPadding, BitmapFactory.Options opts) {
        Object bufferedInputStream;
        ImageUtil.RobolectricBufferedImage image = null;
        if (fd != null && fd.valid()) {
            try (FileInputStream fileInputStream = new FileInputStream(fd);){
                bufferedInputStream = new BufferedInputStream(fileInputStream);
                try {
                    image = ImageUtil.getImageFromStream((InputStream)bufferedInputStream);
                }
                finally {
                    ((BufferedInputStream)bufferedInputStream).close();
                }
            }
            catch (IOException e) {
                Logger.warn((String)"Error getting size of bitmap file", (Object[])new Object[]{e});
            }
        }
        if (!allowInvalidImageData && image == null) {
            if (opts != null) {
                opts.outWidth = -1;
                opts.outHeight = -1;
            }
            return null;
        }
        bufferedInputStream = String.valueOf(fd);
        Bitmap bitmap = ShadowBitmapFactory.create(new StringBuilder(3 + String.valueOf(bufferedInputStream).length()).append("fd:").append((String)bufferedInputStream).toString(), outPadding, opts, null, image);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromFileDescriptor = fd;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeStream(InputStream is) {
        return ShadowBitmapFactory.decodeStream(is, null, null);
    }

    @Implementation
    protected static Bitmap decodeStream(InputStream is, Rect outPadding, BitmapFactory.Options opts) {
        ImageUtil.RobolectricBufferedImage image;
        byte[] ninePatchChunk = null;
        if (is instanceof AssetManager.AssetInputStream) {
            ShadowAssetInputStream sais = (ShadowAssetInputStream)Shadow.extract((Object)is);
            if (sais.isNinePatch()) {
                ninePatchChunk = new byte[]{};
            }
            if (sais.getDelegate() != null) {
                is = sais.getDelegate();
            }
        }
        try {
            if (is != null) {
                is.reset();
            }
        }
        catch (IOException sais) {
            // empty catch block
        }
        boolean isNamedStream = is instanceof NamedStream;
        String name = isNamedStream ? is.toString().replace("stream for ", "") : null;
        ImageUtil.RobolectricBufferedImage robolectricBufferedImage = image = isNamedStream ? null : ImageUtil.getImageFromStream(is);
        if (!allowInvalidImageData && image == null) {
            if (opts != null) {
                opts.outWidth = -1;
                opts.outHeight = -1;
            }
            return null;
        }
        Bitmap bitmap = ShadowBitmapFactory.create(name, outPadding, opts, null, image);
        ReflectionHelpers.callInstanceMethod((Object)bitmap, (String)"setNinePatchChunk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(byte[].class, (Object)ninePatchChunk)});
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromStream = is;
        if (image != null && opts != null) {
            opts.outMimeType = image.getMimeType();
        }
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeByteArray(byte[] data, int offset, int length) {
        Bitmap bitmap = ShadowBitmapFactory.decodeByteArray(data, offset, length, new BitmapFactory.Options());
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromBytes = data;
        return bitmap;
    }

    @Implementation
    protected static Bitmap decodeByteArray(byte[] data, int offset, int length, BitmapFactory.Options opts) {
        String desc = new String(data, StandardCharsets.UTF_8);
        if (offset != 0 || length != data.length) {
            String string2 = String.valueOf(desc);
            desc = new StringBuilder(31 + String.valueOf(string2).length()).append(string2).append(" bytes ").append(offset).append("..").append(length).toString();
        }
        ByteArrayInputStream is = new ByteArrayInputStream(data, offset, length);
        ImageUtil.RobolectricBufferedImage image = ImageUtil.getImageFromStream(is);
        if (!allowInvalidImageData && image == null) {
            if (opts != null) {
                opts.outWidth = -1;
                opts.outHeight = -1;
            }
            return null;
        }
        Bitmap bitmap = ShadowBitmapFactory.create(desc, opts, image);
        return bitmap;
    }

    static Bitmap create(String name) {
        return ShadowBitmapFactory.create(name, null);
    }

    @Deprecated
    public static Bitmap create(String name, BitmapFactory.Options options) {
        return ShadowBitmapFactory.create(name, options, (Point)null);
    }

    @Deprecated
    public static Bitmap create(String name, BitmapFactory.Options options, Point widthAndHeight) {
        return ShadowBitmapFactory.create(name, null, options, widthAndHeight, null);
    }

    private static Bitmap create(String name, BitmapFactory.Options options, ImageUtil.RobolectricBufferedImage image) {
        return ShadowBitmapFactory.create(name, null, options, null, image);
    }

    private static Bitmap create(String name, Rect outPadding, BitmapFactory.Options options, Point widthAndHeightOverride, ImageUtil.RobolectricBufferedImage image) {
        String string2;
        Bitmap bitmap = (Bitmap)Shadow.newInstanceOf(Bitmap.class);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        if (name == null) {
            string2 = "Bitmap";
        } else {
            String string3 = String.valueOf(name);
            string2 = string3.length() != 0 ? "Bitmap for ".concat(string3) : new String("Bitmap for ");
        }
        shadowBitmap.appendDescription(string2);
        Bitmap.Config config = options != null && options.inPreferredConfig != null ? options.inPreferredConfig : Bitmap.Config.ARGB_8888;
        shadowBitmap.setConfig(config);
        String optionsString = ShadowBitmapFactory.stringify(options);
        if (!optionsString.isEmpty()) {
            shadowBitmap.appendDescription(" with options ");
            shadowBitmap.appendDescription(optionsString);
        }
        Point p = new Point(ShadowBitmapFactory.selectWidthAndHeight(name, widthAndHeightOverride, image));
        if (options != null && options.inSampleSize > 1) {
            p.x /= options.inSampleSize;
            p.y /= options.inSampleSize;
            p.x = p.x == 0 ? 1 : p.x;
            p.y = p.y == 0 ? 1 : p.y;
        }
        shadowBitmap.setWidth(p.x);
        shadowBitmap.setHeight(p.y);
        if (image != null) {
            BufferedImage bufferedImage = new BufferedImage(p.x, p.y, 2);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage((Image)image.getBufferedImage(), 0, 0, null);
            g.dispose();
            shadowBitmap.setBufferedImage(bufferedImage);
        } else {
            shadowBitmap.setPixelsInternal(new int[p.x * p.y], 0, 0, 0, 0, p.x, p.y);
        }
        if (options != null) {
            options.outWidth = p.x;
            options.outHeight = p.y;
            shadowBitmap.setMutable(options.inMutable);
        }
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            ReflectionHelpers.callStaticMethod(BitmapFactory.class, (String)"setDensityFromOptions", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bitmap.class, (Object)bitmap), ReflectionHelpers.ClassParameter.from(BitmapFactory.Options.class, (Object)options)});
        } else {
            bitmap = (Bitmap)ReflectionHelpers.callStaticMethod(BitmapFactory.class, (String)"finishDecode", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bitmap.class, (Object)bitmap), ReflectionHelpers.ClassParameter.from(Rect.class, (Object)outPadding), ReflectionHelpers.ClassParameter.from(BitmapFactory.Options.class, (Object)options)});
        }
        return bitmap;
    }

    @Deprecated
    public static void provideWidthAndHeightHints(Uri uri, int width, int height) {
        widthAndHeightMap.put(uri.toString(), new Point(width, height));
    }

    @Deprecated
    public static void provideWidthAndHeightHints(int resourceId, int width, int height) {
        String string2 = String.valueOf(RuntimeEnvironment.getApplication().getResources().getResourceName(resourceId));
        widthAndHeightMap.put(string2.length() != 0 ? "resource:".concat(string2) : new String("resource:"), new Point(width, height));
    }

    @Deprecated
    public static void provideWidthAndHeightHints(String file, int width, int height) {
        String string2 = String.valueOf(file);
        widthAndHeightMap.put(string2.length() != 0 ? "file:".concat(string2) : new String("file:"), new Point(width, height));
    }

    @Deprecated
    public static void provideWidthAndHeightHints(FileDescriptor fd, int width, int height) {
        String string2 = String.valueOf(fd);
        widthAndHeightMap.put(new StringBuilder(3 + String.valueOf(string2).length()).append("fd:").append(string2).toString(), new Point(width, height));
    }

    private static String stringify(BitmapFactory.Options options) {
        if (options == null) {
            return "";
        }
        ArrayList<String> opts = new ArrayList<String>();
        if (options.inJustDecodeBounds) {
            opts.add("inJustDecodeBounds");
        }
        if (options.inSampleSize > 1) {
            int n = options.inSampleSize;
            opts.add(new StringBuilder(24).append("inSampleSize=").append(n).toString());
        }
        return Join.join((String)", ", opts);
    }

    @Resetter
    public static void reset() {
        widthAndHeightMap.clear();
        allowInvalidImageData = true;
    }

    private static Point selectWidthAndHeight(String name, Point widthAndHeightOverride, ImageUtil.RobolectricBufferedImage robolectricBufferedImage) {
        Point widthAndHeightFromMap = widthAndHeightMap.get(name);
        if (widthAndHeightFromMap != null) {
            return widthAndHeightFromMap;
        }
        if (robolectricBufferedImage != null) {
            return robolectricBufferedImage.getWidthAndHeight();
        }
        if (widthAndHeightOverride != null) {
            return widthAndHeightOverride;
        }
        return new Point(100, 100);
    }

    public static void setAllowInvalidImageData(boolean allowInvalidImageData) {
        ShadowBitmapFactory.allowInvalidImageData = allowInvalidImageData;
    }
}

