/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telecom.Call;
import android.telecom.InCallAdapter;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Call.class, minSdk=21)
public class ShadowCall {
    @RealObject
    Call realObject;
    private boolean hasSentRttRequest;
    private boolean hasRespondedToRttRequest;

    @Implementation(minSdk=28)
    protected void sendRttRequest() {
        this.hasSentRttRequest = true;
        if (this.getInCallAdapter() == null) {
            return;
        }
        Shadow.directlyOn((Object)this.realObject, Call.class, (String)"sendRttRequest", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
    }

    public boolean hasSentRttRequest() {
        return this.hasSentRttRequest;
    }

    public void clearHasSentRttRequest() {
        this.hasSentRttRequest = false;
    }

    @Implementation(minSdk=28)
    protected void respondToRttRequest(int id2, boolean accept) {
        this.hasRespondedToRttRequest = true;
        if (this.getInCallAdapter() == null) {
            return;
        }
        Shadow.directlyOn((Object)this.realObject, Call.class, (String)"respondToRttRequest", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)id2), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)accept)});
    }

    public boolean hasRespondedToRttRequest() {
        return this.hasRespondedToRttRequest;
    }

    public String getId() {
        return ((ReflectorCall)Reflector.reflector(ReflectorCall.class, (Object)this.realObject)).getId();
    }

    private InCallAdapter getInCallAdapter() {
        return ((ReflectorCall)Reflector.reflector(ReflectorCall.class, (Object)this.realObject)).getInCallAdapter();
    }

    @ForType(value=Call.class)
    static interface ReflectorCall {
        @Accessor(value="mTelecomCallId")
        public String getId();

        @Accessor(value="mInCallAdapter")
        public InCallAdapter getInCallAdapter();
    }

    @Implements(value=Call.RttCall.class, minSdk=27)
    public static class ShadowRttCall {
        private static final String TAG = "ShadowRttCall";
        @RealObject
        Call.RttCall realRttCallObject;
        PipedOutputStream pipedOutputStream = new PipedOutputStream();

        @Implementation
        protected void __constructor__(String telecomCallId, InputStreamReader receiveStream, OutputStreamWriter transmitStream, int mode, InCallAdapter inCallAdapter) {
            PipedInputStream pipedInputStream = new PipedInputStream();
            try {
                pipedInputStream.connect(this.pipedOutputStream);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)"Could not connect streams.");
            }
            Shadow.invokeConstructor(Call.RttCall.class, (Object)this.realRttCallObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)telecomCallId), ReflectionHelpers.ClassParameter.from(InputStreamReader.class, (Object)new InputStreamReader((InputStream)pipedInputStream, StandardCharsets.UTF_8)), ReflectionHelpers.ClassParameter.from(OutputStreamWriter.class, (Object)transmitStream), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mode), ReflectionHelpers.ClassParameter.from(InCallAdapter.class, (Object)inCallAdapter)});
        }

        public void writeRemoteMessage(String message) throws IOException {
            byte[] messageBytes = message.getBytes();
            this.pipedOutputStream.write(messageBytes, 0, messageBytes.length);
        }
    }
}

