/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowView;
import org.robolectric.shadows.ShadowWindow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Dialog.class)
public class ShadowDialog {
    @RealObject
    private Dialog realDialog;
    private boolean isShowing;
    Context context;
    private int layoutId;
    private int themeId;
    private View inflatedView;
    private boolean hasBeenDismissed;
    protected CharSequence title;
    private DialogInterface.OnCancelListener onCancelListener;
    private Window window;
    private Activity ownerActivity;
    private boolean hasShownBefore;
    private static final ArrayList<Dialog> shownDialogs = new ArrayList();
    private boolean isCancelableOnTouchOutside;
    private static ShadowDialog latestDialog;

    @Resetter
    public static void reset() {
        ShadowDialog.setLatestDialog(null);
        shownDialogs.clear();
    }

    public static Dialog getLatestDialog() {
        return latestDialog == null ? null : ShadowDialog.latestDialog.realDialog;
    }

    public static void setLatestDialog(ShadowDialog dialog) {
        latestDialog = dialog;
    }

    @Implementation
    protected void show() {
        ShadowDialog.setLatestDialog(this);
        shownDialogs.add(this.realDialog);
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).show();
    }

    @Implementation
    protected void dismiss() {
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).dismiss();
        this.hasBeenDismissed = true;
    }

    public void clickOn(int viewId) {
        this.realDialog.findViewById(viewId).performClick();
    }

    @Implementation
    protected void setCanceledOnTouchOutside(boolean flag) {
        this.isCancelableOnTouchOutside = flag;
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).setCanceledOnTouchOutside(flag);
    }

    public boolean isCancelable() {
        return (Boolean)ReflectionHelpers.getField((Object)this.realDialog, (String)"mCancelable");
    }

    public boolean isCancelableOnTouchOutside() {
        return this.isCancelableOnTouchOutside;
    }

    public DialogInterface.OnCancelListener getOnCancelListener() {
        return this.onCancelListener;
    }

    @Implementation
    protected void setOnCancelListener(DialogInterface.OnCancelListener listener) {
        this.onCancelListener = listener;
        ((Dialog)Shadow.directlyOn((Object)this.realDialog, Dialog.class)).setOnCancelListener(listener);
    }

    public boolean hasBeenDismissed() {
        return this.hasBeenDismissed;
    }

    public CharSequence getTitle() {
        ShadowWindow shadowWindow = (ShadowWindow)Shadow.extract((Object)this.realDialog.getWindow());
        return shadowWindow.getTitle();
    }

    public void clickOnText(int textId) {
        String text;
        if (this.inflatedView == null) {
            this.inflatedView = LayoutInflater.from((Context)this.context).inflate(this.layoutId, null);
        }
        if (!this.clickOnText(this.inflatedView, text = this.realDialog.getContext().getResources().getString(textId))) {
            String string2 = String.valueOf(text);
            throw new IllegalArgumentException(string2.length() != 0 ? "Text not found: ".concat(string2) : new String("Text not found: "));
        }
    }

    public void clickOnText(String text) {
        if (!this.clickOnText(this.inflatedView, text)) {
            String string2 = String.valueOf(text);
            throw new IllegalArgumentException(string2.length() != 0 ? "Text not found: ".concat(string2) : new String("Text not found: "));
        }
    }

    private boolean clickOnText(View view, String text) {
        ShadowView shadowView = (ShadowView)Shadow.extract((Object)view);
        if (text.equals(shadowView.innerText())) {
            view.performClick();
            return true;
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                View child = viewGroup.getChildAt(i);
                if (!this.clickOnText(child, text)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Dialog> getShownDialogs() {
        return shownDialogs;
    }

    public void callOnCreate(Bundle bundle) {
        ReflectionHelpers.callInstanceMethod((Object)this.realDialog, (String)"onCreate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)bundle)});
    }
}

