/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.MessageQueue;
import android.os.SystemClock;
import android.view.DisplayEventReceiver;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import java.time.Duration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.android.NativeObjRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPausedSystemClock;
import org.robolectric.shadows.ShadowSystem;
import org.robolectric.shadows.ShadowSystemClock;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(className="android.view.DisplayEventReceiver", isInAndroidSdk=false, looseSignatures=true)
public class ShadowDisplayEventReceiver {
    private static NativeObjRegistry<NativeDisplayEventReceiver> nativeObjRegistry = new NativeObjRegistry(NativeDisplayEventReceiver.class);
    private static int asyncVsyncDelay;
    @RealObject
    protected DisplayEventReceiver receiver;
    private static final Duration VSYNC_DELAY;

    @Implementation(minSdk=26, maxSdk=29)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue, int vsyncSource) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=23, maxSdk=25)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(receiver));
    }

    @Implementation(minSdk=20, maxSdk=22)
    protected static long nativeInit(DisplayEventReceiver receiver, MessageQueue msgQueue) {
        return nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(new WeakReference<DisplayEventReceiver>(receiver)));
    }

    @Implementation(maxSdk=19)
    protected static int nativeInit(Object receiver, Object msgQueue) {
        return (int)nativeObjRegistry.register((Object)new NativeDisplayEventReceiver(new WeakReference<DisplayEventReceiver>((DisplayEventReceiver)receiver)));
    }

    @Implementation(minSdk=30)
    protected static long nativeInit(WeakReference<DisplayEventReceiver> receiver, MessageQueue msgQueue, int vsyncSource, int configChanged) {
        return ShadowDisplayEventReceiver.nativeInit(receiver, msgQueue);
    }

    @Implementation(minSdk=20)
    protected static void nativeDispose(long receiverPtr) {
        NativeDisplayEventReceiver receiver = (NativeDisplayEventReceiver)nativeObjRegistry.unregister(receiverPtr);
        if (receiver != null) {
            receiver.dispose();
        }
    }

    @Implementation(maxSdk=19)
    protected static void nativeDispose(int receiverPtr) {
        NativeDisplayEventReceiver receiver = (NativeDisplayEventReceiver)nativeObjRegistry.unregister((long)receiverPtr);
        if (receiver != null) {
            receiver.dispose();
        }
    }

    @Implementation(minSdk=20)
    protected static void nativeScheduleVsync(long receiverPtr) {
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject(receiverPtr)).scheduleVsync();
    }

    @Implementation(maxSdk=19)
    protected static void nativeScheduleVsync(int receiverPtr) {
        ((NativeDisplayEventReceiver)nativeObjRegistry.getNativeObject((long)receiverPtr)).scheduleVsync();
    }

    @Implementation(minSdk=17, maxSdk=30)
    protected void dispose(boolean finalized) {
        CloseGuard closeGuard = ((DisplayEventReceiverReflector)Reflector.reflector(DisplayEventReceiverReflector.class, (Object)this.receiver)).getCloseGuard();
        if (closeGuard != null) {
            closeGuard.close();
        }
        Shadow.directlyOn((Object)this.receiver, DisplayEventReceiver.class, (String)"dispose", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)finalized)});
    }

    static void setAsyncVsync(int delayMillis) {
        asyncVsyncDelay = delayMillis;
    }

    @Resetter
    public static void reset() {
        asyncVsyncDelay = 0;
    }

    protected void onVsync() {
        if (RuntimeEnvironment.getApiLevel() <= 16) {
            ReflectionHelpers.callInstanceMethod(DisplayEventReceiver.class, (Object)this.receiver, (String)"onVsync", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)ShadowSystem.nanoTime()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1)});
        } else if (RuntimeEnvironment.getApiLevel() < 29) {
            ReflectionHelpers.callInstanceMethod(DisplayEventReceiver.class, (Object)this.receiver, (String)"onVsync", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)ShadowSystem.nanoTime()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)1)});
        } else {
            this.receiver.onVsync(ShadowSystem.nanoTime(), 0L, 1);
        }
    }

    static {
        VSYNC_DELAY = Duration.ofMillis(1L);
    }

    @ForType(value=DisplayEventReceiver.class)
    static interface DisplayEventReceiverReflector {
        @Accessor(value="mCloseGuard")
        public CloseGuard getCloseGuard();
    }

    private static class NativeDisplayEventReceiver {
        private final WeakReference<DisplayEventReceiver> receiverRef;
        private final ShadowPausedSystemClock.Listener clockListener;
        private long nextVsyncTime = 0L;

        public NativeDisplayEventReceiver(WeakReference<DisplayEventReceiver> receiverRef) {
            this.receiverRef = receiverRef;
            this.clockListener = new ShadowPausedSystemClock.Listener(){

                @Override
                public void clockUpdated(long newCurrentTimeMillis) {
                    if (nextVsyncTime > 0L && newCurrentTimeMillis >= nextVsyncTime) {
                        nextVsyncTime = 0L;
                        this.doVsync();
                    }
                }
            };
            ShadowPausedSystemClock.addListener(this.clockListener);
        }

        void dispose() {
            ShadowPausedSystemClock.removeListener(this.clockListener);
        }

        public void scheduleVsync() {
            if (asyncVsyncDelay > 0 && this.nextVsyncTime == 0L) {
                this.nextVsyncTime = SystemClock.uptimeMillis() + (long)asyncVsyncDelay;
            } else {
                ShadowSystemClock.advanceBy(VSYNC_DELAY);
                this.doVsync();
            }
        }

        private void doVsync() {
            DisplayEventReceiver receiver = (DisplayEventReceiver)this.receiverRef.get();
            if (receiver != null) {
                ShadowDisplayEventReceiver shadowReceiver = (ShadowDisplayEventReceiver)Shadow.extract((Object)receiver);
                shadowReceiver.onVsync();
            }
        }
    }
}

