/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.content.res.ApkAssets;
import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.ParcelFileDescriptor;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.TypedValue;
import com.google.common.collect.Ordering;
import dalvik.system.VMRuntime;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.XmlResourceParserImpl;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.AttrData;
import org.robolectric.res.AttributeResource;
import org.robolectric.res.EmptyStyle;
import org.robolectric.res.FileTypedResource;
import org.robolectric.res.Fs;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.ResourceIds;
import org.robolectric.res.ResourceTable;
import org.robolectric.res.Style;
import org.robolectric.res.StyleData;
import org.robolectric.res.StyleResolver;
import org.robolectric.res.ThemeStyleSet;
import org.robolectric.res.TypedResource;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.Registries;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.builder.XmlBlock;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.Converter;
import org.robolectric.shadows.ShadowArscAssetManager9;
import org.robolectric.shadows.ShadowAssetInputStream;
import org.robolectric.shadows.ShadowAssetManager;
import org.robolectric.shadows.ShadowTypedArray;
import org.robolectric.shadows.ShadowVMRuntime;
import org.robolectric.util.Logger;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.TempDirectory;
import org.robolectric.util.reflector.Reflector;

@Implements(value=AssetManager.class, looseSignatures=true, shadowPicker=ShadowAssetManager.Picker.class)
@SuppressLint(value={"NewApi"})
public class ShadowLegacyAssetManager
extends ShadowAssetManager {
    public static final Ordering<String> ATTRIBUTE_TYPE_PRECIDENCE = Ordering.explicit((Object)"reference", (Object[])new String[]{"color", "boolean", "integer", "fraction", "dimension", "float", "enum", "flag", "flags", "string"});
    static boolean strictErrors = false;
    private static final int STYLE_NUM_ENTRIES = 6;
    private static final int STYLE_TYPE = 0;
    private static final int STYLE_DATA = 1;
    private static final int STYLE_ASSET_COOKIE = 2;
    private static final int STYLE_RESOURCE_ID = 3;
    private static final int STYLE_CHANGING_CONFIGURATIONS = 4;
    private static final int STYLE_DENSITY = 5;
    private static long nextInternalThemeId = 1000L;
    private static final Map<Long, NativeTheme> nativeThemes = new HashMap<Long, NativeTheme>();
    @RealObject
    protected AssetManager realObject;
    private ResourceTable resourceTable;
    ResTable_config config = new ResTable_config();
    private final Set<Path> assetDirs = new CopyOnWriteArraySet<Path>();

    private void convertAndFill(AttributeResource attribute, TypedValue outValue, ResTable_config config, boolean resolveRefs) {
        if (attribute.isNull()) {
            outValue.type = 0;
            outValue.data = 0;
            return;
        }
        if (attribute.isEmpty()) {
            outValue.type = 0;
            outValue.data = 1;
            return;
        }
        outValue.assetCookie = Converter.getNextStringCookie();
        outValue.changingConfigurations = 0;
        if (attribute.isStyleReference()) {
            return;
        }
        while (attribute.isResourceReference()) {
            ResName resName = attribute.getResourceReference();
            Integer resourceId = attribute.getReferenceResId() != null ? attribute.getReferenceResId() : this.resourceTable.getResourceId(resName);
            if (resourceId == null) {
                String string2 = String.valueOf(resName);
                throw new Resources.NotFoundException(new StringBuilder(17 + String.valueOf(string2).length()).append("unknown resource ").append(string2).toString());
            }
            outValue.type = 1;
            if (!resolveRefs) {
                outValue.data = resourceId;
                return;
            }
            outValue.resourceId = resourceId;
            TypedResource dereferencedRef = this.resourceTable.getValue(resName, config);
            if (dereferencedRef == null) {
                Logger.strict((String)"couldn't resolve %s from %s", (Object[])new Object[]{resName.getFullyQualifiedName(), attribute});
                return;
            }
            if (dereferencedRef.isFile()) {
                outValue.type = 3;
                outValue.data = 0;
                outValue.assetCookie = Converter.getNextStringCookie();
                outValue.string = dereferencedRef.asString();
                return;
            }
            if (!(dereferencedRef.getData() instanceof String)) break;
            attribute = new AttributeResource(attribute.resName, dereferencedRef.asString(), resName.packageName);
            if (attribute.isResourceReference()) continue;
            if (!resolveRefs) break;
            Converter.getConverter(dereferencedRef.getResType()).fillTypedValue(attribute.value, outValue);
            return;
        }
        if (attribute.isNull()) {
            outValue.type = 0;
            return;
        }
        TypedResource attrTypeData = this.getAttrTypeData(attribute.resName);
        if (attrTypeData != null) {
            AttrData attrData = (AttrData)attrTypeData.getData();
            String format = attrData.getFormat();
            String[] types = format.split("\\|");
            Arrays.sort(types, ATTRIBUTE_TYPE_PRECIDENCE);
            for (String type : types) {
                Converter converter;
                if ("reference".equals(type) || (converter = Converter.getConverterFor(attrData, type)) == null || !converter.fillTypedValue(attribute.value, outValue)) continue;
                return;
            }
        } else {
            ResType resType = ResType.inferFromValue((String)attribute.value);
            Converter.getConverter(resType).fillTypedValue(attribute.value, outValue);
        }
    }

    public TypedResource getAttrTypeData(ResName resName) {
        return this.resourceTable.getValue(resName, this.config);
    }

    @Implementation
    protected void __constructor__() {
        this.resourceTable = RuntimeEnvironment.getAppResourceTable();
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            Shadow.invokeConstructor(AssetManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        }
    }

    @Implementation
    protected void __constructor__(boolean isSystem) {
        ResourceTable resourceTable = this.resourceTable = isSystem ? RuntimeEnvironment.getSystemResourceTable() : RuntimeEnvironment.getAppResourceTable();
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            Shadow.invokeConstructor(AssetManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)isSystem)});
        }
    }

    @Implementation(minSdk=28)
    protected static long nativeCreate() {
        return 1L;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected void init() {
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected void init(boolean isSystem) {
    }

    protected ResourceTable getResourceTable() {
        return this.resourceTable;
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceText(int ident) {
        TypedResource value = this.getAndResolve(ident, this.config, true);
        if (value == null) {
            return null;
        }
        return (CharSequence)value.getData();
    }

    @HiddenApi
    @Implementation
    public CharSequence getResourceBagText(int ident, int bagEntryId) {
        throw new UnsupportedOperationException();
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected int getStringBlockCount() {
        return 0;
    }

    @HiddenApi
    @Implementation
    public String[] getResourceStringArray(int id2) {
        CharSequence[] resourceTextArray = this.getResourceTextArray(id2);
        if (resourceTextArray == null) {
            return null;
        }
        String[] strings = new String[resourceTextArray.length];
        for (int i = 0; i < strings.length; ++i) {
            strings[i] = resourceTextArray[i].toString();
        }
        return strings;
    }

    @HiddenApi
    @Implementation
    public int getResourceIdentifier(String name, String defType, String defPackage) {
        Integer resourceId = this.resourceTable.getResourceId(ResName.qualifyResName((String)name, (String)defPackage, (String)defType));
        return resourceId == null ? 0 : resourceId;
    }

    @HiddenApi
    @Implementation
    public boolean getResourceValue(int ident, int density, TypedValue outValue, boolean resolveRefs) {
        TypedResource value = this.getAndResolve(ident, this.config, resolveRefs);
        if (value == null) {
            return false;
        }
        this.getConverter(value).fillTypedValue(value.getData(), outValue);
        return true;
    }

    private Converter getConverter(TypedResource value) {
        if (value instanceof FileTypedResource.Image || value instanceof FileTypedResource && ((FileTypedResource)value).getPath().getFileName().toString().endsWith(".xml")) {
            return new Converter.FromFilePath();
        }
        return Converter.getConverter(value.getResType());
    }

    @HiddenApi
    @Implementation
    public CharSequence[] getResourceTextArray(int resId) {
        TypedResource value = this.getAndResolve(resId, this.config, true);
        if (value == null) {
            return null;
        }
        List<TypedResource> items = this.getConverter(value).getItems(value);
        CharSequence[] charSequences = new CharSequence[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            TypedResource typedResource = this.resolve(items.get(i), this.config, resId);
            charSequences[i] = this.getConverter(typedResource).asCharSequence(typedResource);
        }
        return charSequences;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public boolean getThemeValue(int themePtr, int ident, TypedValue outValue, boolean resolveRefs) {
        return this.getThemeValue((long)themePtr, ident, outValue, resolveRefs);
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public boolean getThemeValue(long themePtr, int ident, TypedValue outValue, boolean resolveRefs) {
        ResName resName = this.resourceTable.getResName(ident);
        ThemeStyleSet themeStyleSet = ShadowLegacyAssetManager.getNativeTheme(themePtr).themeStyleSet;
        AttributeResource attrValue = themeStyleSet.getAttrValue(resName);
        while (attrValue != null && attrValue.isStyleReference()) {
            ResName attrResName = attrValue.getStyleReference();
            if (attrValue.resName.equals((Object)attrResName)) {
                Logger.info((String)"huh... circular reference for %s?", (Object[])new Object[]{attrResName.getFullyQualifiedName()});
                return false;
            }
            attrValue = themeStyleSet.getAttrValue(attrResName);
        }
        if (attrValue != null) {
            this.convertAndFill(attrValue, outValue, this.config, resolveRefs);
            return true;
        }
        return false;
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected Object ensureStringBlocks() {
        return null;
    }

    @Implementation
    protected final InputStream open(String fileName) throws IOException {
        return Fs.getInputStream((Path)this.findAssetFile(fileName));
    }

    @Implementation
    protected final InputStream open(String fileName, int accessMode) throws IOException {
        return Fs.getInputStream((Path)this.findAssetFile(fileName));
    }

    @Implementation
    protected final AssetFileDescriptor openFd(String fileName) throws IOException {
        Path path = this.findAssetFile(fileName);
        if (path.getFileSystem().provider().getScheme().equals("jar")) {
            path = ShadowLegacyAssetManager.getFileFromZip(path);
        }
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)path.toFile(), (int)0x10000000);
        return new AssetFileDescriptor(parcelFileDescriptor, 0L, Files.size(path));
    }

    private Path findAssetFile(String fileName) throws IOException {
        for (Path assetDir : this.getAllAssetDirs()) {
            Path assetFile = assetDir.resolve(fileName);
            if (!Files.exists(assetFile, new LinkOption[0])) continue;
            return assetFile;
        }
        throw new FileNotFoundException(new StringBuilder(21 + String.valueOf(fileName).length()).append("Asset file ").append(fileName).append(" not found").toString());
    }

    private static Path getFileFromZip(Path path) {
        Path path2;
        block16: {
            byte[] buffer = new byte[1024];
            Path outputDir = new TempDirectory("robolectric_assets").create("fromzip");
            InputStream zis = Fs.getInputStream((Path)path);
            try {
                Path fileFromZip = outputDir.resolve(path.getFileName().toString());
                try (OutputStream fos = Files.newOutputStream(fileFromZip, new OpenOption[0]);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                path2 = fileFromZip;
                if (zis == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (zis != null) {
                        try {
                            zis.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            zis.close();
        }
        return path2;
    }

    @Implementation
    protected final String[] list(String path) throws IOException {
        ArrayList assetFiles = new ArrayList();
        for (Path assetsDir : this.getAllAssetDirs()) {
            Path file = path.isEmpty() ? assetsDir : assetsDir.resolve(path);
            if (!Files.isDirectory(file, new LinkOption[0])) continue;
            Collections.addAll(assetFiles, Fs.listFileNames((Path)file));
        }
        return assetFiles.toArray(new String[assetFiles.size()]);
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected Number openAsset(String fileName, int mode) throws FileNotFoundException {
        return 0;
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected ParcelFileDescriptor openAssetFd(String fileName, long[] outOffsets) throws IOException {
        return null;
    }

    @HiddenApi
    @Implementation
    public final InputStream openNonAsset(int cookie, String fileName, int accessMode) throws IOException {
        ResName resName = this.qualifyFromNonAssetFileName(fileName);
        FileTypedResource typedResource = (FileTypedResource)this.resourceTable.getValue(resName, this.config);
        if (typedResource == null) {
            String string2 = String.valueOf(fileName);
            throw new IOException(string2.length() != 0 ? "Unable to find resource for ".concat(string2) : new String("Unable to find resource for "));
        }
        InputStream stream = accessMode == 2 ? Fs.getInputStream((Path)typedResource.getPath()) : new ByteArrayInputStream(Fs.getBytes((Path)typedResource.getPath()));
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            Asset asset = Asset.newFileAsset((FileTypedResource)typedResource);
            long assetPtr = Registries.NATIVE_ASSET_REGISTRY.register((Object)asset);
            stream = ShadowAssetInputStream.createAssetInputStream(stream, assetPtr, this.realObject);
        }
        return stream;
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected Number openNonAssetNative(int cookie, String fileName, int accessMode) throws FileNotFoundException {
        throw new IllegalStateException();
    }

    private ResName qualifyFromNonAssetFileName(String fileName) {
        if (fileName.startsWith("jar:") && !fileName.contains("resource_files.zip")) {
            if (File.separatorChar == '\\') {
                fileName = this.windowsWorkaround(fileName);
            }
            return ResName.qualifyFromFilePath((String)"android", (String)fileName.replaceFirst("jar:", ""));
        }
        return ResName.qualifyFromFilePath((String)RuntimeEnvironment.getApplication().getPackageName(), (String)fileName);
    }

    private String windowsWorkaround(String fileWithinJar) {
        try {
            String path = new URL(new URL(fileWithinJar).getPath()).getPath();
            int bangI = path.indexOf(33);
            String jarPath = path.substring(1, bangI);
            String string2 = URLDecoder.decode(URLDecoder.decode(jarPath, "UTF-8"), "UTF-8");
            String string3 = path.substring(bangI + 1);
            return new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append("!").append(string3).toString();
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @HiddenApi
    @Implementation
    public final AssetFileDescriptor openNonAssetFd(int cookie, String fileName) throws IOException {
        throw new IllegalStateException();
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected ParcelFileDescriptor openNonAssetFdNative(int cookie, String fileName, long[] outOffsets) throws IOException {
        throw new IllegalStateException();
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected Number openXmlAssetNative(int cookie, String fileName) throws FileNotFoundException {
        throw new IllegalStateException();
    }

    @Implementation
    protected final XmlResourceParser openXmlResourceParser(int cookie, String fileName) throws IOException {
        XmlBlock xmlBlock = XmlBlock.create((Path)Fs.fromUrl((String)fileName), (String)this.resourceTable.getPackageName());
        if (xmlBlock == null) {
            throw new Resources.NotFoundException(fileName);
        }
        return this.getXmlResourceParser(this.resourceTable, xmlBlock, this.resourceTable.getPackageName());
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected final long seekAsset(int asset, long offset, int whence) {
        return this.seekAsset((long)asset, offset, whence);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected long seekAsset(long asset, long offset, int whence) {
        return 0L;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected final long getAssetLength(int asset) {
        return this.getAssetLength((long)asset);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected long getAssetLength(long asset) {
        return 0L;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected final long getAssetRemainingLength(int asset) {
        return this.getAssetRemainingLength((long)asset);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected long getAssetRemainingLength(long assetHandle) {
        return 0L;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected final void destroyAsset(int asset) {
        this.destroyAsset((long)asset);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected void destroyAsset(long asset) {
    }

    protected XmlResourceParser loadXmlResourceParser(int resId, String type) throws Resources.NotFoundException {
        ResName resName = this.getResName(resId);
        ResName resolvedResName = this.resolveResName(resName, this.config);
        if (resolvedResName == null) {
            String string2 = String.valueOf(resName.getFullyQualifiedName());
            throw new RuntimeException(string2.length() != 0 ? "couldn't resolve ".concat(string2) : new String("couldn't resolve "));
        }
        resName = resolvedResName;
        XmlBlock block = this.resourceTable.getXml(resName, this.config);
        if (block == null) {
            throw new Resources.NotFoundException(resName.getFullyQualifiedName());
        }
        ResourceTable resourceProvider = ResourceIds.isFrameworkResource((int)resId) ? RuntimeEnvironment.getSystemResourceTable() : RuntimeEnvironment.getCompileTimeResourceTable();
        return this.getXmlResourceParser(resourceProvider, block, resName.packageName);
    }

    private XmlResourceParser getXmlResourceParser(ResourceTable resourceProvider, XmlBlock block, String packageName) {
        return new XmlResourceParserImpl(block.getDocument(), block.getPath(), block.getPackageName(), packageName, resourceProvider);
    }

    @HiddenApi
    @Implementation
    public int addAssetPath(String path) {
        this.assetDirs.add(Fs.fromUrl((String)path));
        return 1;
    }

    @HiddenApi
    @Implementation(minSdk=18, maxSdk=23)
    protected final int addAssetPathNative(String path) {
        return this.addAssetPathNative(path, false);
    }

    @HiddenApi
    @Implementation(minSdk=24, maxSdk=27)
    protected int addAssetPathNative(String path, boolean appAsLib) {
        return 0;
    }

    @HiddenApi
    @Implementation(minSdk=28)
    public void setApkAssets(Object apkAssetsObject, Object invalidateCachesObject) {
        ApkAssets[] apkAssets = (ApkAssets[])apkAssetsObject;
        boolean invalidateCaches = (Boolean)invalidateCachesObject;
        for (ApkAssets apkAsset : apkAssets) {
            this.assetDirs.add(Fs.fromUrl((String)apkAsset.getAssetPath()));
        }
        ((AssetManager)Shadow.directlyOn((Object)this.realObject, AssetManager.class)).setApkAssets(apkAssets, invalidateCaches);
    }

    @HiddenApi
    @Implementation
    public boolean isUpToDate() {
        return true;
    }

    @HiddenApi
    @Implementation(maxSdk=23)
    public void setLocale(String locale) {
    }

    @Implementation
    protected String[] getLocales() {
        return new String[0];
    }

    @HiddenApi
    @Implementation(maxSdk=25)
    public final void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int sdkVersion) {
        this.setConfiguration(mcc, mnc, locale, orientation, touchscreen, density, keyboard, keyboardHidden, navigation, screenWidth, screenHeight, smallestScreenWidthDp, screenWidthDp, screenHeightDp, screenLayout, uiMode, 0, sdkVersion);
    }

    @HiddenApi
    @Implementation(minSdk=26)
    public void setConfiguration(int mcc, int mnc, String locale, int orientation, int touchscreen, int density, int keyboard, int keyboardHidden, int navigation, int screenWidth, int screenHeight, int smallestScreenWidthDp, int screenWidthDp, int screenHeightDp, int screenLayout, int uiMode, int colorMode, int majorVersion) {
        ResTable_config config = new ResTable_config();
        int kScreenLayoutRoundMask = 768;
        int kScreenLayoutRoundShift = 8;
        config.mcc = mcc;
        config.mnc = mnc;
        config.orientation = orientation;
        config.touchscreen = touchscreen;
        config.density = density;
        config.keyboard = keyboard;
        config.inputFlags = keyboardHidden;
        config.navigation = navigation;
        config.screenWidth = screenWidth;
        config.screenHeight = screenHeight;
        config.smallestScreenWidthDp = smallestScreenWidthDp;
        config.screenWidthDp = screenWidthDp;
        config.screenHeightDp = screenHeightDp;
        config.screenLayout = screenLayout;
        config.uiMode = uiMode;
        config.sdkVersion = majorVersion;
        config.minorVersion = 0;
        config.screenLayout2 = (byte)((screenLayout & 0x300) >> 8);
        if (locale != null) {
            config.setBcp47Locale(locale);
        }
        this.config = config;
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    public int[] getArrayIntResource(int resId) {
        TypedResource value = this.getAndResolve(resId, this.config, true);
        if (value == null) {
            return null;
        }
        List<TypedResource> items = this.getConverter(value).getItems(value);
        int[] ints = new int[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            TypedResource typedResource = this.resolve(items.get(i), this.config, resId);
            ints[i] = this.getConverter(typedResource).asInt(typedResource);
        }
        return ints;
    }

    @HiddenApi
    @Implementation(minSdk=28)
    protected int[] getResourceIntArray(int resId) {
        return this.getArrayIntResource(resId);
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected String[] getArrayStringResource(int arrayResId) {
        return new String[0];
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected int[] getArrayStringInfo(int arrayResId) {
        return new int[0];
    }

    @HiddenApi
    @Implementation(maxSdk=27)
    protected Number newTheme() {
        return null;
    }

    protected TypedArray getTypedArrayResource(Resources resources, int resId) {
        TypedResource value = this.getAndResolve(resId, this.config, true);
        if (value == null) {
            return null;
        }
        List<TypedResource> items = this.getConverter(value).getItems(value);
        return this.getTypedArray(resources, items, resId);
    }

    private TypedArray getTypedArray(Resources resources, List<TypedResource> typedResources, int resId) {
        CharSequence[] stringData = new CharSequence[typedResources.size()];
        int totalLen = typedResources.size() * 6;
        int[] data = new int[totalLen];
        for (int i = 0; i < typedResources.size(); ++i) {
            String reference;
            int offset = i * 6;
            TypedResource typedResource = typedResources.get(i);
            int type = this.getResourceType(typedResource);
            if (type == -1) continue;
            TypedValue typedValue = new TypedValue();
            if (type == 1) {
                reference = typedResource.asString();
                ResName refResName = AttributeResource.getResourceReference((String)reference, (String)typedResource.getXmlContext().getPackageName(), null);
                typedValue.data = typedValue.resourceId = this.resourceTable.getResourceId(refResName).intValue();
                if ((typedResource = this.resolve(typedResource, this.config, typedValue.resourceId)) != null) {
                    type = this.getResourceType(typedResource);
                    if (type == 2) {
                        type = 1;
                    } else if (type == -1) continue;
                }
            }
            if (type == 2) {
                reference = typedResource.asString();
                ResName attrResName = AttributeResource.getStyleReference((String)reference, (String)typedResource.getXmlContext().getPackageName(), (String)"attr");
                typedValue.data = this.resourceTable.getResourceId(attrResName);
            }
            if (typedResource != null && type != 0 && type != 2) {
                this.getConverter(typedResource).fillTypedValue(typedResource.getData(), typedValue);
            }
            data[offset + 0] = type;
            data[offset + 3] = typedValue.resourceId;
            data[offset + 1] = typedValue.data;
            data[offset + 2] = typedValue.assetCookie;
            data[offset + 4] = typedValue.changingConfigurations;
            data[offset + 5] = typedValue.density;
            stringData[i] = typedResource == null ? null : typedResource.asString();
        }
        int[] indices = new int[typedResources.size() + 1];
        return ShadowTypedArray.create(resources, null, data, indices, typedResources.size(), stringData);
    }

    private int getResourceType(TypedResource typedResource) {
        if (typedResource == null) {
            return -1;
        }
        ResType resType = typedResource.getResType();
        int type = typedResource.getData() == null || resType == ResType.NULL ? 0 : (typedResource.isReference() ? 1 : (resType == ResType.STYLE ? 2 : (resType == ResType.CHAR_SEQUENCE || resType == ResType.DRAWABLE ? 3 : (resType == ResType.INTEGER ? 16 : (resType == ResType.FLOAT || resType == ResType.FRACTION ? 4 : (resType == ResType.BOOLEAN ? 18 : (resType == ResType.DIMEN ? 5 : (resType == ResType.COLOR ? 28 : (resType == ResType.TYPED_ARRAY || resType == ResType.CHAR_SEQUENCE_ARRAY ? 1 : -1)))))))));
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation
    public Number createTheme() {
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            long nativePtr = nextInternalThemeId++;
            nativeThemes.put(nativePtr, new NativeTheme(new ThemeStyleSet()));
            return RuntimeEnvironment.castNativePtr(nativePtr);
        }
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected static void dumpTheme(long theme, int priority, String tag, String prefix) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public void releaseTheme(int themePtr) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NativeTheme getNativeTheme(long themePtr) {
        NativeTheme nativeTheme;
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            nativeTheme = nativeThemes.get(themePtr);
        }
        if (nativeTheme == null) {
            throw new RuntimeException(new StringBuilder(51).append("no theme ").append(themePtr).append(" found in AssetManager").toString());
        }
        return nativeTheme;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation(minSdk=21)
    public void releaseTheme(long themePtr) {
        Map<Long, NativeTheme> map = nativeThemes;
        synchronized (map) {
            nativeThemes.remove(themePtr);
        }
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected void deleteTheme(int theme) {
        this.deleteTheme((long)theme);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected void deleteTheme(long theme) {
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void applyThemeStyle(int themePtr, int styleRes, boolean force) {
        ShadowLegacyAssetManager.applyThemeStyle((long)themePtr, styleRes, force);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    public static void applyThemeStyle(long themePtr, int styleRes, boolean force) {
        NativeTheme nativeTheme = ShadowLegacyAssetManager.getNativeTheme(themePtr);
        Style style = nativeTheme.getShadowAssetManager().resolveStyle(styleRes, null);
        nativeTheme.themeStyleSet.apply(style, force);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    public static void copyTheme(int destPtr, int sourcePtr) {
        ShadowLegacyAssetManager.copyTheme((long)destPtr, (long)sourcePtr);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    public static void copyTheme(long destPtr, long sourcePtr) {
        NativeTheme destNativeTheme = ShadowLegacyAssetManager.getNativeTheme(destPtr);
        NativeTheme sourceNativeTheme = ShadowLegacyAssetManager.getNativeTheme(sourcePtr);
        destNativeTheme.themeStyleSet = sourceNativeTheme.themeStyleSet.copy();
    }

    @HiddenApi
    @Implementation(minSdk=28, maxSdk=28)
    protected static void nativeThemeCopy(long destPtr, long sourcePtr) {
        ShadowLegacyAssetManager.copyTheme(destPtr, sourcePtr);
    }

    @HiddenApi
    @Implementation(minSdk=29)
    protected static void nativeThemeCopy(long dstAssetManagerPtr, long dstThemePtr, long srcAssetManagerPtr, long srcThemePtr) {
        ShadowLegacyAssetManager.copyTheme(dstThemePtr, srcThemePtr);
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected static boolean applyStyle(int themeToken, int defStyleAttr, int defStyleRes, int xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        return ShadowLegacyAssetManager.applyStyle((long)themeToken, defStyleAttr, defStyleRes, (long)xmlParserToken, attrs, outValues, outIndices);
    }

    @HiddenApi
    @Implementation(minSdk=26, maxSdk=27)
    protected static void applyStyle(long themeToken, int defStyleAttr, int defStyleRes, long xmlParserToken, int[] inAttrs, int length, long outValuesAddress, long outIndicesAddress) {
        ShadowVMRuntime shadowVMRuntime = (ShadowVMRuntime)Shadow.extract((Object)VMRuntime.getRuntime());
        int[] outValues = (int[])shadowVMRuntime.getObjectForAddress(outValuesAddress);
        int[] outIndices = (int[])shadowVMRuntime.getObjectForAddress(outIndicesAddress);
        ShadowLegacyAssetManager.applyStyle(themeToken, defStyleAttr, defStyleRes, xmlParserToken, inAttrs, outValues, outIndices);
    }

    @HiddenApi
    @Implementation(minSdk=28)
    protected void applyStyleToTheme(long themePtr, int resId, boolean force) {
        ShadowLegacyAssetManager.applyThemeStyle(themePtr, resId, force);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=25)
    protected static boolean applyStyle(long themeToken, int defStyleAttr, int defStyleRes, long xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        return false;
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected static boolean resolveAttrs(long themeToken, int defStyleAttr, int defStyleRes, int[] inValues, int[] attrs, int[] outValues, int[] outIndices) {
        return false;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected boolean retrieveAttributes(int xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        return this.retrieveAttributes((long)xmlParserToken, attrs, outValues, outIndices);
    }

    @Implementation(minSdk=21, maxSdk=27)
    protected boolean retrieveAttributes(long xmlParserToken, int[] attrs, int[] outValues, int[] outIndices) {
        return false;
    }

    @HiddenApi
    @Implementation(maxSdk=20)
    protected static int loadThemeAttributeValue(int themeHandle, int ident, TypedValue outValue, boolean resolve) {
        return ShadowLegacyAssetManager.loadThemeAttributeValue((long)themeHandle, ident, outValue, resolve);
    }

    @HiddenApi
    @Implementation(minSdk=21, maxSdk=27)
    protected static int loadThemeAttributeValue(long themeHandle, int ident, TypedValue outValue, boolean resolve) {
        return 0;
    }

    Style resolveStyle(int resId, Style themeStyleSet) {
        return this.resolveStyle(this.getResName(resId), themeStyleSet);
    }

    private Style resolveStyle(@Nonnull ResName themeStyleName, Style themeStyleSet) {
        TypedResource themeStyleResource = this.resourceTable.getValue(themeStyleName, this.config);
        if (themeStyleResource == null) {
            return null;
        }
        StyleData themeStyleData = (StyleData)themeStyleResource.getData();
        if (themeStyleSet == null) {
            themeStyleSet = new ThemeStyleSet();
        }
        return new StyleResolver(this.resourceTable, ShadowLegacyAssetManager.legacyShadowOf(AssetManager.getSystem()).getResourceTable(), themeStyleData, themeStyleSet, themeStyleName, this.config);
    }

    private TypedResource getAndResolve(int resId, ResTable_config config, boolean resolveRefs) {
        TypedResource value = this.resourceTable.getValue(resId, config);
        if (resolveRefs) {
            value = this.resolve(value, config, resId);
        }
        return value;
    }

    TypedResource resolve(TypedResource value, ResTable_config config, int resId) {
        return this.resolveResourceValue(value, config, resId);
    }

    protected ResName resolveResName(ResName resName, ResTable_config config) {
        TypedResource value = this.resourceTable.getValue(resName, config);
        return this.resolveResource(value, config, resName);
    }

    private ResName resolveResource(TypedResource value, ResTable_config config, ResName resName) {
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull((String)s) || AttributeResource.isEmpty((String)s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName((String)refStr, (ResName)resName);
            value = this.resourceTable.getValue(resName, config);
        }
        return resName;
    }

    private TypedResource resolveResourceValue(TypedResource value, ResTable_config config, ResName resName) {
        while (value != null && value.isReference()) {
            String s = value.asString();
            if (AttributeResource.isNull((String)s) || AttributeResource.isEmpty((String)s)) {
                value = null;
                continue;
            }
            String refStr = s.substring(1).replace("+", "");
            resName = ResName.qualifyResName((String)refStr, (ResName)resName);
            value = this.resourceTable.getValue(resName, config);
        }
        return value;
    }

    protected TypedResource resolveResourceValue(TypedResource value, ResTable_config config, int resId) {
        ResName resName = this.getResName(resId);
        return this.resolveResourceValue(value, config, resName);
    }

    private TypedValue buildTypedValue(AttributeSet set, int resId, int defStyleAttr, Style themeStyleSet, int defStyleRes) {
        String attrValue;
        Object defStyleResName;
        ResName defStyleName;
        AttributeResource defStyleAttribute;
        Style defStyleFromAttr = null;
        Style defStyleFromRes = null;
        Style styleAttrStyle = null;
        if (defStyleAttr != 0 && (defStyleAttribute = themeStyleSet.getAttrValue(defStyleName = this.getResName(defStyleAttr))) != null) {
            while (defStyleAttribute.isStyleReference()) {
                AttributeResource other = themeStyleSet.getAttrValue(defStyleAttribute.getStyleReference());
                if (other == null) {
                    String string2 = String.valueOf(defStyleAttribute);
                    throw new RuntimeException(new StringBuilder(21 + String.valueOf(string2).length()).append("couldn't dereference ").append(string2).toString());
                }
                defStyleAttribute = other;
            }
            if (defStyleAttribute.isResourceReference()) {
                defStyleResName = defStyleAttribute.getResourceReference();
                defStyleFromAttr = this.resolveStyle((ResName)defStyleResName, themeStyleSet);
            }
        }
        if (set != null && set.getStyleAttribute() != 0) {
            ResName styleAttributeResName = this.getResName(set.getStyleAttribute());
            while (styleAttributeResName.type.equals("attr")) {
                attrValue = themeStyleSet.getAttrValue(styleAttributeResName);
                if (attrValue == null) {
                    defStyleResName = styleAttributeResName.getFullyQualifiedName();
                    String string3 = String.valueOf(themeStyleSet);
                    throw new RuntimeException(new StringBuilder(17 + String.valueOf(defStyleResName).length() + String.valueOf(string3).length()).append("no value for ").append((String)defStyleResName).append(" in ").append(string3).toString());
                }
                if (attrValue.isResourceReference()) {
                    styleAttributeResName = attrValue.getResourceReference();
                    continue;
                }
                if (!attrValue.isStyleReference()) continue;
                styleAttributeResName = attrValue.getStyleReference();
            }
            styleAttrStyle = this.resolveStyle(styleAttributeResName, themeStyleSet);
        }
        if (defStyleRes != 0) {
            ResName resName = this.getResName(defStyleRes);
            if (resName.type.equals("attr")) {
                attrValue = resName.getFullyQualifiedName();
                System.out.println(new StringBuilder(30 + String.valueOf(attrValue).length()).append("WARN: ").append(attrValue).append(" should be a style resId").toString());
            } else if (resName.type.equals("style")) {
                defStyleFromRes = this.resolveStyle(resName, themeStyleSet);
            }
        }
        AttributeResource attribute = this.findAttributeValue(resId, set, styleAttrStyle, defStyleFromAttr, defStyleFromRes, themeStyleSet);
        while (attribute != null && attribute.isStyleReference()) {
            ResName otherAttrName = attribute.getStyleReference();
            if (attribute.resName.equals((Object)otherAttrName)) {
                Logger.info((String)"huh... circular reference for %s?", (Object[])new Object[]{attribute.resName.getFullyQualifiedName()});
                return null;
            }
            ResName resName = this.resourceTable.getResName(resId);
            AttributeResource otherAttr = themeStyleSet.getAttrValue(otherAttrName);
            if (otherAttr == null) {
                this.strictError("no such attr %s in %s while resolving value for %s", attribute.value, themeStyleSet, resName.getFullyQualifiedName());
                attribute = null;
                continue;
            }
            attribute = new AttributeResource(resName, otherAttr.value, otherAttr.contextPackageName);
        }
        if (attribute == null || attribute.isNull()) {
            return null;
        }
        TypedValue typedValue = new TypedValue();
        this.convertAndFill(attribute, typedValue, this.config, true);
        return typedValue;
    }

    private void strictError(String message, Object ... args) {
        if (strictErrors) {
            throw new RuntimeException(String.format(message, args));
        }
        Logger.strict((String)message, (Object[])args);
    }

    TypedArray attrsToTypedArray(Resources resources, AttributeSet set, int[] attrs, int defStyleAttr, long nativeTheme, int defStyleRes) {
        CharSequence[] stringData = new CharSequence[attrs.length];
        int[] data = new int[attrs.length * 6];
        int[] indices = new int[attrs.length + 1];
        int nextIndex = 0;
        EmptyStyle themeStyleSet = nativeTheme == 0L ? new EmptyStyle() : ShadowLegacyAssetManager.getNativeTheme(nativeTheme).themeStyleSet;
        for (int i = 0; i < attrs.length; ++i) {
            int offset = i * 6;
            TypedValue typedValue = this.buildTypedValue(set, attrs[i], defStyleAttr, (Style)themeStyleSet, defStyleRes);
            if (typedValue == null) continue;
            data[offset + 0] = typedValue.type;
            data[offset + 1] = typedValue.type == 3 ? i : typedValue.data;
            data[offset + 2] = typedValue.assetCookie;
            data[offset + 3] = typedValue.resourceId;
            data[offset + 4] = typedValue.changingConfigurations;
            data[offset + 5] = typedValue.density;
            stringData[i] = typedValue.string;
            indices[nextIndex + 1] = i;
            ++nextIndex;
        }
        indices[0] = nextIndex;
        TypedArray typedArray = ShadowTypedArray.create(resources, attrs, data, indices, nextIndex, stringData);
        if (set != null) {
            ShadowTypedArray shadowTypedArray = (ShadowTypedArray)Shadow.extract((Object)typedArray);
            shadowTypedArray.positionDescription = set.getPositionDescription();
        }
        return typedArray;
    }

    private AttributeResource findAttributeValue(int resId, AttributeSet attributeSet, Style styleAttrStyle, Style defStyleFromAttr, Style defStyleFromRes, @Nonnull Style themeStyleSet) {
        AttributeResource attribute;
        ResName attrName;
        if (attributeSet != null) {
            for (int i = 0; i < attributeSet.getAttributeCount(); ++i) {
                ResName refResName;
                String attributeValue;
                if (attributeSet.getAttributeNameResource(i) != resId) continue;
                try {
                    attributeValue = attributeSet.getAttributeValue(i);
                }
                catch (IndexOutOfBoundsException e) {
                    continue;
                }
                if (attributeValue == null) continue;
                String defaultPackageName = ResourceIds.isFrameworkResource((int)resId) ? "android" : RuntimeEnvironment.getApplication().getPackageName();
                ResName resName = ResName.qualifyResName((String)attributeSet.getAttributeName(i), (String)defaultPackageName, (String)"attr");
                Integer referenceResId = null;
                if (AttributeResource.isResourceReference((String)attributeValue) && (referenceResId = Integer.valueOf(attributeSet.getAttributeResourceValue(i, -1))) != 0 && (refResName = this.resourceTable.getResName(referenceResId.intValue())) != null) {
                    String string2 = String.valueOf(refResName.getFullyQualifiedName());
                    attributeValue = string2.length() != 0 ? "@".concat(string2) : new String("@");
                }
                return new AttributeResource(resName, attributeValue, "fixme!!!", referenceResId);
            }
        }
        if ((attrName = this.resourceTable.getResName(resId)) == null) {
            return null;
        }
        if (styleAttrStyle != null && (attribute = styleAttrStyle.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromAttr != null && (attribute = defStyleFromAttr.getAttrValue(attrName)) != null) {
            return attribute;
        }
        if (defStyleFromRes != null && (attribute = defStyleFromRes.getAttrValue(attrName)) != null) {
            return attribute;
        }
        return themeStyleSet.getAttrValue(attrName);
    }

    @Override
    Collection<Path> getAllAssetDirs() {
        return this.assetDirs;
    }

    @Nonnull
    private ResName getResName(int id2) {
        ResName resName = this.resourceTable.getResName(id2);
        if (resName == null) {
            String string2 = String.valueOf(Integer.toHexString(id2));
            throw new Resources.NotFoundException(string2.length() != 0 ? "Resource ID #0x".concat(string2) : new String("Resource ID #0x"));
        }
        return resName;
    }

    @Implementation
    protected String getResourceName(int resid) {
        return this.getResName(resid).getFullyQualifiedName();
    }

    @Implementation
    protected String getResourcePackageName(int resid) {
        return this.getResName((int)resid).packageName;
    }

    @Implementation
    protected String getResourceTypeName(int resid) {
        return this.getResName((int)resid).type;
    }

    @Implementation
    protected String getResourceEntryName(int resid) {
        return this.getResName((int)resid).name;
    }

    @Implementation(maxSdk=27)
    protected int getArraySize(int id2) {
        return 0;
    }

    @Implementation(maxSdk=27)
    protected int retrieveArray(int id2, int[] outValues) {
        return 0;
    }

    @Implementation(maxSdk=27)
    protected Number getNativeStringBlock(int block) {
        throw new IllegalStateException();
    }

    @Implementation(minSdk=21, maxSdk=27)
    protected final SparseArray<String> getAssignedPackageIdentifiers() {
        return new SparseArray();
    }

    @Implementation(maxSdk=27)
    protected int loadResourceValue(int ident, short density, TypedValue outValue, boolean resolve) {
        return 0;
    }

    @Implementation(maxSdk=27)
    protected int loadResourceBagValue(int ident, int bagEntryId, TypedValue outValue, boolean resolve) {
        return 0;
    }

    @Implementation(minSdk=28)
    protected static void nativeAssetDestroy(long asset_ptr) {
        ShadowArscAssetManager9.nativeAssetDestroy(asset_ptr);
    }

    @Implementation(minSdk=28)
    protected static int nativeAssetReadChar(long asset_ptr) {
        return ShadowArscAssetManager9.nativeAssetReadChar(asset_ptr);
    }

    @Implementation(minSdk=28)
    protected static int nativeAssetRead(long asset_ptr, byte[] java_buffer, int offset, int len) throws IOException {
        return ShadowArscAssetManager9.nativeAssetRead(asset_ptr, java_buffer, offset, len);
    }

    @Implementation(minSdk=28)
    protected static long nativeAssetSeek(long asset_ptr, long offset, int whence) {
        return ShadowArscAssetManager9.nativeAssetSeek(asset_ptr, offset, whence);
    }

    @Implementation(minSdk=28)
    protected static long nativeAssetGetLength(long asset_ptr) {
        return ShadowArscAssetManager9.nativeAssetGetLength(asset_ptr);
    }

    @Implementation(minSdk=28)
    protected static long nativeAssetGetRemainingLength(long asset_ptr) {
        return ShadowArscAssetManager9.nativeAssetGetRemainingLength(asset_ptr);
    }

    @Implementation(minSdk=29, maxSdk=30)
    protected static String[] nativeCreateIdmapsForStaticOverlaysTargetingAndroid() {
        return new String[0];
    }

    @Resetter
    public static void reset() {
        if (ShadowLegacyAssetManager.useLegacy()) {
            if (RuntimeEnvironment.getApiLevel() >= 28) {
                ShadowAssetManager._AssetManager28_ _assetManagerStatic_ = (ShadowAssetManager._AssetManager28_)Reflector.reflector(ShadowAssetManager._AssetManager28_.class);
                _assetManagerStatic_.setSystemApkAssetsSet(null);
                _assetManagerStatic_.setSystemApkAssets(null);
            }
            ((ShadowAssetManager._AssetManager_)Reflector.reflector(ShadowAssetManager._AssetManager_.class)).setSystem(null);
        }
    }

    class NativeTheme {
        private ThemeStyleSet themeStyleSet;

        public NativeTheme(ThemeStyleSet themeStyleSet) {
            this.themeStyleSet = themeStyleSet;
        }

        public ShadowLegacyAssetManager getShadowAssetManager() {
            return ShadowLegacyAssetManager.this;
        }
    }
}

