/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.location.Criteria;
import android.location.GnssAntennaInfo;
import android.location.GnssMeasurementsEvent;
import android.location.GnssStatus;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.location.OnNmeaMessageListener;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSettings;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=LocationManager.class, looseSignatures=true)
public class ShadowLocationManager {
    private static final long GET_CURRENT_LOCATION_TIMEOUT_MS = 30000L;
    private static final long MAX_CURRENT_LOCATION_AGE_MS = 10000L;
    @Nullable
    private static Constructor<LocationProvider> locationProviderConstructor;
    @RealObject
    private LocationManager realLocationManager;
    @GuardedBy(value="providers")
    private final HashSet<ProviderEntry> providers = new HashSet();
    @GuardedBy(value="gpsStatusListeners")
    private final HashSet<GpsStatus.Listener> gpsStatusListeners = new HashSet();
    @GuardedBy(value="gnssStatusCallbacks")
    private final Map<GnssStatus.Callback, Executor> gnssStatusCallbacks = new LinkedHashMap<GnssStatus.Callback, Executor>();
    @GuardedBy(value="nmeaMessageListeners")
    private final Map<OnNmeaMessageListener, Executor> nmeaMessageListeners = new LinkedHashMap<OnNmeaMessageListener, Executor>();
    @GuardedBy(value="gnssMeasurementListeners")
    private final Map<GnssMeasurementsEvent.Callback, Executor> gnssMeasurementListeners = new LinkedHashMap<GnssMeasurementsEvent.Callback, Executor>();
    @GuardedBy(value="gnssAntennaInfoListeners")
    private final Map<GnssAntennaInfo.Listener, Executor> gnssAntennaInfoListeners = new LinkedHashMap<GnssAntennaInfo.Listener, Executor>();

    public ShadowLocationManager() {
        this.providers.add(new ProviderEntry("gps", new ProviderProperties(true, true, false, false, true, true, true, 3, 1)));
        this.providers.add(new ProviderEntry("network", new ProviderProperties(false, false, false, false, true, true, true, 1, 2)));
        this.providers.add(new ProviderEntry("passive", new ProviderProperties(false, false, false, false, false, false, false, 1, 2)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected List<String> getAllProviders() {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ArrayList<String> allProviders = new ArrayList<String>(this.providers.size());
            for (ProviderEntry providerEntry : this.providers) {
                allProviders.add(providerEntry.name);
            }
            return allProviders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    @Nullable
    protected LocationProvider getProvider(String name) {
        if (RuntimeEnvironment.getApiLevel() < 19) {
            return null;
        }
        ProviderEntry providerEntry = this.getProviderEntry(name);
        if (providerEntry == null) {
            return null;
        }
        try {
            Class<ShadowLocationManager> clazz = ShadowLocationManager.class;
            synchronized (ShadowLocationManager.class) {
                if (locationProviderConstructor == null) {
                    locationProviderConstructor = this.loadLocationProviderConstructor();
                    locationProviderConstructor.setAccessible(true);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return locationProviderConstructor.newInstance(name, providerEntry.createRealProperties());
            }
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    protected Constructor<LocationProvider> loadLocationProviderConstructor() throws ReflectiveOperationException {
        return LocationProvider.class.getConstructor(String.class, com.android.internal.location.ProviderProperties.class);
    }

    @Implementation
    protected List<String> getProviders(boolean enabledOnly) {
        return this.getProviders(null, enabledOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected List<String> getProviders(@Nullable Criteria criteria, boolean enabled) {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ArrayList<String> matchingProviders = new ArrayList<String>(this.providers.size());
            for (ProviderEntry providerEntry : this.providers) {
                if (enabled && !this.isProviderEnabled(providerEntry.name) || criteria != null && !providerEntry.meetsCriteria(criteria)) continue;
                matchingProviders.add(providerEntry.name);
            }
            return matchingProviders;
        }
    }

    @Implementation
    @Nullable
    protected String getBestProvider(Criteria criteria, boolean enabled) {
        List<String> providers = this.getProviders(criteria, enabled);
        if (providers.isEmpty()) {
            providers = this.getProviders(null, enabled);
        }
        if (!providers.isEmpty()) {
            if (providers.contains("gps")) {
                return "gps";
            }
            if (providers.contains("network")) {
                return "network";
            }
            return providers.get(0);
        }
        return null;
    }

    @Implementation
    protected boolean isProviderEnabled(String provider) {
        if (RuntimeEnvironment.getApiLevel() >= 28 && !this.isLocationEnabled()) {
            return false;
        }
        ProviderEntry entry = this.getProviderEntry(provider);
        return entry != null && entry.isEnabled();
    }

    public void removeProvider(String name) {
        this.removeProviderEntry(name);
    }

    public void setProviderProperties(String name, @Nullable ProviderProperties properties) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.getOrCreateProviderEntry(name).properties = properties;
    }

    public void setProviderEnabled(String name, boolean enabled) {
        this.getOrCreateProviderEntry(name).setEnabled(enabled);
    }

    @Implementation(minSdk=28)
    protected boolean isLocationEnabledForUser(UserHandle userHandle) {
        return this.isLocationEnabled();
    }

    private boolean isLocationEnabled() {
        return this.getLocationMode() != 0;
    }

    @Implementation(minSdk=28)
    protected void setLocationEnabledForUser(boolean enabled, UserHandle userHandle) {
        this.setLocationModeInternal(enabled ? 3 : 0);
    }

    public void setLocationEnabled(boolean enabled) {
        this.setLocationEnabledForUser(enabled, Process.myUserHandle());
    }

    private int getLocationMode() {
        return Settings.Secure.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"location_mode", (int)0);
    }

    public void setLocationMode(int locationMode) {
        if (RuntimeEnvironment.getApiLevel() >= 28) {
            throw new AssertionError((Object)"Tests may not set location mode directly on P and above. Instead, use setLocationEnabled() and setProviderEnabled() in combination to achieve the desired result.");
        }
        this.setLocationModeInternal(locationMode);
    }

    private void setLocationModeInternal(int locationMode) {
        Settings.Secure.putInt((ContentResolver)this.getContext().getContentResolver(), (String)"location_mode", (int)locationMode);
    }

    @Implementation
    @Nullable
    protected Location getLastKnownLocation(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return null;
        }
        return providerEntry.lastLocation;
    }

    public void setLastKnownLocation(String provider, @Nullable Location location) {
        this.getOrCreateProviderEntry(provider).lastLocation = location;
    }

    @Implementation(minSdk=30)
    protected void getCurrentLocation(String provider, @Nullable CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        this.getCurrentLocationInternal(provider, cancellationSignal, executor, consumer);
    }

    private void getCurrentLocationInternal(String provider, @Nullable CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        long locationAgeMs;
        Location location;
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        if ((location = this.getLastKnownLocation(provider)) != null && (locationAgeMs = SystemClock.elapsedRealtime() - TimeUnit.NANOSECONDS.toMillis(location.getElapsedRealtimeNanos())) < 10000L) {
            executor.execute(() -> consumer.accept(location));
            return;
        }
        CancellableLocationListener listener = new CancellableLocationListener(executor, consumer);
        this.requestLocationUpdatesInternal(provider, new LocationRequest(new android.location.LocationRequest()), Runnable::run, listener);
        if (cancellationSignal != null) {
            cancellationSignal.setOnCancelListener(listener::cancel);
        }
        listener.startTimeout(30000L);
    }

    @Implementation
    protected void requestSingleUpdate(String provider, LocationListener listener, @Nullable Looper looper) {
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(provider, new LocationRequest(true), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation
    protected void requestSingleUpdate(Criteria criteria, LocationListener listener, @Nullable Looper looper) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(bestProvider, new LocationRequest(true), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation
    protected void requestSingleUpdate(String provider, PendingIntent pendingIntent) {
        this.requestLocationUpdatesInternal(provider, new LocationRequest(true), pendingIntent);
    }

    @Implementation
    protected void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUpdatesInternal(bestProvider, new LocationRequest(true), pendingIntent);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener) {
        this.requestLocationUpdatesInternal(provider, new LocationRequest(minTime, minDistance), new HandlerExecutor(new Handler()), listener);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, LocationListener listener, @Nullable Looper looper) {
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(provider, new LocationRequest(minTime, minDistance), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation(minSdk=30)
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, Executor executor, LocationListener listener) {
        this.requestLocationUpdatesInternal(provider, new LocationRequest(minTime, minDistance), executor, listener);
    }

    @Implementation
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, LocationListener listener, @Nullable Looper looper) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        if (looper == null && (looper = Looper.myLooper()) == null) {
            new Handler();
        }
        this.requestLocationUpdatesInternal(bestProvider, new LocationRequest(minTime, minDistance), new HandlerExecutor(new Handler(looper)), listener);
    }

    @Implementation(minSdk=30)
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, Executor executor, LocationListener listener) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUpdatesInternal(bestProvider, new LocationRequest(minTime, minDistance), executor, listener);
    }

    @Implementation
    protected void requestLocationUpdates(String provider, long minTime, float minDistance, PendingIntent pendingIntent) {
        this.requestLocationUpdatesInternal(provider, new LocationRequest(minTime, minDistance), pendingIntent);
    }

    @Implementation
    protected void requestLocationUpdates(long minTime, float minDistance, Criteria criteria, PendingIntent pendingIntent) {
        String bestProvider = this.getBestProvider(criteria, true);
        if (bestProvider == null) {
            throw new IllegalArgumentException("no providers found for criteria");
        }
        this.requestLocationUpdatesInternal(bestProvider, new LocationRequest(minTime, minDistance), pendingIntent);
    }

    @Implementation(minSdk=21)
    protected void requestLocationUpdates(@Nullable Object request, Object executorOrListener, Object listenerOrLooper) {
        if (request == null) {
            request = new android.location.LocationRequest();
        }
        if (executorOrListener instanceof Executor) {
            this.requestLocationUpdatesInternal(((android.location.LocationRequest)request).getProvider(), new LocationRequest((android.location.LocationRequest)request), (Executor)executorOrListener, (LocationListener)listenerOrLooper);
        } else if (executorOrListener instanceof LocationListener) {
            if (listenerOrLooper == null && (listenerOrLooper = Looper.myLooper()) == null) {
                new Handler();
            }
            this.requestLocationUpdatesInternal(((android.location.LocationRequest)request).getProvider(), new LocationRequest((android.location.LocationRequest)request), new HandlerExecutor(new Handler((Looper)listenerOrLooper)), (LocationListener)executorOrListener);
        }
    }

    @Implementation(minSdk=21)
    protected void requestLocationUpdates(@Nullable Object request, Object pendingIntent) {
        if (request == null) {
            request = new android.location.LocationRequest();
        }
        this.requestLocationUpdatesInternal(((android.location.LocationRequest)request).getProvider(), new LocationRequest((android.location.LocationRequest)request), (PendingIntent)pendingIntent);
    }

    private void requestLocationUpdatesInternal(String provider, LocationRequest request, Executor executor, LocationListener listener) {
        if (provider == null || request == null || executor == null || listener == null) {
            throw new IllegalArgumentException();
        }
        this.getOrCreateProviderEntry(provider).addListener(listener, request, executor);
    }

    private void requestLocationUpdatesInternal(String provider, LocationRequest request, PendingIntent pendingIntent) {
        if (provider == null || request == null || pendingIntent == null) {
            throw new IllegalArgumentException();
        }
        this.getOrCreateProviderEntry(provider).addListener(pendingIntent, request);
    }

    @Implementation
    protected void removeUpdates(LocationListener listener) {
        this.removeListenerInternal(listener);
    }

    @Implementation
    protected void removeUpdates(PendingIntent pendingIntent) {
        this.removeListenerInternal(pendingIntent);
    }

    @Implementation(minSdk=28)
    protected boolean injectLocation(Location location) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected boolean addGpsStatusListener(GpsStatus.Listener listener) {
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            this.gpsStatusListeners.add(listener);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected void removeGpsStatusListener(GpsStatus.Listener listener) {
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            this.gpsStatusListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GpsStatus.Listener> getGpsStatusListeners() {
        HashSet<GpsStatus.Listener> hashSet = this.gpsStatusListeners;
        synchronized (hashSet) {
            return new ArrayList<GpsStatus.Listener>(this.gpsStatusListeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected boolean registerGnssStatusCallback(GnssStatus.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        Map<GnssStatus.Callback, Executor> map = this.gnssStatusCallbacks;
        synchronized (map) {
            this.gnssStatusCallbacks.put(callback, new HandlerExecutor(handler));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected boolean registerGnssStatusCallback(Executor executor, GnssStatus.Callback callback) {
        Map<GnssStatus.Callback, Executor> map = this.gnssStatusCallbacks;
        synchronized (map) {
            this.gnssStatusCallbacks.put(callback, executor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void unregisterGnssStatusCallback(GnssStatus.Callback callback) {
        Map<GnssStatus.Callback, Executor> map = this.gnssStatusCallbacks;
        synchronized (map) {
            this.gnssStatusCallbacks.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGnssStatus(GnssStatus status) {
        LinkedHashMap<GnssStatus.Callback, Executor> callbacks;
        Map<GnssStatus.Callback, Executor> map = this.gnssStatusCallbacks;
        synchronized (map) {
            callbacks = new LinkedHashMap<GnssStatus.Callback, Executor>(this.gnssStatusCallbacks);
        }
        for (Map.Entry entry : callbacks.entrySet()) {
            ((Executor)entry.getValue()).execute(() -> ((GnssStatus.Callback)callback.getKey()).onSatelliteStatusChanged(status));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected boolean addNmeaListener(OnNmeaMessageListener listener, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        Map<OnNmeaMessageListener, Executor> map = this.nmeaMessageListeners;
        synchronized (map) {
            this.nmeaMessageListeners.put(listener, new HandlerExecutor(handler));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected boolean addNmeaListener(Executor executor, OnNmeaMessageListener listener) {
        Map<OnNmeaMessageListener, Executor> map = this.nmeaMessageListeners;
        synchronized (map) {
            this.nmeaMessageListeners.put(listener, executor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void removeNmeaListener(OnNmeaMessageListener listener) {
        Map<OnNmeaMessageListener, Executor> map = this.nmeaMessageListeners;
        synchronized (map) {
            this.nmeaMessageListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNmeaMessage(String message, long timestamp) {
        LinkedHashMap<OnNmeaMessageListener, Executor> listeners;
        Map<OnNmeaMessageListener, Executor> map = this.nmeaMessageListeners;
        synchronized (map) {
            listeners = new LinkedHashMap<OnNmeaMessageListener, Executor>(this.nmeaMessageListeners);
        }
        for (Map.Entry entry : listeners.entrySet()) {
            ((Executor)entry.getValue()).execute(() -> ((OnNmeaMessageListener)listener.getKey()).onNmeaMessage(message, timestamp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        Map<GnssMeasurementsEvent.Callback, Executor> map = this.gnssMeasurementListeners;
        synchronized (map) {
            this.gnssMeasurementListeners.put(callback, new HandlerExecutor(handler));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected boolean registerGnssMeasurementsCallback(Executor executor, GnssMeasurementsEvent.Callback callback) {
        Map<GnssMeasurementsEvent.Callback, Executor> map = this.gnssMeasurementListeners;
        synchronized (map) {
            this.gnssMeasurementListeners.put(callback, executor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=24)
    protected void unregisterGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        Map<GnssMeasurementsEvent.Callback, Executor> map = this.gnssMeasurementListeners;
        synchronized (map) {
            this.gnssMeasurementListeners.remove(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGnssMeasurementsEvent(GnssMeasurementsEvent event) {
        LinkedHashMap<GnssMeasurementsEvent.Callback, Executor> listeners;
        Map<GnssMeasurementsEvent.Callback, Executor> map = this.gnssMeasurementListeners;
        synchronized (map) {
            listeners = new LinkedHashMap<GnssMeasurementsEvent.Callback, Executor>(this.gnssMeasurementListeners);
        }
        for (Map.Entry entry : listeners.entrySet()) {
            ((Executor)entry.getValue()).execute(() -> ((GnssMeasurementsEvent.Callback)listener.getKey()).onGnssMeasurementsReceived(event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected boolean registerAntennaInfoListener(Executor executor, GnssAntennaInfo.Listener listener) {
        Map<GnssAntennaInfo.Listener, Executor> map = this.gnssAntennaInfoListeners;
        synchronized (map) {
            this.gnssAntennaInfoListeners.put(listener, executor);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=30)
    protected void unregisterAntennaInfoListener(GnssAntennaInfo.Listener listener) {
        Map<GnssAntennaInfo.Listener, Executor> map = this.gnssAntennaInfoListeners;
        synchronized (map) {
            this.gnssAntennaInfoListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGnssAntennaInfo(List<GnssAntennaInfo> antennaInfos) {
        LinkedHashMap<GnssAntennaInfo.Listener, Executor> listeners;
        Map<GnssAntennaInfo.Listener, Executor> map = this.gnssAntennaInfoListeners;
        synchronized (map) {
            listeners = new LinkedHashMap<GnssAntennaInfo.Listener, Executor>(this.gnssAntennaInfoListeners);
        }
        for (Map.Entry entry : listeners.entrySet()) {
            ((Executor)entry.getValue()).execute(() -> ((GnssAntennaInfo.Listener)listener.getKey()).onGnssAntennaInfoReceived(antennaInfos));
        }
    }

    @Deprecated
    public List<LocationListener> getRequestLocationUpdateListeners() {
        return new ArrayList<LocationListener>(this.getLocationUpdateListeners());
    }

    public void simulateLocation(Location location) {
        ProviderEntry passiveProviderEntry;
        if (location == null) {
            throw new NullPointerException();
        }
        ProviderEntry providerEntry = this.getOrCreateProviderEntry(location.getProvider());
        if (!"passive".equals(providerEntry.name)) {
            providerEntry.simulateLocation(location);
        }
        if ((passiveProviderEntry = this.getProviderEntry("passive")) != null) {
            passiveProviderEntry.simulateLocation(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<LocationListener> getLocationUpdateListeners() {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            HashSet<LocationListener> listeners = new HashSet<LocationListener>();
            for (ProviderEntry providerEntry : this.providers) {
                for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
                    LocationTransport transport = listenerEntry.transport;
                    if (!(transport instanceof ListenerTransport)) continue;
                    listeners.add(((ListenerTransport)transport).locationListener);
                }
            }
            return new ArrayList<LocationListener>(listeners);
        }
    }

    @Deprecated
    public List<LocationListener> getLocationUpdateListeners(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<LocationListener> listeners = new ArrayList<LocationListener>(providerEntry.listeners.size());
        for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
            LocationTransport transport = listenerEntry.transport;
            if (!(transport instanceof ListenerTransport)) continue;
            listeners.add(((ListenerTransport)transport).locationListener);
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<PendingIntent> getLocationUpdatePendingIntents() {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            HashSet<PendingIntent> pendingIntents = new HashSet<PendingIntent>();
            for (ProviderEntry providerEntry : this.providers) {
                for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
                    LocationTransport transport = listenerEntry.transport;
                    if (!(transport instanceof PendingIntentTransport)) continue;
                    pendingIntents.add(((PendingIntentTransport)transport).pendingIntent);
                }
            }
            return new ArrayList<PendingIntent>(pendingIntents);
        }
    }

    @Deprecated
    public List<PendingIntent> getLocationUpdatePendingIntents(String provider) {
        ProviderEntry providerEntry = this.getProviderEntry(provider);
        if (providerEntry == null) {
            return Collections.emptyList();
        }
        ArrayList<PendingIntent> pendingIntents = new ArrayList<PendingIntent>(providerEntry.listeners.size());
        for (ProviderEntry.ListenerEntry listenerEntry : providerEntry.listeners) {
            LocationTransport transport = listenerEntry.transport;
            if (!(transport instanceof PendingIntentTransport)) continue;
            pendingIntents.add(((PendingIntentTransport)transport).pendingIntent);
        }
        return pendingIntents;
    }

    private Context getContext() {
        return (Context)ReflectionHelpers.getField((Object)this.realLocationManager, (String)"mContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProviderEntry getOrCreateProviderEntry(String name) {
        if (name == null) {
            throw new IllegalArgumentException("cannot use a null provider");
        }
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ProviderEntry providerEntry = this.getProviderEntry(name);
            if (providerEntry == null) {
                providerEntry = new ProviderEntry(name, null);
                this.providers.add(providerEntry);
            }
            return providerEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListenerInternal(Object key) {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            for (ProviderEntry providerEntry : this.providers) {
                providerEntry.removeListener(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private ProviderEntry getProviderEntry(String name) {
        if (name == null) {
            return null;
        }
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            for (ProviderEntry providerEntry : this.providers) {
                if (!name.equals(providerEntry.name)) continue;
                return providerEntry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProviderEntry(String name) {
        HashSet<ProviderEntry> hashSet = this.providers;
        synchronized (hashSet) {
            ProviderEntry providerEntry = this.getProviderEntry(name);
            this.providers.remove(providerEntry);
        }
    }

    protected Object createRealProperties(boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
        return new com.android.internal.location.ProviderProperties(requiresNetwork, requiresSatellite, requiresCell, hasMonetaryCost, supportsAltitude, supportsSpeed, supportsBearing, powerRequirement, accuracy);
    }

    private static float distanceBetween(Location location1, Location location2) {
        double earthRadius = 3958.75;
        double latDifference = Math.toRadians(location2.getLatitude() - location1.getLatitude());
        double lonDifference = Math.toRadians(location2.getLongitude() - location1.getLongitude());
        double a = Math.sin(latDifference / 2.0) * Math.sin(latDifference / 2.0) + Math.cos(Math.toRadians(location1.getLatitude())) * Math.cos(Math.toRadians(location2.getLatitude())) * Math.sin(lonDifference / 2.0) * Math.sin(lonDifference / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = Math.abs(earthRadius * c);
        int meterConversion = 1609;
        return (float)(dist * (double)meterConversion);
    }

    @Resetter
    public static void reset() {
        locationProviderConstructor = null;
    }

    private static final class HandlerExecutor
    implements Executor {
        private final Handler handler;

        HandlerExecutor(Handler handler) {
            this.handler = Objects.requireNonNull(handler);
        }

        @Override
        public void execute(Runnable command) {
            if (!this.handler.post(command)) {
                String string2 = String.valueOf(this.handler);
                throw new RejectedExecutionException(new StringBuilder(17 + String.valueOf(string2).length()).append(string2).append(" is shutting down").toString());
            }
        }
    }

    private final class CancellableLocationListener
    implements LocationListener {
        private final Executor executor;
        private final Consumer<Location> consumer;
        private final Handler timeoutHandler;
        @GuardedBy(value="this")
        private boolean triggered;
        @Nullable
        Runnable timeoutRunnable;

        CancellableLocationListener(Executor executor, Consumer<Location> consumer) {
            this.executor = executor;
            this.consumer = consumer;
            this.timeoutHandler = new Handler(Looper.getMainLooper());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            CancellableLocationListener cancellableLocationListener = this;
            synchronized (cancellableLocationListener) {
                if (this.triggered) {
                    return;
                }
                this.triggered = true;
            }
            this.cleanup();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTimeout(long timeoutMs) {
            CancellableLocationListener cancellableLocationListener = this;
            synchronized (cancellableLocationListener) {
                if (this.triggered) {
                    return;
                }
                this.timeoutRunnable = () -> {
                    this.timeoutRunnable = null;
                    this.onLocationChanged(null);
                };
                this.timeoutHandler.postDelayed(this.timeoutRunnable, timeoutMs);
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
            this.onLocationChanged(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLocationChanged(@Nullable Location location) {
            CancellableLocationListener cancellableLocationListener = this;
            synchronized (cancellableLocationListener) {
                if (this.triggered) {
                    return;
                }
                this.triggered = true;
            }
            this.executor.execute(() -> this.consumer.accept(location));
            this.cleanup();
        }

        private void cleanup() {
            ShadowLocationManager.this.removeUpdates(this);
            if (this.timeoutRunnable != null) {
                this.timeoutHandler.removeCallbacks(this.timeoutRunnable);
                this.timeoutRunnable = null;
            }
        }
    }

    private static final class PendingIntentTransport
    implements LocationTransport {
        private final PendingIntent pendingIntent;
        private final Context context;

        PendingIntentTransport(PendingIntent pendingIntent, Context context) {
            this.pendingIntent = pendingIntent;
            this.context = context;
        }

        @Override
        public void onLocation(Location location) throws PendingIntent.CanceledException {
            Intent intent = new Intent();
            intent.putExtra("location", (Parcelable)new Location(location));
            this.pendingIntent.send(this.context, 0, intent);
        }

        @Override
        public void onProviderEnabled(String provider, boolean enabled) throws PendingIntent.CanceledException {
            Intent intent = new Intent();
            intent.putExtra("providerEnabled", enabled);
            this.pendingIntent.send(this.context, 0, intent);
        }
    }

    private static final class ListenerTransport
    implements LocationTransport {
        private final Executor executor;
        private final LocationListener locationListener;

        ListenerTransport(Executor executor, LocationListener locationListener) {
            this.executor = executor;
            this.locationListener = locationListener;
        }

        @Override
        public void onLocation(Location location) {
            this.executor.execute(() -> this.locationListener.onLocationChanged(new Location(location)));
        }

        @Override
        public void onProviderEnabled(String provider, boolean enabled) {
            this.executor.execute(() -> {
                if (enabled) {
                    this.locationListener.onProviderEnabled(provider);
                } else {
                    this.locationListener.onProviderDisabled(provider);
                }
            });
        }
    }

    private static interface LocationTransport {
        public void onLocation(Location var1) throws Exception;

        public void onProviderEnabled(String var1, boolean var2) throws Exception;
    }

    private static class LocationRequest {
        private final long minUpdateIntervalMillis;
        private final int maxUpdates;
        private final float minUpdateDistanceMeters;

        LocationRequest(android.location.LocationRequest locationRequest) {
            this.minUpdateIntervalMillis = locationRequest.getFastestInterval();
            this.maxUpdates = locationRequest.getNumUpdates();
            this.minUpdateDistanceMeters = locationRequest.getSmallestDisplacement();
        }

        LocationRequest(long interval, float minUpdateDistanceMeters) {
            this.minUpdateIntervalMillis = interval;
            this.maxUpdates = Integer.MAX_VALUE;
            this.minUpdateDistanceMeters = minUpdateDistanceMeters;
        }

        LocationRequest(boolean singleShot) {
            this.minUpdateIntervalMillis = 0L;
            this.maxUpdates = singleShot ? 1 : Integer.MAX_VALUE;
            this.minUpdateDistanceMeters = 0.0f;
        }
    }

    private final class ProviderEntry {
        private final String name;
        private final CopyOnWriteArraySet<ListenerEntry> listeners;
        @Nullable
        private volatile ProviderProperties properties;
        private boolean enabled;
        private Location lastLocation;

        private ProviderEntry(@Nullable String name, ProviderProperties properties) {
            this.name = name;
            this.listeners = new CopyOnWriteArraySet();
            this.properties = properties;
            switch (name) {
                case "passive": {
                    this.enabled = true;
                    break;
                }
                case "gps": {
                    this.enabled = true;
                    break;
                }
                case "network": {
                    this.enabled = false;
                    break;
                }
                default: {
                    this.enabled = false;
                }
            }
        }

        public boolean isEnabled() {
            if ("passive".equals(this.name) || RuntimeEnvironment.getApiLevel() >= 29) {
                return this.enabled;
            }
            String allowedProviders = Settings.Secure.getString((ContentResolver)ShadowLocationManager.this.getContext().getContentResolver(), (String)"location_providers_allowed");
            if (TextUtils.isEmpty((CharSequence)allowedProviders)) {
                return false;
            }
            return Arrays.asList(allowedProviders.split(",")).contains(this.name);
        }

        public void setEnabled(boolean enabled) {
            int oldLocationMode;
            if ("passive".equals(this.name)) {
                this.enabled = enabled;
                return;
            }
            int newLocationMode = oldLocationMode = ShadowLocationManager.this.getLocationMode();
            if (RuntimeEnvironment.getApiLevel() < 28) {
                if ("gps".equals(this.name)) {
                    if (enabled) {
                        switch (oldLocationMode) {
                            case 0: {
                                newLocationMode = 1;
                                break;
                            }
                            case 2: {
                                newLocationMode = 3;
                                break;
                            }
                        }
                    } else {
                        switch (oldLocationMode) {
                            case 1: {
                                newLocationMode = 0;
                                break;
                            }
                            case 3: {
                                newLocationMode = 2;
                                break;
                            }
                        }
                    }
                } else if ("network".equals(this.name)) {
                    if (enabled) {
                        switch (oldLocationMode) {
                            case 0: {
                                newLocationMode = 2;
                                break;
                            }
                            case 1: {
                                newLocationMode = 3;
                                break;
                            }
                        }
                    } else {
                        switch (oldLocationMode) {
                            case 2: {
                                newLocationMode = 0;
                                break;
                            }
                            case 3: {
                                newLocationMode = 1;
                                break;
                            }
                        }
                    }
                }
            }
            if (newLocationMode != oldLocationMode) {
                ShadowLocationManager.this.setLocationModeInternal(newLocationMode);
            } else if (RuntimeEnvironment.getApiLevel() >= 29) {
                if (enabled == this.enabled) {
                    return;
                }
                this.enabled = enabled;
                ShadowSettings.ShadowSecure.updateEnabledProviders(ShadowLocationManager.this.getContext().getContentResolver(), this.name, enabled);
            } else {
                if (enabled == this.enabled) {
                    return;
                }
                this.enabled = enabled;
                ShadowSettings.ShadowSecure.updateEnabledProviders(ShadowLocationManager.this.getContext().getContentResolver(), this.name, enabled);
            }
            for (ListenerEntry listener : this.listeners) {
                listener.invokeOnProviderEnabled(this.name, enabled);
            }
        }

        public void simulateLocation(Location location) {
            this.lastLocation = new Location(location);
            for (ListenerEntry listenerEntry : this.listeners) {
                listenerEntry.simulateLocation(location);
            }
        }

        public boolean meetsCriteria(Criteria criteria) {
            if ("passive".equals(this.name)) {
                return false;
            }
            ProviderProperties myProperties = this.properties;
            if (myProperties == null) {
                return false;
            }
            return myProperties.meetsCriteria(criteria);
        }

        public Object createRealProperties() {
            ProviderProperties myProperties = this.properties;
            if (myProperties == null) {
                return null;
            }
            return ShadowLocationManager.this.createRealProperties(myProperties.requiresNetwork, myProperties.requiresSatellite, myProperties.requiresCell, myProperties.hasMonetaryCost, myProperties.supportsAltitude, myProperties.supportsSpeed, myProperties.supportsBearing, myProperties.powerRequirement, myProperties.accuracy);
        }

        public void addListener(LocationListener listener, LocationRequest request, Executor executor) {
            this.add(new ListenerEntry(listener, request, new ListenerTransport(executor, listener)));
        }

        public void addListener(PendingIntent pendingIntent, LocationRequest request) {
            this.add(new ListenerEntry(pendingIntent, request, new PendingIntentTransport(pendingIntent, ShadowLocationManager.this.getContext())));
        }

        private void add(ListenerEntry entry) {
            if (!this.enabled) {
                entry.invokeOnProviderEnabled(this.name, false);
            }
            this.listeners.add(entry);
        }

        public void removeListener(Object key) {
            for (ListenerEntry listenerEntry : this.listeners) {
                if (listenerEntry.key != key) continue;
                this.listeners.remove(listenerEntry);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProviderEntry)) {
                return false;
            }
            ProviderEntry that = (ProviderEntry)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        private final class ListenerEntry {
            private final Object key;
            private final LocationTransport transport;
            private final LocationRequest request;
            private Location lastDeliveredLocation;
            private int numDeliveries;

            private ListenerEntry(Object key, LocationRequest request, LocationTransport transport) {
                if (key == null) {
                    throw new IllegalArgumentException();
                }
                this.key = key;
                this.request = request;
                this.transport = transport;
            }

            public void simulateLocation(Location location) {
                if (this.lastDeliveredLocation != null) {
                    if (location.getTime() - this.lastDeliveredLocation.getTime() < this.request.minUpdateIntervalMillis) {
                        return;
                    }
                    if (ShadowLocationManager.distanceBetween(location, this.lastDeliveredLocation) < this.request.minUpdateDistanceMeters) {
                        return;
                    }
                }
                this.lastDeliveredLocation = new Location(location);
                if (++this.numDeliveries >= this.request.maxUpdates) {
                    ProviderEntry.this.listeners.remove(this);
                }
                try {
                    this.transport.onLocation(location);
                }
                catch (Exception e) {
                    ProviderEntry.this.removeListener(this.key);
                }
            }

            public void invokeOnProviderEnabled(String provider, boolean enabled) {
                try {
                    this.transport.onProviderEnabled(provider, enabled);
                }
                catch (Exception e) {
                    ProviderEntry.this.removeListener(this.key);
                }
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ListenerEntry)) {
                    return false;
                }
                ListenerEntry that = (ListenerEntry)o;
                return this.key == that.key;
            }

            public int hashCode() {
                return Objects.hashCode(this.key);
            }
        }
    }

    public static class ProviderProperties {
        private final boolean requiresNetwork;
        private final boolean requiresSatellite;
        private final boolean requiresCell;
        private final boolean hasMonetaryCost;
        private final boolean supportsAltitude;
        private final boolean supportsSpeed;
        private final boolean supportsBearing;
        private final int powerRequirement;
        private final int accuracy;

        public ProviderProperties(boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerRequirement, int accuracy) {
            this.requiresNetwork = requiresNetwork;
            this.requiresSatellite = requiresSatellite;
            this.requiresCell = requiresCell;
            this.hasMonetaryCost = hasMonetaryCost;
            this.supportsAltitude = supportsAltitude;
            this.supportsSpeed = supportsSpeed;
            this.supportsBearing = supportsBearing;
            this.powerRequirement = powerRequirement;
            this.accuracy = accuracy;
        }

        public ProviderProperties(Criteria criteria) {
            this.requiresNetwork = false;
            this.requiresSatellite = false;
            this.requiresCell = false;
            this.hasMonetaryCost = criteria.isCostAllowed();
            this.supportsAltitude = criteria.isAltitudeRequired();
            this.supportsSpeed = criteria.isSpeedRequired();
            this.supportsBearing = criteria.isBearingRequired();
            this.powerRequirement = criteria.getPowerRequirement();
            this.accuracy = criteria.getAccuracy();
        }

        private boolean meetsCriteria(Criteria criteria) {
            if (criteria.getAccuracy() != 0 && criteria.getAccuracy() < this.accuracy) {
                return false;
            }
            if (criteria.getPowerRequirement() != 0 && criteria.getPowerRequirement() < this.powerRequirement) {
                return false;
            }
            if (criteria.isAltitudeRequired() && !this.supportsAltitude) {
                return false;
            }
            if (criteria.isSpeedRequired() && !this.supportsSpeed) {
                return false;
            }
            if (criteria.isBearingRequired() && !this.supportsBearing) {
                return false;
            }
            return criteria.isCostAllowed() || !this.hasMonetaryCost;
        }
    }
}

