/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.Log;
import com.google.common.base.Ascii;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Supplier;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=Log.class)
public class ShadowLog {
    public static PrintStream stream;
    private static final int EXTRA_LOG_LENGTH;
    private static final Map<String, Queue<LogItem>> logsByTag;
    private static final Queue<LogItem> logs;
    private static final Map<String, Integer> tagToLevel;
    private static boolean wtfIsFatal;
    private static Supplier<String> timeSupplier;

    @Implementation
    protected static int e(String tag, String msg) {
        return ShadowLog.e(tag, msg, null);
    }

    @Implementation
    protected static int e(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(6, tag, msg, throwable);
    }

    @Implementation
    protected static int d(String tag, String msg) {
        return ShadowLog.d(tag, msg, null);
    }

    @Implementation
    protected static int d(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(3, tag, msg, throwable);
    }

    @Implementation
    protected static int i(String tag, String msg) {
        return ShadowLog.i(tag, msg, null);
    }

    @Implementation
    protected static int i(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(4, tag, msg, throwable);
    }

    @Implementation
    protected static int v(String tag, String msg) {
        return ShadowLog.v(tag, msg, null);
    }

    @Implementation
    protected static int v(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(2, tag, msg, throwable);
    }

    @Implementation
    protected static int w(String tag, String msg) {
        return ShadowLog.w(tag, msg, null);
    }

    @Implementation
    protected static int w(String tag, Throwable throwable) {
        return ShadowLog.w(tag, null, throwable);
    }

    @Implementation
    protected static int w(String tag, String msg, Throwable throwable) {
        return ShadowLog.addLog(5, tag, msg, throwable);
    }

    @Implementation
    protected static int wtf(String tag, String msg) {
        return ShadowLog.wtf(tag, msg, null);
    }

    @Implementation
    protected static int wtf(String tag, String msg, Throwable throwable) {
        ShadowLog.addLog(7, tag, msg, throwable);
        if (wtfIsFatal) {
            throw new TerribleFailure(msg, throwable);
        }
        return 0;
    }

    public static void setWtfIsFatal(boolean fatal) {
        wtfIsFatal = fatal;
    }

    public static void setTimeSupplier(Supplier<String> supplier) {
        timeSupplier = supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation
    protected static boolean isLoggable(String tag, int level) {
        Map<String, Integer> map = tagToLevel;
        synchronized (map) {
            if (tagToLevel.containsKey(tag)) {
                return level >= tagToLevel.get(tag);
            }
        }
        return stream != null || level >= 4;
    }

    @Implementation
    protected static int println_native(int bufID, int priority, String tag, String msg) {
        ShadowLog.addLog(priority, tag, msg, null);
        int tagLength = tag == null ? 0 : tag.length();
        int msgLength = msg == null ? 0 : msg.length();
        return EXTRA_LOG_LENGTH + tagLength + msgLength;
    }

    public static void setLoggable(String tag, int level) {
        tagToLevel.put(tag, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int addLog(int level, String tag, String msg, Throwable throwable) {
        Queue<Object> itemList;
        String timeString = null;
        if (timeSupplier != null) {
            timeString = timeSupplier.get();
        }
        if (stream != null) {
            ShadowLog.logToStream(stream, timeString, level, tag, msg, throwable);
        }
        LogItem item = new LogItem(timeString, level, tag, msg, throwable);
        Map<String, Queue<LogItem>> map = logsByTag;
        synchronized (map) {
            if (!logsByTag.containsKey(tag)) {
                itemList = new ConcurrentLinkedQueue();
                logsByTag.put(tag, itemList);
            } else {
                itemList = logsByTag.get(tag);
            }
        }
        itemList.add(item);
        logs.add(item);
        return 0;
    }

    protected static char levelToChar(int level) {
        char c;
        switch (level) {
            case 7: {
                c = 'A';
                break;
            }
            case 3: {
                c = 'D';
                break;
            }
            case 6: {
                c = 'E';
                break;
            }
            case 5: {
                c = 'W';
                break;
            }
            case 4: {
                c = 'I';
                break;
            }
            case 2: {
                c = 'V';
                break;
            }
            default: {
                c = '?';
            }
        }
        return c;
    }

    private static void logToStream(PrintStream ps, String timeString, int level, String tag, String msg, Throwable throwable) {
        String outputString;
        if (timeString != null && timeString.length() > 0) {
            char c = ShadowLog.levelToChar(level);
            outputString = new StringBuilder(5 + String.valueOf(timeString).length() + String.valueOf(tag).length() + String.valueOf(msg).length()).append(timeString).append(" ").append(c).append("/").append(tag).append(": ").append(msg).toString();
        } else {
            char c = ShadowLog.levelToChar(level);
            outputString = new StringBuilder(4 + String.valueOf(tag).length() + String.valueOf(msg).length()).append(c).append("/").append(tag).append(": ").append(msg).toString();
        }
        ps.println(outputString);
        if (throwable != null) {
            throwable.printStackTrace(ps);
        }
    }

    public static ImmutableList<LogItem> getLogs() {
        return ImmutableList.copyOf(logs);
    }

    public static ImmutableList<LogItem> getLogsForTag(String tag) {
        Queue<LogItem> logs = logsByTag.get(tag);
        return logs == null ? ImmutableList.of() : ImmutableList.copyOf(logs);
    }

    public static void clear() {
        ShadowLog.reset();
    }

    @Resetter
    public static void reset() {
        logs.clear();
        logsByTag.clear();
        tagToLevel.clear();
        wtfIsFatal = false;
    }

    public static void setupLogging() {
        String logging = System.getProperty("robolectric.logging");
        if (logging != null && stream == null) {
            PrintStream stream = null;
            if (Ascii.equalsIgnoreCase((CharSequence)"stdout", (CharSequence)logging)) {
                stream = System.out;
            } else if (Ascii.equalsIgnoreCase((CharSequence)"stderr", (CharSequence)logging)) {
                stream = System.err;
            } else {
                try {
                    PrintStream file;
                    stream = file = new PrintStream(new FileOutputStream(logging), true);
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            file.close();
                        }
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ShadowLog.stream = stream;
        }
    }

    static {
        EXTRA_LOG_LENGTH = "l/: \n".length();
        logsByTag = Collections.synchronizedMap(new HashMap());
        logs = new ConcurrentLinkedQueue<LogItem>();
        tagToLevel = Collections.synchronizedMap(new HashMap());
        wtfIsFatal = false;
    }

    public static final class TerribleFailure
    extends RuntimeException {
        TerribleFailure(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static final class LogItem {
        public final String timeString;
        public final int type;
        public final String tag;
        public final String msg;
        public final Throwable throwable;

        public LogItem(int type, String tag, String msg, Throwable throwable) {
            this.timeString = null;
            this.type = type;
            this.tag = tag;
            this.msg = msg;
            this.throwable = throwable;
        }

        public LogItem(String timeString, int type, String tag, String msg, Throwable throwable) {
            this.timeString = timeString;
            this.type = type;
            this.tag = tag;
            this.msg = msg;
            this.throwable = throwable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LogItem)) {
                return false;
            }
            LogItem log = (LogItem)o;
            return !(this.type != log.type || (this.timeString == null ? log.timeString != null : !this.timeString.equals(log.timeString)) || (this.msg == null ? log.msg != null : !this.msg.equals(log.msg)) || (this.tag == null ? log.tag != null : !this.tag.equals(log.tag)) || (this.throwable == null ? log.throwable != null : !this.throwable.equals(log.throwable)));
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.timeString != null ? this.timeString.hashCode() : 0);
            result = 31 * result + this.type;
            result = 31 * result + (this.tag != null ? this.tag.hashCode() : 0);
            result = 31 * result + (this.msg != null ? this.msg.hashCode() : 0);
            result = 31 * result + (this.throwable != null ? this.throwable.hashCode() : 0);
            return result;
        }

        public String toString() {
            String string2 = this.timeString;
            int n = this.type;
            String string3 = this.tag;
            String string4 = this.msg;
            String string5 = this.throwable == null ? null : Throwables.getStackTraceAsString((Throwable)this.throwable);
            return new StringBuilder(76 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("LogItem{\n  timeString='").append(string2).append('\'').append("\n  type=").append(n).append("\n  tag='").append(string3).append('\'').append("\n  msg='").append(string4).append('\'').append("\n  throwable=").append(string5).append("\n}").toString();
        }
    }
}

