/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.MediaMetadata;
import android.media.session.MediaController;
import android.media.session.PlaybackState;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaController.class, minSdk=21)
public class ShadowMediaController {
    @RealObject
    private MediaController realMediaController;
    private PlaybackState playbackState;
    private MediaController.PlaybackInfo playbackInfo;
    private MediaMetadata mediaMetadata;
    private int ratingType = 0;
    private final List<MediaController.Callback> callbacks = new ArrayList<MediaController.Callback>();

    public void setPackageName(String packageName) {
        ReflectionHelpers.setField((Object)this.realMediaController, (String)"mPackageName", (Object)packageName);
    }

    public void setPlaybackState(PlaybackState playbackState) {
        this.playbackState = playbackState;
    }

    @Implementation
    protected PlaybackState getPlaybackState() {
        return this.playbackState;
    }

    public void setPlaybackInfo(MediaController.PlaybackInfo playbackInfo) {
        this.playbackInfo = playbackInfo;
    }

    @Implementation
    protected MediaController.PlaybackInfo getPlaybackInfo() {
        return this.playbackInfo;
    }

    public void setMetadata(MediaMetadata mediaMetadata) {
        this.mediaMetadata = mediaMetadata;
    }

    @Implementation
    protected MediaMetadata getMetadata() {
        return this.mediaMetadata;
    }

    public void setRatingType(int ratingType) {
        if (ratingType < 0 || ratingType > 6) {
            throw new IllegalArgumentException(new StringBuilder(68).append("Invalid RatingType value ").append(ratingType).append(". The valid range is from 0 to ").append(6).toString());
        }
        this.ratingType = ratingType;
    }

    @Implementation
    protected int getRatingType() {
        return this.ratingType;
    }

    @Implementation
    protected void registerCallback(MediaController.Callback callback) {
        this.callbacks.add(callback);
        ((MediaController)Shadow.directlyOn((Object)this.realMediaController, MediaController.class)).registerCallback(callback);
    }

    @Implementation
    protected void unregisterCallback(MediaController.Callback callback) {
        this.callbacks.remove(callback);
        ((MediaController)Shadow.directlyOn((Object)this.realMediaController, MediaController.class)).unregisterCallback(callback);
    }

    public List<MediaController.Callback> getCallbacks() {
        return this.callbacks;
    }

    public void executeOnPlaybackStateChanged(PlaybackState playbackState) {
        this.setPlaybackState(playbackState);
        int messageId = (Integer)ReflectionHelpers.getStaticField(MediaController.class, (String)"MSG_UPDATE_PLAYBACK_STATE");
        ReflectionHelpers.callInstanceMethod(MediaController.class, (Object)this.realMediaController, (String)"postMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)messageId), ReflectionHelpers.ClassParameter.from(Object.class, (Object)playbackState), ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)new Bundle())});
    }

    public void executeOnMetadataChanged(MediaMetadata metadata) {
        this.setMetadata(metadata);
        int messageId = (Integer)ReflectionHelpers.getStaticField(MediaController.class, (String)"MSG_UPDATE_METADATA");
        ReflectionHelpers.callInstanceMethod(MediaController.class, (Object)this.realMediaController, (String)"postMessage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)messageId), ReflectionHelpers.ClassParameter.from(Object.class, (Object)metadata), ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)new Bundle())});
    }
}

