/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.widget.PopupMenu;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;

@Implements(value=PopupMenu.class)
public class ShadowPopupMenu {
    @RealObject
    private PopupMenu realPopupMenu;
    private boolean isShowing;
    private PopupMenu.OnMenuItemClickListener onMenuItemClickListener;

    @Implementation
    protected void show() {
        this.isShowing = true;
        ShadowPopupMenu.setLatestPopupMenu(this);
        ((PopupMenu)Shadow.directlyOn((Object)this.realPopupMenu, PopupMenu.class)).show();
    }

    @Implementation
    protected void dismiss() {
        this.isShowing = false;
        ((PopupMenu)Shadow.directlyOn((Object)this.realPopupMenu, PopupMenu.class)).dismiss();
    }

    @Implementation
    protected void setOnMenuItemClickListener(PopupMenu.OnMenuItemClickListener listener) {
        this.onMenuItemClickListener = listener;
        ((PopupMenu)Shadow.directlyOn((Object)this.realPopupMenu, PopupMenu.class)).setOnMenuItemClickListener(listener);
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public static PopupMenu getLatestPopupMenu() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        ShadowPopupMenu popupMenu = shadowApplication.getLatestPopupMenu();
        return popupMenu == null ? null : popupMenu.realPopupMenu;
    }

    public static void setLatestPopupMenu(ShadowPopupMenu latestPopupMenu) {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        if (shadowApplication != null) {
            shadowApplication.setLatestPopupMenu(latestPopupMenu);
        }
    }

    public PopupMenu.OnMenuItemClickListener getOnMenuItemClickListener() {
        return this.onMenuItemClickListener;
    }
}

