/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.speech.IRecognitionService;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import java.util.Queue;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=SpeechRecognizer.class)
public class ShadowSpeechRecognizer {
    @RealObject
    SpeechRecognizer realSpeechRecognizer;
    private static SpeechRecognizer latestSpeechRecognizer;
    private RecognitionListener recognitionListener;

    public static SpeechRecognizer getLatestSpeechRecognizer() {
        return latestSpeechRecognizer;
    }

    @Resetter
    public static void reset() {
        latestSpeechRecognizer = null;
    }

    @Implementation
    protected static SpeechRecognizer createSpeechRecognizer(Context context, ComponentName serviceComponent) {
        SpeechRecognizer result;
        latestSpeechRecognizer = result = (SpeechRecognizer)Shadow.directlyOn(SpeechRecognizer.class, (String)"createSpeechRecognizer", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(ComponentName.class, (Object)serviceComponent)});
        return result;
    }

    @Implementation
    protected void startListening(Intent recognizerIntent) {
        Handler mainHandler = new Handler(Looper.getMainLooper());
        mainHandler.post(() -> {
            SpeechRecognizerReflector recognizerReflector = (SpeechRecognizerReflector)Reflector.reflector(SpeechRecognizerReflector.class, (Object)this.realSpeechRecognizer);
            recognizerReflector.setService((IRecognitionService)ReflectionHelpers.createNullProxy(IRecognitionService.class));
            Queue<Message> pendingTasks = recognizerReflector.getPendingTasks();
            while (!pendingTasks.isEmpty()) {
                recognizerReflector.getHandler().sendMessage(pendingTasks.poll());
            }
        });
    }

    @Implementation
    protected void handleChangeListener(RecognitionListener listener) {
        this.recognitionListener = listener;
    }

    public void triggerOnEndOfSpeech() {
        this.recognitionListener.onEndOfSpeech();
    }

    public void triggerOnError(int error) {
        this.recognitionListener.onError(error);
    }

    public void triggerOnPartialResults(Bundle bundle) {
        this.recognitionListener.onPartialResults(bundle);
    }

    public void triggerOnResults(Bundle bundle) {
        this.recognitionListener.onResults(bundle);
    }

    public void triggerOnRmsChanged(float rmsdB) {
        this.recognitionListener.onRmsChanged(rmsdB);
    }

    @ForType(value=SpeechRecognizer.class)
    static interface SpeechRecognizerReflector {
        @Accessor(value="mService")
        public void setService(IRecognitionService var1);

        @Accessor(value="mPendingTasks")
        public Queue<Message> getPendingTasks();

        @Accessor(value="mHandler")
        public Handler getHandler();
    }
}

