/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.usage.StorageStats;
import android.app.usage.StorageStatsManager;
import android.content.pm.PackageManager;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.AutoValue_ShadowStorageStatsManager_FreeAndTotalBytesPair;
import org.robolectric.shadows.AutoValue_ShadowStorageStatsManager_StorageStatsKey;

@Implements(value=StorageStatsManager.class, minSdk=26)
public class ShadowStorageStatsManager {
    public static final long DEFAULT_STORAGE_FREE_BYTES = 0x100000000L;
    public static final long DEFAULT_STORAGE_TOTAL_BYTES = 0x200000000L;
    private final Map<UUID, FreeAndTotalBytesPair> freeAndTotalBytesMap = ShadowStorageStatsManager.createFreeAndTotalBytesMapWithSingleEntry(StorageManager.UUID_DEFAULT, 0x100000000L, 0x200000000L);
    private final Map<StorageStatsKey, StorageStats> storageStatsMap = new ConcurrentHashMap<StorageStatsKey, StorageStats>();

    public void setStorageDeviceFreeAndTotalBytes(UUID storageUuid, long freeBytes, long totalBytes) {
        Preconditions.checkArgument((freeBytes >= 0L && totalBytes >= 0L ? 1 : 0) != 0, (Object)"Both freeBytes and totalBytes must be non-negative!");
        this.freeAndTotalBytesMap.put(storageUuid, FreeAndTotalBytesPair.create(freeBytes, totalBytes));
    }

    public void removeStorageDevice(UUID storageUuid) {
        this.freeAndTotalBytesMap.remove(storageUuid);
    }

    public void addStorageStats(UUID storageUuid, String packageName, UserHandle userHandle, StorageStats storageStatsToReturn) {
        this.storageStatsMap.put(StorageStatsKey.create(storageUuid, packageName, userHandle), storageStatsToReturn);
    }

    public void clearStorageStats() {
        this.storageStatsMap.clear();
    }

    @Implementation
    protected long getFreeBytes(UUID storageUuid) throws IOException {
        FreeAndTotalBytesPair freeAndTotalBytesPair = this.freeAndTotalBytesMap.get(storageUuid);
        if (freeAndTotalBytesPair == null) {
            throw new IOException("getFreeBytes with non-existent storageUuid! Did you forget to call setStorageDeviceFreeAndTotalBytes?");
        }
        return freeAndTotalBytesPair.freeBytes();
    }

    @Implementation
    protected long getTotalBytes(UUID storageUuid) throws IOException {
        FreeAndTotalBytesPair freeAndTotalBytesPair = this.freeAndTotalBytesMap.get(storageUuid);
        if (freeAndTotalBytesPair == null) {
            throw new IOException("getTotalBytes with non-existent storageUuid! Did you forget to call setStorageDeviceFreeAndTotalBytes?");
        }
        return freeAndTotalBytesPair.totalBytes();
    }

    @Implementation
    protected StorageStats queryStatsForPackage(UUID storageUuid, String packageName, UserHandle user) throws PackageManager.NameNotFoundException, IOException {
        StorageStats storageStat = this.storageStatsMap.get(StorageStatsKey.create(storageUuid, packageName, user));
        if (storageStat == null) {
            throw new PackageManager.NameNotFoundException("queryStatsForPackage with non matching arguments. Did you forget to call addStorageStats?");
        }
        return storageStat;
    }

    private static Map<UUID, FreeAndTotalBytesPair> createFreeAndTotalBytesMapWithSingleEntry(UUID storageUuid, long freeBytes, long totalBytes) {
        ConcurrentHashMap<UUID, FreeAndTotalBytesPair> currMap = new ConcurrentHashMap<UUID, FreeAndTotalBytesPair>();
        currMap.put(storageUuid, FreeAndTotalBytesPair.create(freeBytes, totalBytes));
        return currMap;
    }

    @AutoValue
    static abstract class StorageStatsKey {
        StorageStatsKey() {
        }

        abstract UUID storageUuid();

        abstract String packageName();

        abstract UserHandle userHandle();

        static StorageStatsKey create(UUID storageUuid, String packageName, UserHandle userHandle) {
            return new AutoValue_ShadowStorageStatsManager_StorageStatsKey(storageUuid, packageName, userHandle);
        }
    }

    @AutoValue
    static abstract class FreeAndTotalBytesPair {
        FreeAndTotalBytesPair() {
        }

        abstract long freeBytes();

        abstract long totalBytes();

        static FreeAndTotalBytesPair create(long freeBytes, long totalBytes) {
            return new AutoValue_ShadowStorageStatsManager_FreeAndTotalBytesPair(freeBytes, totalBytes);
        }
    }
}

