/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.UiModeManager;
import com.google.common.collect.ImmutableSet;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UiModeManager.class)
public class ShadowUIModeManager {
    public int currentModeType = 0;
    public int currentNightMode = 0;
    public int lastFlags;
    public int lastCarModePriority;
    private static final ImmutableSet<Integer> VALID_NIGHT_MODES = ImmutableSet.of((Object)0, (Object)1, (Object)2);
    private static final int DEFAULT_PRIORITY = 0;

    @Implementation
    protected int getCurrentModeType() {
        return this.currentModeType;
    }

    @Implementation(maxSdk=29)
    protected void enableCarMode(int flags) {
        this.enableCarMode(0, flags);
    }

    @Implementation(minSdk=30)
    protected void enableCarMode(int priority, int flags) {
        this.currentModeType = 3;
        this.lastCarModePriority = priority;
        this.lastFlags = flags;
    }

    @Implementation
    protected void disableCarMode(int flags) {
        this.currentModeType = 1;
        this.lastFlags = flags;
    }

    @Implementation
    protected int getNightMode() {
        return this.currentNightMode;
    }

    @Implementation
    protected void setNightMode(int mode) {
        this.currentNightMode = VALID_NIGHT_MODES.contains((Object)mode) ? mode : 0;
    }
}

