/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.webkit.WebViewDatabase;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=WebViewDatabase.class, callThroughByDefault=false)
public class ShadowWebViewDatabase {
    private static RoboWebViewDatabase webViewDatabase;

    @Implementation
    protected static WebViewDatabase getInstance(Context ignored) {
        if (webViewDatabase == null) {
            webViewDatabase = new RoboWebViewDatabase();
        }
        return webViewDatabase;
    }

    public void resetDatabase() {
        webViewDatabase = null;
    }

    public boolean wasClearFormDataCalled() {
        return ShadowWebViewDatabase.webViewDatabase.wasClearFormDataCalled();
    }

    public void resetClearFormData() {
        ShadowWebViewDatabase.webViewDatabase.resetClearFormData();
    }

    private static final class RoboWebViewDatabase
    extends WebViewDatabase {
        private boolean wasClearFormDataCalled = false;

        RoboWebViewDatabase() {
        }

        public boolean hasUsernamePassword() {
            return false;
        }

        public void clearUsernamePassword() {
        }

        public boolean hasHttpAuthUsernamePassword() {
            return false;
        }

        public void clearHttpAuthUsernamePassword() {
        }

        public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        }

        @Nullable
        public String[] getHttpAuthUsernamePassword(String host, String realm) {
            return null;
        }

        public boolean hasFormData() {
            return false;
        }

        public void clearFormData() {
            this.wasClearFormDataCalled = true;
        }

        private boolean wasClearFormDataCalled() {
            return this.wasClearFormDataCalled;
        }

        private void resetClearFormData() {
            this.wasClearFormDataCalled = false;
        }
    }
}

