/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.FrameMetrics;
import android.view.Window;
import android.widget.ProgressBar;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Window.class)
public class ShadowWindow {
    @RealObject
    private Window realWindow;
    protected CharSequence title = "";
    protected Drawable backgroundDrawable;
    private int flags;
    private int softInputMode;
    private final Set<Window.OnFrameMetricsAvailableListener> onFrameMetricsAvailableListeners = new HashSet<Window.OnFrameMetricsAvailableListener>();

    public static Window create(Context context) throws ClassNotFoundException {
        String className = RuntimeEnvironment.getApiLevel() >= 23 ? "com.android.internal.policy.PhoneWindow" : "com.android.internal.policy.impl.PhoneWindow";
        Class<?> phoneWindowClass = Window.class.getClassLoader().loadClass(className);
        return (Window)ReflectionHelpers.callConstructor(phoneWindowClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context)});
    }

    @Implementation
    protected void setFlags(int flags, int mask) {
        this.flags = this.flags & ~mask | flags & mask;
        Shadow.directlyOn((Object)this.realWindow, Window.class, (String)"setFlags", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)mask)});
    }

    @Implementation
    protected void setSoftInputMode(int softInputMode) {
        this.softInputMode = softInputMode;
        Shadow.directlyOn((Object)this.realWindow, Window.class, (String)"setSoftInputMode", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)softInputMode)});
    }

    public boolean getFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public CharSequence getTitle() {
        return this.title;
    }

    public int getSoftInputMode() {
        return this.softInputMode;
    }

    public Drawable getBackgroundDrawable() {
        return this.backgroundDrawable;
    }

    public ProgressBar getProgressBar() {
        return (ProgressBar)Shadow.directlyOn((Object)this.realWindow, (String)this.realWindow.getClass().getName(), (String)"getHorizontalProgressBar", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)});
    }

    public ProgressBar getIndeterminateProgressBar() {
        return (ProgressBar)Shadow.directlyOn((Object)this.realWindow, (String)this.realWindow.getClass().getName(), (String)"getCircularProgressBar", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)false)});
    }

    @Implementation(minSdk=24)
    protected void addOnFrameMetricsAvailableListener(Window.OnFrameMetricsAvailableListener listener, Handler handler) {
        this.onFrameMetricsAvailableListeners.add(listener);
    }

    @Implementation(minSdk=24)
    protected void removeOnFrameMetricsAvailableListener(Window.OnFrameMetricsAvailableListener listener) {
        if (!this.onFrameMetricsAvailableListeners.remove(listener)) {
            throw new IllegalArgumentException("attempt to remove OnFrameMetricsAvailableListener that was never added");
        }
    }

    public void reportOnFrameMetricsAvailable(FrameMetrics frameMetrics) {
        this.reportOnFrameMetricsAvailable(frameMetrics, 0);
    }

    public void reportOnFrameMetricsAvailable(FrameMetrics frameMetrics, int dropCountSinceLastInvocation) {
        for (Window.OnFrameMetricsAvailableListener listener : this.onFrameMetricsAvailableListeners) {
            listener.onFrameMetricsAvailable(this.realWindow, frameMetrics, dropCountSinceLastInvocation);
        }
    }
}

