/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

public class RoboCookieManager
extends CookieManager {
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String EXPIRATION_FIELD_NAME = "Expires";
    private static final String SECURE_ATTR_NAME = "SECURE";
    private final List<Cookie> store = new ArrayList<Cookie>();
    private boolean accept;

    public void setCookie(String url, String value) {
        Cookie cookie = RoboCookieManager.parseCookie(url, value);
        if (cookie != null) {
            this.store.add(cookie);
        }
    }

    public void setCookie(String url, String value, ValueCallback<Boolean> valueCallback) {
        this.setCookie(url, value);
        valueCallback.onReceiveValue((Object)true);
    }

    public void setAcceptThirdPartyCookies(WebView webView, boolean b) {
    }

    public boolean acceptThirdPartyCookies(WebView webView) {
        return false;
    }

    public void removeAllCookies(ValueCallback<Boolean> valueCallback) {
        this.store.clear();
        if (valueCallback != null) {
            valueCallback.onReceiveValue((Object)Boolean.TRUE);
        }
    }

    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionCookies(ValueCallback<Boolean> valueCallback) {
        boolean value;
        List<Cookie> list = this.store;
        synchronized (list) {
            value = this.clearAndAddPersistentCookies();
        }
        valueCallback.onReceiveValue((Object)value);
    }

    public String getCookie(String url) {
        if (url == null || url.equals("")) {
            return null;
        }
        try {
            url = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        List<Cookie> matchedCookies = url.startsWith(".") ? this.filter(url.substring(1)) : (url.contains("//.") ? this.filter(url.substring(url.indexOf("//.") + 3)) : this.filter(RoboCookieManager.getCookieHost(url), url.startsWith(HTTPS)));
        if (matchedCookies.isEmpty()) {
            return null;
        }
        StringBuilder cookieHeaderValue = new StringBuilder();
        int n = matchedCookies.size();
        for (int i = 0; i < n; ++i) {
            Cookie cookie = matchedCookies.get(i);
            if (i > 0) {
                cookieHeaderValue.append("; ");
            }
            cookieHeaderValue.append(cookie.getName());
            String value = cookie.getValue();
            if (value == null) continue;
            cookieHeaderValue.append("=");
            cookieHeaderValue.append(value);
        }
        return cookieHeaderValue.toString();
    }

    public String getCookie(String s, boolean b) {
        return null;
    }

    private List<Cookie> filter(String domain) {
        return this.filter(domain, false);
    }

    private List<Cookie> filter(String domain, boolean isSecure) {
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        for (Cookie cookie : this.store) {
            if (!cookie.isSameHost(domain) || isSecure != cookie.isSecure() && !isSecure) continue;
            matchedCookies.add(cookie);
        }
        return matchedCookies;
    }

    public void setAcceptCookie(boolean accept) {
        this.accept = accept;
    }

    public boolean acceptCookie() {
        return this.accept;
    }

    public void removeAllCookie() {
        this.store.clear();
    }

    public void removeExpiredCookie() {
        ArrayList<Cookie> expired = new ArrayList<Cookie>();
        Date now = new Date();
        for (Cookie cookie : this.store) {
            if (!cookie.isExpiredAt(now)) continue;
            expired.add(cookie);
        }
        this.store.removeAll(expired);
    }

    public boolean hasCookies() {
        return !this.store.isEmpty();
    }

    public boolean hasCookies(boolean b) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionCookie() {
        List<Cookie> list = this.store;
        synchronized (list) {
            this.clearAndAddPersistentCookies();
        }
    }

    protected boolean allowFileSchemeCookiesImpl() {
        return false;
    }

    protected void setAcceptFileSchemeCookiesImpl(boolean b) {
    }

    private boolean clearAndAddPersistentCookies() {
        ArrayList<Cookie> existing = new ArrayList<Cookie>(this.store);
        int length = this.store.size();
        this.store.clear();
        for (Cookie cookie : existing) {
            if (!cookie.isPersistent()) continue;
            this.store.add(cookie);
        }
        return this.store.size() < length;
    }

    @Nullable
    private static Cookie parseCookie(String url, String cookieHeader) {
        Date expiration = null;
        boolean isSecure = false;
        String[] fields = cookieHeader.split(";", 0);
        String cookieValue = fields[0].trim();
        for (int i = 1; i < fields.length; ++i) {
            String field = fields[i].trim();
            if (field.startsWith(EXPIRATION_FIELD_NAME)) {
                expiration = RoboCookieManager.getExpiration(field);
                continue;
            }
            if (!field.toUpperCase().equals(SECURE_ATTR_NAME)) continue;
            isSecure = true;
        }
        String hostname = RoboCookieManager.getCookieHost(url);
        if (expiration == null || expiration.compareTo(new Date()) >= 0) {
            return new Cookie(hostname, isSecure, cookieValue, expiration);
        }
        return null;
    }

    private static String getCookieHost(String url) {
        if (!url.startsWith(HTTP) && !url.startsWith(HTTPS)) {
            String string = String.valueOf(HTTP);
            String string2 = String.valueOf(url);
            url = string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        try {
            return new URI(url).getHost();
        }
        catch (URISyntaxException e) {
            String string = String.valueOf(url);
            throw new IllegalArgumentException(string.length() != 0 ? "wrong URL : ".concat(string) : new String("wrong URL : "), e);
        }
    }

    private static Date getExpiration(String field) {
        int equalsIndex = field.indexOf("=");
        if (equalsIndex < 0) {
            return null;
        }
        String date = field.substring(equalsIndex + 1);
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
            return dateFormat.parse(date);
        }
        catch (ParseException dateFormat) {
            try {
                SimpleDateFormat dateFormat2 = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss zzz");
                return dateFormat2.parse(date);
            }
            catch (ParseException e) {
                return null;
            }
        }
    }

    private static class Cookie {
        private final String mName;
        private final String mValue;
        private final Date mExpiration;
        private final String mHostname;
        private final boolean mIsSecure;

        public Cookie(String hostname, boolean isSecure, String cookie, Date expiration) {
            this.mHostname = hostname;
            this.mIsSecure = isSecure;
            this.mExpiration = expiration;
            int equalsIndex = cookie.indexOf("=");
            if (equalsIndex >= 0) {
                this.mName = cookie.substring(0, equalsIndex);
                this.mValue = cookie.substring(equalsIndex + 1);
            } else {
                this.mName = cookie;
                this.mValue = null;
            }
        }

        public String getName() {
            return this.mName;
        }

        public String getValue() {
            return this.mValue;
        }

        public boolean isExpiredAt(Date date) {
            return this.mExpiration != null && this.mExpiration.compareTo(date) < 0;
        }

        public boolean isPersistent() {
            return this.mExpiration != null;
        }

        public boolean isSameHost(String host) {
            return this.mHostname.endsWith(host);
        }

        public boolean isSecure() {
            return this.mIsSecure;
        }
    }
}

