/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.UserHandle;
import android.os.storage.StorageVolume;
import java.io.File;
import java.util.UUID;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.util.ReflectionHelpers;

public final class StorageVolumeBuilder {
    private final String id;
    private int storageId = 0;
    private final File path;
    private File internalPath;
    private final String description;
    private boolean primary = true;
    private boolean removable = false;
    private boolean emulated = false;
    private long mtpReserveSize = 0L;
    private boolean allowMassStorage = false;
    private long maxFileSize = 100L;
    private final UserHandle owner;
    private String fsUuid = UUID.randomUUID().toString();
    private final UUID uuid = UUID.randomUUID();
    private final String state;

    public StorageVolumeBuilder(String id2, File path, String description, UserHandle owner, String state) {
        this.id = id2;
        this.path = path;
        this.internalPath = path;
        this.description = description;
        this.owner = owner;
        this.state = state;
    }

    public StorageVolumeBuilder setStorageId(int storageId) {
        this.storageId = storageId;
        return this;
    }

    public StorageVolumeBuilder setIsPrimary(boolean isPrimary) {
        this.primary = isPrimary;
        return this;
    }

    public StorageVolumeBuilder setIsRemovable(boolean isRemovable) {
        this.removable = isRemovable;
        return this;
    }

    public StorageVolumeBuilder setIsEmulated(boolean isEmulated) {
        this.emulated = isEmulated;
        return this;
    }

    public StorageVolumeBuilder setMtpReserveSize(long mtpReserveSize) {
        this.mtpReserveSize = mtpReserveSize;
        return this;
    }

    public StorageVolumeBuilder setAllowMassStorage(boolean allowMassStorage) {
        this.allowMassStorage = allowMassStorage;
        return this;
    }

    public StorageVolumeBuilder setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
        return this;
    }

    public StorageVolumeBuilder setFsUuid(String fsUuid) {
        this.fsUuid = fsUuid;
        return this;
    }

    public StorageVolumeBuilder setInternalPath(File internalPath) {
        this.internalPath = internalPath;
        return this;
    }

    public StorageVolume build() throws IllegalStateException {
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel >= 24 && apiLevel < 28) {
            return (StorageVolume)ReflectionHelpers.callConstructor(StorageVolume.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.id), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)this.storageId), ReflectionHelpers.ClassParameter.from(File.class, (Object)this.path), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.description), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.primary), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.removable), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.emulated), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.mtpReserveSize), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.allowMassStorage), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.maxFileSize), ReflectionHelpers.ClassParameter.from(UserHandle.class, (Object)this.owner), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.fsUuid), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.state)});
        }
        if (apiLevel >= 28 && apiLevel <= 30) {
            return (StorageVolume)ReflectionHelpers.callConstructor(StorageVolume.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.id), ReflectionHelpers.ClassParameter.from(File.class, (Object)this.path), ReflectionHelpers.ClassParameter.from(File.class, (Object)this.internalPath), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.description), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.primary), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.removable), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.emulated), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.allowMassStorage), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.maxFileSize), ReflectionHelpers.ClassParameter.from(UserHandle.class, (Object)this.owner), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.fsUuid), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.state)});
        }
        if (apiLevel > 30) {
            return (StorageVolume)ReflectionHelpers.callConstructor(StorageVolume.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)this.id), ReflectionHelpers.ClassParameter.from(File.class, (Object)this.path), ReflectionHelpers.ClassParameter.from(File.class, (Object)this.internalPath), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.description), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.primary), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.removable), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.emulated), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)this.allowMassStorage), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)this.maxFileSize), ReflectionHelpers.ClassParameter.from(UserHandle.class, (Object)this.owner), ReflectionHelpers.ClassParameter.from(UUID.class, (Object)this.uuid), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.fsUuid), ReflectionHelpers.ClassParameter.from(String.class, (Object)this.state)});
        }
        throw new IllegalStateException("StorageVolume hidden constructor not found");
    }
}

