/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.SystemClock;
import java.time.DateTimeException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowSystemClock;

@Implements(value=SystemClock.class, isInAndroidSdk=false, shadowPicker=ShadowSystemClock.Picker.class)
public class ShadowPausedSystemClock
extends ShadowSystemClock {
    private static final long INITIAL_TIME = 100L;
    private static final int MILLIS_PER_NANO = 1000000;
    private static long currentTimeMillis = 100L;
    private static List<Listener> listeners = new CopyOnWriteArrayList<Listener>();

    static void addListener(Listener listener) {
        listeners.add(listener);
    }

    static void removeListener(Listener listener) {
        listeners.remove(listener);
    }

    @Implementation
    protected static void sleep(long millis) {
        currentTimeMillis += millis;
    }

    @Implementation
    protected static boolean setCurrentTimeMillis(long millis) {
        if (currentTimeMillis > millis) {
            return false;
        }
        if (currentTimeMillis != millis) {
            currentTimeMillis = millis;
            for (Listener listener : listeners) {
                listener.clockUpdated(currentTimeMillis);
            }
        }
        return true;
    }

    @Implementation
    protected static long uptimeMillis() {
        return currentTimeMillis;
    }

    @Implementation
    protected static long elapsedRealtime() {
        return ShadowPausedSystemClock.uptimeMillis();
    }

    @Implementation(minSdk=17)
    protected static long elapsedRealtimeNanos() {
        return ShadowPausedSystemClock.elapsedRealtime() * 1000000L;
    }

    @Implementation
    protected static long currentThreadTimeMillis() {
        return ShadowPausedSystemClock.uptimeMillis();
    }

    @HiddenApi
    @Implementation
    protected static long currentThreadTimeMicro() {
        return ShadowPausedSystemClock.uptimeMillis() * 1000L;
    }

    @HiddenApi
    @Implementation
    protected static long currentTimeMicro() {
        return ShadowPausedSystemClock.currentThreadTimeMicro();
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected static long currentNetworkTimeMillis() {
        if (networkTimeAvailable) {
            return currentTimeMillis;
        }
        throw new DateTimeException("Network time not available");
    }

    @Resetter
    public static void reset() {
        currentTimeMillis = 100L;
        ShadowSystemClock.reset();
        listeners.clear();
    }

    static interface Listener {
        public void clockUpdated(long var1);
    }
}

