/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Application;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.ParcelUuid;
import android.provider.Settings;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowBluetoothServerSocket;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=BluetoothAdapter.class, looseSignatures=true)
public class ShadowBluetoothAdapter {
    @RealObject
    private BluetoothAdapter realAdapter;
    private static final int ADDRESS_LENGTH = 17;
    private static final int LE_MAXIMUM_ADVERTISING_DATA_LENGTH = 31;
    private static final int LE_MAXIMUM_ADVERTISING_DATA_LENGTH_EXTENDED = 1650;
    private static boolean isBluetoothSupported = true;
    private static final Map<String, BluetoothDevice> deviceCache = new HashMap<String, BluetoothDevice>();
    private Set<BluetoothDevice> bondedDevices = new HashSet<BluetoothDevice>();
    private Set<BluetoothAdapter.LeScanCallback> leScanCallbacks = new HashSet<BluetoothAdapter.LeScanCallback>();
    private boolean isDiscovering;
    private String address;
    private int state;
    private String name = "DefaultBluetoothDeviceName";
    private int scanMode = 20;
    private int discoverableTimeout = 0;
    private boolean isBleScanAlwaysAvailable = true;
    private boolean isMultipleAdvertisementSupported = true;
    private boolean isLeExtendedAdvertisingSupported = true;
    private boolean isOverridingProxyBehavior;
    private final Map<Integer, Integer> profileConnectionStateData = new HashMap<Integer, Integer>();
    private final Map<Integer, BluetoothProfile> profileProxies = new HashMap<Integer, BluetoothProfile>();

    @Resetter
    public static void reset() {
        ShadowBluetoothAdapter.setIsBluetoothSupported(true);
        BluetoothAdapterReflector bluetoothReflector = (BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class);
        int apiLevel = RuntimeEnvironment.getApiLevel();
        if (apiLevel >= 21 && apiLevel <= 30) {
            bluetoothReflector.setSBluetoothLeAdvertiser(null);
            bluetoothReflector.setSBluetoothLeScanner(null);
        }
        bluetoothReflector.setAdapter(null);
        deviceCache.clear();
    }

    @Implementation
    protected static BluetoothAdapter getDefaultAdapter() {
        if (!isBluetoothSupported) {
            return null;
        }
        return ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class)).getDefaultAdapter();
    }

    public static void setIsBluetoothSupported(boolean supported) {
        isBluetoothSupported = supported;
    }

    @Deprecated
    public void setBluetoothLeAdvertiser(BluetoothLeAdvertiser advertiser) {
        if (RuntimeEnvironment.getApiLevel() <= 22) {
            ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).setSBluetoothLeAdvertiser(advertiser);
        } else {
            ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).setBluetoothLeAdvertiser(advertiser);
        }
    }

    @Implementation
    protected synchronized BluetoothDevice getRemoteDevice(String address) {
        if (!deviceCache.containsKey(address)) {
            deviceCache.put(address, ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).getRemoteDevice(address));
        }
        return deviceCache.get(address);
    }

    @Implementation
    protected Set<BluetoothDevice> getBondedDevices() {
        return Collections.unmodifiableSet(this.bondedDevices);
    }

    public void setBondedDevices(Set<BluetoothDevice> bluetoothDevices) {
        this.bondedDevices = bluetoothDevices;
    }

    @Implementation
    protected BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String serviceName, UUID uuid) {
        return ShadowBluetoothServerSocket.newInstance(1, false, false, new ParcelUuid(uuid));
    }

    @Implementation
    protected BluetoothServerSocket listenUsingRfcommWithServiceRecord(String serviceName, UUID uuid) throws IOException {
        return ShadowBluetoothServerSocket.newInstance(1, false, true, new ParcelUuid(uuid));
    }

    @Implementation
    protected boolean startDiscovery() {
        this.isDiscovering = true;
        return true;
    }

    @Implementation
    protected boolean cancelDiscovery() {
        this.isDiscovering = false;
        return true;
    }

    @Implementation(minSdk=23)
    protected boolean isBleScanAlwaysAvailable() {
        return this.isBleScanAlwaysAvailable;
    }

    @Implementation(minSdk=23)
    public int getLeState() {
        if (ShadowBluetoothAdapter.isAirplaneMode()) {
            return 10;
        }
        if (this.isEnabled()) {
            return 12;
        }
        if (this.isBleScanAlwaysAvailable()) {
            return 15;
        }
        return 10;
    }

    private static boolean isAirplaneMode() {
        Application context = RuntimeEnvironment.getApplication();
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) != 0;
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(BluetoothAdapter.LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    @Implementation(minSdk=18)
    protected boolean startLeScan(UUID[] serviceUuids, BluetoothAdapter.LeScanCallback callback) {
        if (Build.VERSION.SDK_INT >= 23 && !this.realAdapter.isLeEnabled()) {
            return false;
        }
        this.leScanCallbacks.add(callback);
        return true;
    }

    @Implementation(minSdk=18)
    protected void stopLeScan(BluetoothAdapter.LeScanCallback callback) {
        this.leScanCallbacks.remove(callback);
    }

    public Set<BluetoothAdapter.LeScanCallback> getLeScanCallbacks() {
        return Collections.unmodifiableSet(this.leScanCallbacks);
    }

    public BluetoothAdapter.LeScanCallback getSingleLeScanCallback() {
        if (this.leScanCallbacks.size() != 1) {
            throw new IllegalStateException("There are " + this.leScanCallbacks.size() + " callbacks");
        }
        return this.leScanCallbacks.iterator().next();
    }

    @Implementation
    protected boolean isDiscovering() {
        return this.isDiscovering;
    }

    @Implementation
    protected boolean isEnabled() {
        return this.state == 12;
    }

    @Implementation
    protected boolean enable() {
        this.setState(12);
        return true;
    }

    @Implementation
    protected boolean disable() {
        this.setState(10);
        return true;
    }

    @Implementation
    protected String getAddress() {
        return this.address;
    }

    @Implementation
    protected int getState() {
        return this.state;
    }

    @Implementation
    protected String getName() {
        return this.name;
    }

    @Implementation
    protected boolean setName(String name) {
        this.name = name;
        return true;
    }

    @Implementation
    protected Object setScanMode(int scanMode) {
        if (scanMode != 21 && scanMode != 23 && scanMode != 20) {
            return false;
        }
        this.scanMode = scanMode;
        return true;
    }

    @Implementation(maxSdk=29)
    protected boolean setScanMode(int scanMode, int discoverableTimeout) {
        this.setDiscoverableTimeout(discoverableTimeout);
        return (Boolean)this.setScanMode(scanMode);
    }

    @Implementation(minSdk=30)
    protected boolean setScanMode(int scanMode, long durationMillis) {
        int durationSeconds = Math.toIntExact(durationMillis / 1000L);
        this.setDiscoverableTimeout(durationSeconds);
        return (Boolean)this.setScanMode(scanMode);
    }

    @Implementation
    protected int getScanMode() {
        return this.scanMode;
    }

    @Implementation
    protected int getDiscoverableTimeout() {
        return this.discoverableTimeout;
    }

    @Implementation
    protected void setDiscoverableTimeout(int timeout) {
        this.discoverableTimeout = timeout;
    }

    @Implementation(minSdk=21)
    protected boolean isMultipleAdvertisementSupported() {
        return this.isMultipleAdvertisementSupported;
    }

    @Implementation
    protected static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    @Implementation
    protected int getProfileConnectionState(int profile) {
        Integer state = this.profileConnectionStateData.get(profile);
        if (state == null) {
            return 0;
        }
        return state;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setState(int state) {
        this.state = state;
    }

    @Deprecated
    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public void setBleScanAlwaysAvailable(boolean alwaysAvailable) {
        this.isBleScanAlwaysAvailable = alwaysAvailable;
    }

    public void setIsMultipleAdvertisementSupported(boolean supported) {
        this.isMultipleAdvertisementSupported = supported;
    }

    public void setProfileConnectionState(int profile, int state) {
        this.profileConnectionStateData.put(profile, state);
    }

    public void setProfileProxy(int profile, @Nullable BluetoothProfile proxy) {
        this.isOverridingProxyBehavior = true;
        if (proxy != null) {
            this.profileProxies.put(profile, proxy);
        }
    }

    public boolean hasActiveProfileProxy(int profile) {
        return this.profileProxies.get(profile) != null;
    }

    @Implementation
    protected boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (!this.isOverridingProxyBehavior) {
            return ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).getProfileProxy(context, listener, profile);
        }
        BluetoothProfile proxy = this.profileProxies.get(profile);
        if (proxy == null) {
            return false;
        }
        listener.onServiceConnected(profile, proxy);
        return true;
    }

    @Implementation
    protected void closeProfileProxy(int profile, BluetoothProfile proxy) {
        if (!this.isOverridingProxyBehavior) {
            ((BluetoothAdapterReflector)Reflector.reflector(BluetoothAdapterReflector.class, (Object)this.realAdapter)).closeProfileProxy(profile, proxy);
            return;
        }
        if (proxy != null && proxy.equals(this.profileProxies.get(profile))) {
            this.profileProxies.remove(profile);
        }
    }

    @Implementation(minSdk=26)
    protected boolean isLeExtendedAdvertisingSupported() {
        return this.isLeExtendedAdvertisingSupported;
    }

    public void setIsLeExtendedAdvertisingSupported(boolean supported) {
        this.isLeExtendedAdvertisingSupported = supported;
    }

    @Implementation(minSdk=26)
    protected int getLeMaximumAdvertisingDataLength() {
        return this.isLeExtendedAdvertisingSupported ? 1650 : 31;
    }

    @ForType(value=BluetoothAdapter.class)
    static interface BluetoothAdapterReflector {
        @Static
        @Direct
        public BluetoothAdapter getDefaultAdapter();

        @Direct
        public boolean getProfileProxy(Context var1, BluetoothProfile.ServiceListener var2, int var3);

        @Direct
        public void closeProfileProxy(int var1, BluetoothProfile var2);

        @Direct
        public BluetoothDevice getRemoteDevice(String var1);

        @Accessor(value="sAdapter")
        @Static
        public void setAdapter(BluetoothAdapter var1);

        @Accessor(value="mBluetoothLeAdvertiser")
        @Deprecated
        public void setBluetoothLeAdvertiser(BluetoothLeAdvertiser var1);

        @Accessor(value="sBluetoothLeAdvertiser")
        @Static
        public void setSBluetoothLeAdvertiser(BluetoothLeAdvertiser var1);

        @Accessor(value="sBluetoothLeScanner")
        @Static
        public void setSBluetoothLeScanner(BluetoothLeScanner var1);
    }
}

