/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.CrossProfileApps;
import android.content.pm.ICrossProfileApps;
import android.content.pm.PackageManager;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CrossProfileApps.class, minSdk=28)
public class ShadowCrossProfileApps {
    private final Set<UserHandle> targetUserProfiles = new LinkedHashSet<UserHandle>();
    private final List<StartedMainActivity> startedMainActivities = new ArrayList<StartedMainActivity>();
    private final List<StartedActivity> startedActivities = Collections.synchronizedList(new ArrayList());
    private Context context;
    private PackageManager packageManager;
    private volatile int canInteractAcrossProfileAppOps = 2;
    private volatile boolean hasRequestedInteractAcrossProfiles = false;

    @Implementation
    protected void __constructor__(Context context, ICrossProfileApps service) {
        this.context = context;
        this.packageManager = context.getPackageManager();
    }

    @Implementation
    protected List<UserHandle> getTargetUserProfiles() {
        return ImmutableList.copyOf(this.targetUserProfiles);
    }

    @Implementation
    protected Drawable getProfileSwitchingIconDrawable(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        return new ColorDrawable(userHandle.getIdentifier());
    }

    @Implementation
    protected CharSequence getProfileSwitchingLabel(UserHandle userHandle) {
        this.verifyCanAccessUser(userHandle);
        return "Switch to " + userHandle;
    }

    @Implementation
    protected void startMainActivity(ComponentName componentName, UserHandle targetUser) {
        this.verifyCanAccessUser(targetUser);
        this.verifyActivityInManifest(componentName, true);
        this.startedMainActivities.add(new StartedMainActivity(componentName, targetUser));
        this.startedActivities.add(new StartedActivity(componentName, targetUser));
    }

    @Implementation(minSdk=29)
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_PROFILES")
    protected void startActivity(ComponentName componentName, UserHandle targetUser) {
        this.verifyCanAccessUser(targetUser);
        this.verifyActivityInManifest(componentName, false);
        this.verifyHasInteractAcrossProfilesPermission();
        this.startedActivities.add(new StartedActivity(componentName, targetUser));
    }

    @Implementation(minSdk=30)
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_PROFILES")
    protected void startActivity(Intent intent, UserHandle targetUser, @Nullable Activity activity) {
        this.startActivity(intent, targetUser, activity, null);
    }

    @Implementation(minSdk=30)
    @SystemApi
    @RequiresPermission(value="android.permission.INTERACT_ACROSS_PROFILES")
    protected void startActivity(Intent intent, UserHandle targetUser, @Nullable Activity activity, @Nullable Bundle options) {
        ComponentName componentName = intent.getComponent();
        if (componentName == null) {
            throw new IllegalArgumentException("Must set ComponentName on Intent");
        }
        this.verifyCanAccessUser(targetUser);
        this.verifyHasInteractAcrossProfilesPermission();
        this.startedActivities.add(new StartedActivity(componentName, targetUser, intent, activity, options));
    }

    public void addTargetUserProfile(UserHandle userHandle) {
        if (userHandle.equals((Object)Process.myUserHandle())) {
            throw new IllegalArgumentException("Cannot target current user");
        }
        this.targetUserProfiles.add(userHandle);
    }

    public void removeTargetUserProfile(UserHandle userHandle) {
        if (userHandle.equals((Object)Process.myUserHandle())) {
            throw new IllegalArgumentException("Cannot target current user");
        }
        this.targetUserProfiles.remove(userHandle);
    }

    public void clearTargetUserProfiles() {
        this.targetUserProfiles.clear();
    }

    @Nullable
    @Deprecated
    public StartedMainActivity peekNextStartedMainActivity() {
        if (this.startedMainActivities.isEmpty()) {
            return null;
        }
        return (StartedMainActivity)Iterables.getLast(this.startedMainActivities);
    }

    @Nullable
    public StartedActivity peekNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return (StartedActivity)Iterables.getLast(this.startedActivities);
    }

    @Nullable
    public StartedActivity getNextStartedActivity() {
        if (this.startedActivities.isEmpty()) {
            return null;
        }
        return this.startedActivities.remove(this.startedActivities.size() - 1);
    }

    public void clearNextStartedActivities() {
        this.startedActivities.clear();
    }

    @Implementation(minSdk=28)
    protected void verifyCanAccessUser(UserHandle userHandle) {
        if (!this.targetUserProfiles.contains(userHandle)) {
            throw new SecurityException("Not allowed to access " + userHandle + " (did you forget to call addTargetUserProfile?)");
        }
    }

    protected void verifyHasInteractAcrossProfilesPermission() {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            if (!this.canInteractAcrossProfiles()) {
                throw new SecurityException("Attempt to launch activity without required the permissions.");
            }
            return;
        }
        if (this.context.checkSelfPermission("android.permission.INTERACT_ACROSS_PROFILES") != 0) {
            throw new SecurityException("Attempt to launch activity without required android.permission.INTERACT_ACROSS_PROFILES permission");
        }
    }

    private void verifyActivityInManifest(ComponentName component, boolean requireMainActivity) {
        Intent launchIntent = new Intent();
        if (requireMainActivity) {
            launchIntent.setAction("android.intent.action.MAIN").addCategory("android.intent.category.LAUNCHER").addFlags(0x10200000).setPackage(component.getPackageName());
        } else {
            launchIntent.setComponent(component);
        }
        boolean existsMatchingActivity = Iterables.any((Iterable)this.packageManager.queryIntentActivities(launchIntent, 786432), resolveInfo -> {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            return TextUtils.equals((CharSequence)activityInfo.packageName, (CharSequence)component.getPackageName()) && TextUtils.equals((CharSequence)activityInfo.name, (CharSequence)component.getClassName()) && activityInfo.exported;
        });
        if (!existsMatchingActivity) {
            throw new SecurityException("Attempt to launch activity without  category Intent.CATEGORY_LAUNCHER or activity is not exported" + component);
        }
    }

    @Implementation(minSdk=30)
    protected boolean canInteractAcrossProfiles() {
        if (this.getTargetUserProfiles().isEmpty()) {
            return false;
        }
        return this.hasPermission("android.permission.INTERACT_ACROSS_USERS_FULL") || this.hasPermission("android.permission.INTERACT_ACROSS_PROFILES") || this.hasPermission("android.permission.INTERACT_ACROSS_USERS") || this.canInteractAcrossProfileAppOps == 0;
    }

    @Implementation(minSdk=30)
    protected boolean canRequestInteractAcrossProfiles() {
        if (this.getTargetUserProfiles().isEmpty()) {
            return false;
        }
        return this.hasRequestedInteractAcrossProfiles;
    }

    public void setHasRequestedInteractAcrossProfiles(boolean value) {
        this.hasRequestedInteractAcrossProfiles = value;
    }

    @Implementation(minSdk=30)
    protected Intent createRequestInteractAcrossProfilesIntent() {
        if (!this.canRequestInteractAcrossProfiles()) {
            throw new SecurityException("The calling package can not request to interact across profiles.");
        }
        return new Intent("android.settings.MANAGE_CROSS_PROFILE_ACCESS");
    }

    public boolean isRequestInteractAcrossProfilesIntent(Intent intent) {
        return "android.settings.MANAGE_CROSS_PROFILE_ACCESS".equals(intent.getAction());
    }

    private boolean hasPermission(String permission2) {
        return this.context.getPackageManager().checkPermission(permission2, this.context.getPackageName()) == 0;
    }

    public void setInteractAcrossProfilesAppOp(int newMode) {
        this.hasRequestedInteractAcrossProfiles = true;
        if (this.canInteractAcrossProfileAppOps != newMode) {
            this.canInteractAcrossProfileAppOps = newMode;
            this.context.sendBroadcast(new Intent("android.content.pm.action.CAN_INTERACT_ACROSS_PROFILES_CHANGED"));
        }
    }

    @Implementation(minSdk=30)
    protected void setInteractAcrossProfilesAppOp(String packageName, int newMode) {
        if (!this.hasPermission("android.permission.INTERACT_ACROSS_USERS") || !this.hasPermission("android.permission.CONFIGURE_INTERACT_ACROSS_PROFILES")) {
            throw new SecurityException("Requires INTERACT_ACROSS_USERS and CONFIGURE_INTERACT_ACROSS_PROFILES permission");
        }
        this.setInteractAcrossProfilesAppOp(newMode);
    }

    @Implementation(minSdk=30)
    protected boolean canConfigureInteractAcrossProfiles(String packageName) {
        return this.context.getPackageName().equals(packageName);
    }

    public static final class StartedActivity {
        private final ComponentName componentName;
        private final UserHandle userHandle;
        @Nullable
        private final Intent intent;
        @Nullable
        private final Activity activity;
        @Nullable
        private final Bundle options;

        public StartedActivity(ComponentName componentName, UserHandle userHandle) {
            this(componentName, userHandle, null, null, null);
        }

        public StartedActivity(ComponentName componentName, UserHandle userHandle, @Nullable Intent intent, @Nullable Activity activity, @Nullable Bundle options) {
            this.componentName = (ComponentName)Preconditions.checkNotNull((Object)componentName);
            this.userHandle = (UserHandle)Preconditions.checkNotNull((Object)userHandle);
            this.intent = intent;
            this.activity = activity;
            this.options = options;
        }

        public ComponentName getComponentName() {
            return this.componentName;
        }

        public UserHandle getUserHandle() {
            return this.userHandle;
        }

        @Nullable
        public Intent getIntent() {
            return this.intent;
        }

        @Nullable
        public Bundle getOptions() {
            return this.options;
        }

        @Nullable
        public Activity getActivity() {
            return this.activity;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StartedActivity that = (StartedActivity)o;
            return Objects.equals(this.componentName, that.componentName) && Objects.equals(this.userHandle, that.userHandle);
        }

        public int hashCode() {
            return Objects.hash(this.componentName, this.userHandle);
        }
    }

    @Deprecated
    public static class StartedMainActivity {
        private final ComponentName componentName;
        private final UserHandle userHandle;

        public StartedMainActivity(ComponentName componentName, UserHandle userHandle) {
            this.componentName = (ComponentName)Preconditions.checkNotNull((Object)componentName);
            this.userHandle = (UserHandle)Preconditions.checkNotNull((Object)userHandle);
        }

        public ComponentName getComponentName() {
            return this.componentName;
        }

        public UserHandle getUserHandle() {
            return this.userHandle;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StartedMainActivity that = (StartedMainActivity)o;
            return Objects.equals(this.componentName, that.componentName) && Objects.equals(this.userHandle, that.userHandle);
        }

        public int hashCode() {
            return Objects.hash(this.componentName, this.userHandle);
        }
    }
}

