/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.ApplicationPackageManager;
import android.app.KeyguardManager;
import android.app.admin.DevicePolicyManager;
import android.app.admin.IDevicePolicyManager;
import android.app.admin.SystemUpdatePolicy;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.UserHandle;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowKeyguardManager;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.shadows.ShadowUserManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=DevicePolicyManager.class)
@SuppressLint(value={"NewApi"})
public class ShadowDevicePolicyManager {
    private static final int DEFAULT_ORGANIZATION_COLOR = -16744320;
    private ComponentName deviceOwner;
    private ComponentName profileOwner;
    private List<ComponentName> deviceAdmins = new ArrayList<ComponentName>();
    private Map<Integer, String> profileOwnerNamesMap = new HashMap<Integer, String>();
    private List<String> permittedAccessibilityServices = new ArrayList<String>();
    private List<String> permittedInputMethods = new ArrayList<String>();
    private Map<String, Bundle> applicationRestrictionsMap = new HashMap<String, Bundle>();
    private CharSequence organizationName;
    private int organizationColor;
    private boolean isAutoTimeRequired;
    private int keyguardDisabledFeatures;
    private String lastSetPassword;
    private int requiredPasswordQuality = 0;
    private int userProvisioningState = 0;
    private int passwordMinimumLength;
    private int passwordMinimumLetters = 1;
    private int passwordMinimumLowerCase;
    private int passwordMinimumUpperCase;
    private int passwordMinimumNonLetter;
    private int passwordMinimumNumeric = 1;
    private int passwordMinimumSymbols = 1;
    private int passwordHistoryLength = 0;
    private long passwordExpiration = 0L;
    private long passwordExpirationTimeout = 0L;
    private int maximumFailedPasswordsForWipe = 0;
    private long maximumTimeToLock = 0L;
    private boolean cameraDisabled;
    private boolean isActivePasswordSufficient;
    private boolean isUniqueDeviceAttestationSupported;
    private int passwordComplexity;
    private int wipeCalled;
    private int storageEncryptionStatus;
    private int permissionPolicy;
    private boolean storageEncryptionRequested;
    private final Set<String> wasHiddenPackages = new HashSet<String>();
    private final Set<String> accountTypesWithManagementDisabled = new HashSet<String>();
    private final Set<String> systemAppsEnabled = new HashSet<String>();
    private final Set<String> uninstallBlockedPackages = new HashSet<String>();
    private final Set<String> suspendedPackages = new HashSet<String>();
    private final Set<String> affiliationIds = new HashSet<String>();
    private final Map<PackageAndPermission, Boolean> appPermissionGrantedMap = new HashMap<PackageAndPermission, Boolean>();
    private final Map<PackageAndPermission, Integer> appPermissionGrantStateMap = new HashMap<PackageAndPermission, Integer>();
    private final Map<ComponentName, byte[]> passwordResetTokens = new HashMap<ComponentName, byte[]>();
    private final Map<ComponentName, Set<Integer>> adminPolicyGrantedMap = new HashMap<ComponentName, Set<Integer>>();
    private final Map<ComponentName, CharSequence> shortSupportMessageMap = new HashMap<ComponentName, CharSequence>();
    private final Map<ComponentName, CharSequence> longSupportMessageMap = new HashMap<ComponentName, CharSequence>();
    private final Set<ComponentName> componentsWithActivatedTokens = new HashSet<ComponentName>();
    private Collection<String> packagesToFailForSetApplicationHidden = Collections.emptySet();
    private final List<String> lockTaskPackages = new ArrayList<String>();
    private Context context;
    private ApplicationPackageManager applicationPackageManager;
    private SystemUpdatePolicy policy;
    private List<UserHandle> bindDeviceAdminTargetUsers = ImmutableList.of();
    private boolean isDeviceProvisioned;
    private boolean isDeviceProvisioningConfigApplied;
    private volatile boolean organizationOwnedDeviceWithManagedProfile = false;
    private int nearbyNotificationStreamingPolicy = 0;
    private int nearbyAppStreamingPolicy = 0;
    private boolean isUsbDataSignalingEnabled = true;
    @RealObject
    private DevicePolicyManager realObject;

    @Implementation(maxSdk=23)
    protected void __constructor__(Context context, Handler handler) {
        this.init(context);
        Shadow.invokeConstructor(DevicePolicyManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler)});
    }

    @Implementation(minSdk=24, maxSdk=25)
    protected void __constructor__(Context context, boolean parentInstance) {
        this.init(context);
    }

    @Implementation(minSdk=26)
    protected void __constructor__(Context context, IDevicePolicyManager service) {
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.applicationPackageManager = (ApplicationPackageManager)context.getApplicationContext().getPackageManager();
        this.organizationColor = -16744320;
        this.storageEncryptionStatus = 0;
    }

    @Implementation(minSdk=18)
    protected boolean isDeviceOwnerApp(String packageName) {
        return this.deviceOwner != null && this.deviceOwner.getPackageName().equals(packageName);
    }

    @Implementation(minSdk=21)
    protected boolean isProfileOwnerApp(String packageName) {
        return this.profileOwner != null && this.profileOwner.getPackageName().equals(packageName);
    }

    @Implementation
    protected boolean isAdminActive(ComponentName who) {
        return who != null && this.deviceAdmins.contains(who);
    }

    @Implementation
    protected List<ComponentName> getActiveAdmins() {
        return this.deviceAdmins;
    }

    @Implementation(minSdk=21)
    protected void addUserRestriction(ComponentName admin, String key) {
        this.enforceActiveAdmin(admin);
        this.getShadowUserManager().setUserRestriction(Process.myUserHandle(), key, true);
    }

    @Implementation(minSdk=21)
    protected void clearUserRestriction(ComponentName admin, String key) {
        this.enforceActiveAdmin(admin);
        this.getShadowUserManager().setUserRestriction(Process.myUserHandle(), key, false);
    }

    @Implementation(minSdk=21)
    protected boolean setApplicationHidden(ComponentName admin, String packageName, boolean hidden) {
        this.enforceActiveAdmin(admin);
        if (this.packagesToFailForSetApplicationHidden.contains(packageName)) {
            return false;
        }
        if (hidden) {
            this.wasHiddenPackages.add(packageName);
        }
        return this.applicationPackageManager.setApplicationHiddenSettingAsUser(packageName, hidden, Process.myUserHandle());
    }

    public void failSetApplicationHiddenFor(Collection<String> packagesToFail) {
        if (packagesToFail == null) {
            packagesToFail = Collections.emptySet();
        }
        this.packagesToFailForSetApplicationHidden = packagesToFail;
    }

    @Implementation(minSdk=21)
    protected boolean isApplicationHidden(ComponentName admin, String packageName) {
        this.enforceActiveAdmin(admin);
        return this.applicationPackageManager.getApplicationHiddenSettingAsUser(packageName, Process.myUserHandle());
    }

    public boolean wasPackageEverHidden(String packageName) {
        return this.wasHiddenPackages.contains(packageName);
    }

    @Implementation(minSdk=21)
    protected void enableSystemApp(ComponentName admin, String packageName) {
        this.enforceActiveAdmin(admin);
        this.systemAppsEnabled.add(packageName);
    }

    public boolean wasSystemAppEnabled(String packageName) {
        return this.systemAppsEnabled.contains(packageName);
    }

    @Implementation(minSdk=21)
    protected void setUninstallBlocked(ComponentName admin, String packageName, boolean uninstallBlocked) {
        this.enforceActiveAdmin(admin);
        if (uninstallBlocked) {
            this.uninstallBlockedPackages.add(packageName);
        } else {
            this.uninstallBlockedPackages.remove(packageName);
        }
    }

    @Implementation(minSdk=21)
    protected boolean isUninstallBlocked(ComponentName admin, String packageName) {
        if (admin == null) {
            if (Build.VERSION.SDK_INT < 22) {
                throw new NullPointerException("ComponentName is null");
            }
        } else {
            this.enforceActiveAdmin(admin);
        }
        return this.uninstallBlockedPackages.contains(packageName);
    }

    public void setIsUniqueDeviceAttestationSupported(boolean supported) {
        this.isUniqueDeviceAttestationSupported = supported;
    }

    @Implementation(minSdk=30)
    protected boolean isUniqueDeviceAttestationSupported() {
        return this.isUniqueDeviceAttestationSupported;
    }

    public void setIsUsbDataSignalingEnabled(boolean isEnabled) {
        this.isUsbDataSignalingEnabled = isEnabled;
    }

    @Implementation(minSdk=31)
    protected boolean isUsbDataSignalingEnabled() {
        return this.isUsbDataSignalingEnabled;
    }

    @Implementation(minSdk=18)
    protected String getDeviceOwner() {
        return this.deviceOwner != null ? this.deviceOwner.getPackageName() : null;
    }

    @Implementation(minSdk=24)
    public boolean isDeviceManaged() {
        return this.getDeviceOwner() != null;
    }

    @Implementation(minSdk=21)
    protected ComponentName getProfileOwner() {
        return this.profileOwner;
    }

    @Implementation(minSdk=21)
    protected String getProfileOwnerNameAsUser(int userId) {
        return this.profileOwnerNamesMap.get(userId);
    }

    @Implementation(minSdk=28)
    protected void transferOwnership(ComponentName admin, ComponentName target, PersistableBundle bundle) {
        Objects.requireNonNull(admin, "ComponentName is null");
        Objects.requireNonNull(target, "Target cannot be null.");
        Preconditions.checkArgument((!admin.equals((Object)target) ? 1 : 0) != 0, (Object)"Provided administrator and target are the same object.");
        Preconditions.checkArgument((!admin.getPackageName().equals(target.getPackageName()) ? 1 : 0) != 0, (Object)"Provided administrator and target have the same package name.");
        if (admin.equals((Object)this.deviceOwner)) {
            this.deviceOwner = target;
        } else if (admin.equals((Object)this.profileOwner)) {
            this.profileOwner = target;
        } else {
            throw new SecurityException("Calling identity is not authorized");
        }
    }

    private ShadowUserManager getShadowUserManager() {
        return (ShadowUserManager)Shadow.extract((Object)this.context.getSystemService("user"));
    }

    @Implementation(minSdk=24)
    public boolean setDeviceOwner(ComponentName admin) {
        this.setActiveAdmin(admin);
        this.deviceOwner = admin;
        return true;
    }

    public void setProfileOwner(ComponentName admin) {
        this.setActiveAdmin(admin);
        this.profileOwner = admin;
    }

    public void setProfileOwnerName(int userId, String name) {
        this.profileOwnerNamesMap.put(userId, name);
    }

    public void setActiveAdmin(ComponentName componentName) {
        this.deviceAdmins.add(componentName);
    }

    @Implementation
    protected void removeActiveAdmin(ComponentName admin) {
        this.deviceAdmins.remove(admin);
    }

    @Implementation(minSdk=21)
    protected void clearProfileOwner(ComponentName admin) {
        this.profileOwner = null;
        if (Build.VERSION.SDK_INT >= 24) {
            this.removeActiveAdmin(admin);
        }
    }

    @Implementation(minSdk=21)
    protected Bundle getApplicationRestrictions(ComponentName admin, String packageName) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.getApplicationRestrictions(packageName);
    }

    public Bundle getApplicationRestrictions(String packageName) {
        Bundle bundle = this.applicationRestrictionsMap.get(packageName);
        return bundle != null ? new Bundle(bundle) : new Bundle();
    }

    @Implementation(minSdk=21)
    protected void setApplicationRestrictions(ComponentName admin, String packageName, Bundle applicationRestrictions) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.setApplicationRestrictions(packageName, applicationRestrictions);
    }

    public void setApplicationRestrictions(String packageName, Bundle applicationRestrictions) {
        this.applicationRestrictionsMap.put(packageName, new Bundle(applicationRestrictions));
    }

    private void enforceProfileOwner(ComponentName admin) {
        if (!admin.equals((Object)this.profileOwner)) {
            throw new SecurityException("[" + admin + "] is not a profile owner");
        }
    }

    private void enforceDeviceOwnerOrProfileOwner(ComponentName admin) {
        if (!admin.equals((Object)this.deviceOwner) && !admin.equals((Object)this.profileOwner)) {
            throw new SecurityException("[" + admin + "] is neither a device owner nor a profile owner.");
        }
    }

    private void enforceActiveAdmin(ComponentName admin) {
        if (!this.deviceAdmins.contains(admin)) {
            throw new SecurityException("[" + admin + "] is not an active device admin");
        }
    }

    @Implementation(minSdk=21)
    protected void setAccountManagementDisabled(ComponentName admin, String accountType, boolean disabled) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        if (disabled) {
            this.accountTypesWithManagementDisabled.add(accountType);
        } else {
            this.accountTypesWithManagementDisabled.remove(accountType);
        }
    }

    @Implementation(minSdk=21)
    protected String[] getAccountTypesWithManagementDisabled() {
        return this.accountTypesWithManagementDisabled.toArray(new String[0]);
    }

    @Implementation(minSdk=24)
    protected void setOrganizationName(ComponentName admin, CharSequence name) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceProfileOwner(admin);
        }
        this.organizationName = TextUtils.isEmpty((CharSequence)name) ? null : name;
    }

    @Implementation(minSdk=24)
    protected String[] setPackagesSuspended(ComponentName admin, String[] packageNames, boolean suspended) {
        if (admin != null) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        }
        if (packageNames == null) {
            throw new NullPointerException("package names cannot be null");
        }
        PackageManager pm = this.context.getPackageManager();
        ArrayList<String> packagesFailedToSuspend = new ArrayList<String>();
        for (String packageName : packageNames) {
            try {
                pm.getPackageInfo(packageName, 0);
                if (suspended) {
                    this.suspendedPackages.add(packageName);
                    continue;
                }
                this.suspendedPackages.remove(packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                packagesFailedToSuspend.add(packageName);
            }
        }
        return packagesFailedToSuspend.toArray(new String[0]);
    }

    @Implementation(minSdk=24)
    protected boolean isPackageSuspended(ComponentName admin, String packageName) throws PackageManager.NameNotFoundException {
        if (admin != null) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        }
        this.context.getPackageManager().getPackageInfo(packageName, 0);
        return this.suspendedPackages.contains(packageName);
    }

    @Implementation(minSdk=24)
    protected void setOrganizationColor(ComponentName admin, int color) {
        this.enforceProfileOwner(admin);
        this.organizationColor = color;
    }

    @Implementation(minSdk=24)
    protected CharSequence getOrganizationName(ComponentName admin) {
        if (Build.VERSION.SDK_INT >= 26) {
            this.enforceDeviceOwnerOrProfileOwner(admin);
        } else {
            this.enforceProfileOwner(admin);
        }
        return this.organizationName;
    }

    @Implementation(minSdk=24)
    protected int getOrganizationColor(ComponentName admin) {
        this.enforceProfileOwner(admin);
        return this.organizationColor;
    }

    @Implementation(minSdk=21)
    protected void setAutoTimeRequired(ComponentName admin, boolean required) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.isAutoTimeRequired = required;
    }

    @Implementation(minSdk=21)
    protected boolean getAutoTimeRequired() {
        return this.isAutoTimeRequired;
    }

    @Implementation(minSdk=21)
    protected boolean setPermittedAccessibilityServices(ComponentName admin, List<String> packageNames) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.permittedAccessibilityServices = packageNames;
        return true;
    }

    @Implementation(minSdk=21)
    protected List<String> getPermittedAccessibilityServices(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.permittedAccessibilityServices;
    }

    @Implementation(minSdk=21)
    protected boolean setPermittedInputMethods(ComponentName admin, List<String> packageNames) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.permittedInputMethods = packageNames;
        return true;
    }

    @Implementation(minSdk=21)
    protected List<String> getPermittedInputMethods(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.permittedInputMethods;
    }

    @Implementation
    protected int getStorageEncryptionStatus() {
        return this.storageEncryptionStatus;
    }

    public void setStorageEncryptionStatus(int status) {
        switch (status) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                if (RuntimeEnvironment.getApiLevel() >= 23) break;
                throw new IllegalArgumentException("status " + status + " requires API " + 23);
            }
            case 5: {
                if (RuntimeEnvironment.getApiLevel() >= 24) break;
                throw new IllegalArgumentException("status " + status + " requires API " + 24);
            }
            default: {
                throw new IllegalArgumentException("Unknown status: " + status);
            }
        }
        this.storageEncryptionStatus = status;
    }

    @Implementation
    protected int setStorageEncryption(ComponentName admin, boolean encrypt) {
        this.enforceActiveAdmin(admin);
        this.storageEncryptionRequested = encrypt;
        return this.storageEncryptionStatus;
    }

    @Implementation
    protected boolean getStorageEncryption(ComponentName admin) {
        return this.storageEncryptionRequested;
    }

    @Implementation(minSdk=23)
    protected int getPermissionGrantState(ComponentName admin, String packageName, String permission2) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        Integer state = this.appPermissionGrantStateMap.get(new PackageAndPermission(packageName, permission2));
        return state == null ? 0 : state;
    }

    public boolean isPermissionGranted(String packageName, String permission2) {
        Boolean isGranted = this.appPermissionGrantedMap.get(new PackageAndPermission(packageName, permission2));
        return isGranted == null ? false : isGranted;
    }

    @Implementation(minSdk=23)
    protected boolean setPermissionGrantState(ComponentName admin, String packageName, String permission2, int grantState) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        String selfPackageName = this.context.getPackageName();
        if (packageName.equals(selfPackageName)) {
            PackageInfo packageInfo;
            try {
                packageInfo = this.context.getPackageManager().getPackageInfo(selfPackageName, 4096);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (Arrays.asList(packageInfo.requestedPermissions).contains(permission2)) {
                if (grantState == 1) {
                    ShadowApplication.getInstance().grantPermissions(permission2);
                }
                if (grantState == 2) {
                    ShadowApplication.getInstance().denyPermissions(permission2);
                }
            } else {
                return false;
            }
        }
        PackageAndPermission key = new PackageAndPermission(packageName, permission2);
        switch (grantState) {
            case 1: {
                this.appPermissionGrantedMap.put(key, true);
                break;
            }
            case 2: {
                this.appPermissionGrantedMap.put(key, false);
                break;
            }
        }
        this.appPermissionGrantStateMap.put(key, grantState);
        return true;
    }

    @Implementation
    protected void lockNow() {
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        ShadowKeyguardManager shadowKeyguardManager = (ShadowKeyguardManager)Shadow.extract((Object)keyguardManager);
        shadowKeyguardManager.setKeyguardLocked(true);
        shadowKeyguardManager.setIsDeviceLocked(true);
    }

    @Implementation
    protected void wipeData(int flags) {
        ++this.wipeCalled;
    }

    public long getWipeCalledTimes() {
        return this.wipeCalled;
    }

    @Implementation
    protected void setPasswordQuality(ComponentName admin, int quality) {
        this.enforceActiveAdmin(admin);
        this.requiredPasswordQuality = quality;
    }

    @Implementation
    protected int getPasswordQuality(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.requiredPasswordQuality;
    }

    @Implementation
    protected boolean resetPassword(String password, int flags) {
        if (!this.passwordMeetsRequirements(password)) {
            return false;
        }
        this.lastSetPassword = password;
        boolean secure = !password.isEmpty();
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        Shadows.shadowOf(keyguardManager).setIsDeviceSecure(secure);
        Shadows.shadowOf(keyguardManager).setIsKeyguardSecure(secure);
        return true;
    }

    @Implementation(minSdk=26)
    protected boolean resetPasswordWithToken(ComponentName admin, String password, byte[] token, int flags) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        if (!Arrays.equals(this.passwordResetTokens.get(admin), token) || !this.componentsWithActivatedTokens.contains(admin)) {
            throw new IllegalStateException("wrong or not activated token");
        }
        this.resetPassword(password, flags);
        return true;
    }

    @Implementation(minSdk=26)
    protected boolean isResetPasswordTokenActive(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.componentsWithActivatedTokens.contains(admin);
    }

    @Implementation(minSdk=26)
    protected boolean setResetPasswordToken(ComponentName admin, byte[] token) {
        if (token.length < 32) {
            throw new IllegalArgumentException("token too short: " + token.length);
        }
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.passwordResetTokens.put(admin, token);
        this.componentsWithActivatedTokens.remove(admin);
        KeyguardManager keyguardManager = (KeyguardManager)this.context.getSystemService("keyguard");
        if (!keyguardManager.isDeviceSecure()) {
            this.activateResetToken(admin);
        }
        return true;
    }

    @Implementation
    protected void setPasswordMinimumLength(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordMinimumLength = length;
    }

    @Implementation
    protected int getPasswordMinimumLength(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordMinimumLength;
    }

    @Implementation
    protected void setPasswordMinimumLetters(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordMinimumLetters = length;
    }

    @Implementation
    protected int getPasswordMinimumLetters(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordMinimumLetters;
    }

    @Implementation
    protected void setPasswordMinimumLowerCase(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordMinimumLowerCase = length;
    }

    @Implementation
    protected int getPasswordMinimumLowerCase(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordMinimumLowerCase;
    }

    @Implementation
    protected void setPasswordMinimumUpperCase(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordMinimumUpperCase = length;
    }

    @Implementation
    protected int getPasswordMinimumUpperCase(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordMinimumUpperCase;
    }

    @Implementation
    protected void setPasswordMinimumNonLetter(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordMinimumNonLetter = length;
    }

    @Implementation
    protected int getPasswordMinimumNonLetter(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordMinimumNonLetter;
    }

    @Implementation
    protected void setPasswordMinimumNumeric(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordMinimumNumeric = length;
    }

    @Implementation
    protected int getPasswordMinimumNumeric(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordMinimumNumeric;
    }

    @Implementation
    protected void setPasswordMinimumSymbols(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordMinimumSymbols = length;
    }

    @Implementation
    protected int getPasswordMinimumSymbols(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordMinimumSymbols;
    }

    @Implementation
    protected void setMaximumFailedPasswordsForWipe(ComponentName admin, int num) {
        this.enforceActiveAdmin(admin);
        this.maximumFailedPasswordsForWipe = num;
    }

    @Implementation
    protected int getMaximumFailedPasswordsForWipe(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.maximumFailedPasswordsForWipe;
    }

    @Implementation
    protected void setCameraDisabled(ComponentName admin, boolean disabled) {
        this.enforceActiveAdmin(admin);
        this.cameraDisabled = disabled;
    }

    @Implementation
    protected boolean getCameraDisabled(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.cameraDisabled;
    }

    @Implementation
    protected void setPasswordExpirationTimeout(ComponentName admin, long timeout) {
        this.enforceActiveAdmin(admin);
        this.passwordExpirationTimeout = timeout;
    }

    @Implementation
    protected long getPasswordExpirationTimeout(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordExpirationTimeout;
    }

    public void setPasswordExpiration(ComponentName admin, long timeout) {
        this.enforceActiveAdmin(admin);
        this.passwordExpiration = timeout;
    }

    @Implementation
    protected long getPasswordExpiration(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordExpiration;
    }

    @Implementation
    protected void setMaximumTimeToLock(ComponentName admin, long timeMs) {
        this.enforceActiveAdmin(admin);
        this.maximumTimeToLock = timeMs;
    }

    @Implementation
    protected long getMaximumTimeToLock(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.maximumTimeToLock;
    }

    @Implementation
    protected void setPasswordHistoryLength(ComponentName admin, int length) {
        this.enforceActiveAdmin(admin);
        this.passwordHistoryLength = length;
    }

    @Implementation
    protected int getPasswordHistoryLength(ComponentName admin) {
        if (admin != null) {
            this.enforceActiveAdmin(admin);
        }
        return this.passwordHistoryLength;
    }

    public void setActivePasswordSufficient(boolean sufficient) {
        this.isActivePasswordSufficient = sufficient;
    }

    @Implementation
    protected boolean isActivePasswordSufficient() {
        return this.isActivePasswordSufficient;
    }

    public void setDeviceProvisioned(boolean isProvisioned) {
        this.isDeviceProvisioned = isProvisioned;
    }

    @Implementation(minSdk=26)
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    protected boolean isDeviceProvisioned() {
        return this.isDeviceProvisioned;
    }

    @Implementation(minSdk=26)
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    protected void setDeviceProvisioningConfigApplied() {
        this.isDeviceProvisioningConfigApplied = true;
    }

    @Implementation(minSdk=26)
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_USERS")
    protected boolean isDeviceProvisioningConfigApplied() {
        return this.isDeviceProvisioningConfigApplied;
    }

    public void setPasswordComplexity(int passwordComplexity) {
        this.passwordComplexity = passwordComplexity;
    }

    @Implementation(minSdk=29)
    protected int getPasswordComplexity() {
        return this.passwordComplexity;
    }

    private boolean passwordMeetsRequirements(String password) {
        int digit = 0;
        int alpha = 0;
        int upper = 0;
        int lower = 0;
        int symbol = 0;
        for (int i = 0; i < password.length(); ++i) {
            char c = password.charAt(i);
            if (Character.isDigit(c)) {
                ++digit;
            }
            if (Character.isLetter(c)) {
                ++alpha;
            }
            if (Character.isUpperCase(c)) {
                ++upper;
            }
            if (Character.isLowerCase(c)) {
                ++lower;
            }
            if (Character.isLetterOrDigit(c)) continue;
            ++symbol;
        }
        switch (this.requiredPasswordQuality) {
            case 0: 
            case 32768: 
            case 524288: {
                return true;
            }
            case 65536: {
                return password.length() > 0;
            }
            case 131072: 
            case 196608: {
                return digit > 0 && password.length() >= this.passwordMinimumLength;
            }
            case 327680: {
                return digit > 0 && alpha > 0 && password.length() >= this.passwordMinimumLength;
            }
            case 393216: {
                return password.length() >= this.passwordMinimumLength && alpha >= this.passwordMinimumLetters && lower >= this.passwordMinimumLowerCase && upper >= this.passwordMinimumUpperCase && digit + symbol >= this.passwordMinimumNonLetter && digit >= this.passwordMinimumNumeric && symbol >= this.passwordMinimumSymbols;
            }
        }
        return true;
    }

    public String getLastSetPassword() {
        return this.lastSetPassword;
    }

    public boolean activateResetToken(ComponentName admin) {
        if (!this.passwordResetTokens.containsKey(admin)) {
            throw new IllegalArgumentException("No token set for comopnent: " + admin);
        }
        return this.componentsWithActivatedTokens.add(admin);
    }

    @Implementation(minSdk=21)
    protected void addPersistentPreferredActivity(ComponentName admin, IntentFilter filter, ComponentName activity) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        PackageManager packageManager = this.context.getPackageManager();
        ((ShadowPackageManager)Shadow.extract((Object)packageManager)).addPersistentPreferredActivity(filter, activity);
    }

    @Implementation(minSdk=21)
    protected void clearPackagePersistentPreferredActivities(ComponentName admin, String packageName) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        PackageManager packageManager = this.context.getPackageManager();
        ((ShadowPackageManager)Shadow.extract((Object)packageManager)).clearPackagePersistentPreferredActivities(packageName);
    }

    @Implementation(minSdk=17)
    protected void setKeyguardDisabledFeatures(ComponentName admin, int which) {
        this.enforceActiveAdmin(admin);
        this.keyguardDisabledFeatures = which;
    }

    @Implementation(minSdk=17)
    protected int getKeyguardDisabledFeatures(ComponentName admin) {
        return this.keyguardDisabledFeatures;
    }

    public void setUserProvisioningState(int state) {
        this.userProvisioningState = state;
    }

    @Implementation(minSdk=24)
    protected int getUserProvisioningState() {
        return this.userProvisioningState;
    }

    @Implementation
    protected boolean hasGrantedPolicy(ComponentName admin, int usesPolicy) {
        this.enforceActiveAdmin(admin);
        Set<Integer> policyGrantedSet = this.adminPolicyGrantedMap.get(admin);
        return policyGrantedSet != null && policyGrantedSet.contains(usesPolicy);
    }

    @Implementation(minSdk=21)
    protected void setLockTaskPackages(ComponentName admin, String[] packages) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.lockTaskPackages.clear();
        Collections.addAll(this.lockTaskPackages, packages);
    }

    @Implementation(minSdk=21)
    protected String[] getLockTaskPackages(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.lockTaskPackages.toArray(new String[0]);
    }

    @Implementation(minSdk=21)
    protected boolean isLockTaskPermitted(String pkg) {
        return this.lockTaskPackages.contains(pkg);
    }

    @Implementation(minSdk=26)
    protected void setAffiliationIds(ComponentName admin, Set<String> ids) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.affiliationIds.clear();
        this.affiliationIds.addAll(ids);
    }

    @Implementation(minSdk=26)
    protected Set<String> getAffiliationIds(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.affiliationIds;
    }

    @Implementation(minSdk=23)
    protected void setPermissionPolicy(ComponentName admin, int policy) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        this.permissionPolicy = policy;
    }

    @Implementation(minSdk=23)
    protected int getPermissionPolicy(ComponentName admin) {
        this.enforceDeviceOwnerOrProfileOwner(admin);
        return this.permissionPolicy;
    }

    public void grantPolicy(ComponentName admin, int usesPolicy) {
        this.enforceActiveAdmin(admin);
        Set<Integer> policyGrantedSet = this.adminPolicyGrantedMap.get(admin);
        if (policyGrantedSet == null) {
            policyGrantedSet = new HashSet<Integer>();
            policyGrantedSet.add(usesPolicy);
            this.adminPolicyGrantedMap.put(admin, policyGrantedSet);
        } else {
            policyGrantedSet.add(usesPolicy);
        }
    }

    @Implementation(minSdk=23)
    protected SystemUpdatePolicy getSystemUpdatePolicy() {
        return this.policy;
    }

    @Implementation(minSdk=23)
    protected void setSystemUpdatePolicy(ComponentName admin, SystemUpdatePolicy policy) {
        this.policy = policy;
    }

    public void setSystemUpdatePolicy(SystemUpdatePolicy policy) {
        this.setSystemUpdatePolicy(null, policy);
    }

    public void setBindDeviceAdminTargetUsers(List<UserHandle> bindDeviceAdminTargetUsers) {
        this.bindDeviceAdminTargetUsers = bindDeviceAdminTargetUsers;
    }

    @Implementation(minSdk=26)
    protected List<UserHandle> getBindDeviceAdminTargetUsers(ComponentName admin) {
        return this.bindDeviceAdminTargetUsers;
    }

    @Implementation(minSdk=26)
    protected boolean bindDeviceAdminServiceAsUser(ComponentName admin, Intent serviceIntent, ServiceConnection conn, int flags, UserHandle targetUser) {
        if (!this.getBindDeviceAdminTargetUsers(admin).contains(targetUser)) {
            throw new SecurityException("Not allowed to bind to target user id");
        }
        return this.context.bindServiceAsUser(serviceIntent, conn, flags, targetUser);
    }

    @Implementation(minSdk=24)
    protected void setShortSupportMessage(ComponentName admin, CharSequence message) {
        this.enforceActiveAdmin(admin);
        this.shortSupportMessageMap.put(admin, message);
    }

    @Implementation(minSdk=24)
    protected CharSequence getShortSupportMessage(ComponentName admin) {
        this.enforceActiveAdmin(admin);
        return this.shortSupportMessageMap.get(admin);
    }

    @Implementation(minSdk=24)
    protected void setLongSupportMessage(ComponentName admin, CharSequence message) {
        this.enforceActiveAdmin(admin);
        this.longSupportMessageMap.put(admin, message);
    }

    @Implementation(minSdk=24)
    protected CharSequence getLongSupportMessage(ComponentName admin) {
        this.enforceActiveAdmin(admin);
        return this.longSupportMessageMap.get(admin);
    }

    public void setOrganizationOwnedDeviceWithManagedProfile(boolean value) {
        this.organizationOwnedDeviceWithManagedProfile = value;
    }

    @Implementation(minSdk=30)
    protected boolean isOrganizationOwnedDeviceWithManagedProfile() {
        return this.organizationOwnedDeviceWithManagedProfile;
    }

    @Implementation(minSdk=31)
    protected int getNearbyNotificationStreamingPolicy() {
        return this.nearbyNotificationStreamingPolicy;
    }

    @Implementation(minSdk=31)
    protected void setNearbyNotificationStreamingPolicy(int policy) {
        this.nearbyNotificationStreamingPolicy = policy;
    }

    @Implementation(minSdk=31)
    protected int getNearbyAppStreamingPolicy() {
        return this.nearbyAppStreamingPolicy;
    }

    @Implementation(minSdk=31)
    protected void setNearbyAppStreamingPolicy(int policy) {
        this.nearbyAppStreamingPolicy = policy;
    }

    private static class PackageAndPermission {
        private String packageName;
        private String permission;

        public PackageAndPermission(String packageName, String permission2) {
            this.packageName = packageName;
            this.permission = permission2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PackageAndPermission)) {
                return false;
            }
            PackageAndPermission other = (PackageAndPermission)o;
            return this.packageName.equals(other.packageName) && this.permission.equals(other.permission);
        }

        public int hashCode() {
            int result = this.packageName.hashCode();
            result = 31 * result + this.permission.hashCode();
            return result;
        }
    }
}

