/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.AutomaticZenRule;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ComponentName;
import android.os.Parcel;
import android.os.Process;
import android.service.notification.StatusBarNotification;
import androidx.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowSystem;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=NotificationManager.class, looseSignatures=true)
public class ShadowNotificationManager {
    private static final int MAX_NOTIFICATION_LIMIT = 25;
    private boolean mAreNotificationsEnabled = true;
    private boolean isNotificationPolicyAccessGranted = false;
    private boolean enforceMaxNotificationLimit = false;
    private final Map<Key, PostedNotification> notifications = new ConcurrentHashMap<Key, PostedNotification>();
    private final Map<String, Object> notificationChannels = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> notificationChannelGroups = new ConcurrentHashMap<String, Object>();
    private final Map<String, Object> deletedNotificationChannels = new ConcurrentHashMap<String, Object>();
    private final Map<String, AutomaticZenRule> automaticZenRules = new ConcurrentHashMap<String, AutomaticZenRule>();
    private final Map<String, Boolean> listenerAccessGrantedComponents = new ConcurrentHashMap<String, Boolean>();
    private final Set<String> canNotifyOnBehalfPackages = Sets.newConcurrentHashSet();
    private int currentInteruptionFilter = 1;
    private NotificationManager.Policy notificationPolicy;
    private String notificationDelegate;
    private int importance;

    @Implementation
    protected void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    @Implementation
    protected void notify(String tag, int id2, Notification notification) {
        if (!this.enforceMaxNotificationLimit || this.notifications.size() < 25) {
            this.notifications.put(new Key(tag, id2), new PostedNotification(notification, ShadowSystem.currentTimeMillis()));
        }
    }

    @Implementation
    protected void cancel(int id2) {
        this.cancel(null, id2);
    }

    @Implementation
    protected void cancel(String tag, int id2) {
        Key key = new Key(tag, id2);
        if (this.notifications.containsKey(key)) {
            this.notifications.remove(key);
        }
    }

    @Implementation
    protected void cancelAll() {
        this.notifications.clear();
    }

    @Implementation(minSdk=24)
    protected boolean areNotificationsEnabled() {
        return this.mAreNotificationsEnabled;
    }

    public void setNotificationsEnabled(boolean areNotificationsEnabled) {
        this.mAreNotificationsEnabled = areNotificationsEnabled;
    }

    @Implementation(minSdk=24)
    protected int getImportance() {
        return this.importance;
    }

    public void setImportance(int importance) {
        this.importance = importance;
    }

    @Implementation(minSdk=23)
    public StatusBarNotification[] getActiveNotifications() {
        ImmutableMap notifsCopy = ImmutableMap.copyOf(this.notifications);
        StatusBarNotification[] statusBarNotifications = new StatusBarNotification[notifsCopy.size()];
        int i = 0;
        for (Map.Entry entry : notifsCopy.entrySet()) {
            statusBarNotifications[i++] = new StatusBarNotification(RuntimeEnvironment.getApplication().getPackageName(), null, ((Key)entry.getKey()).id, ((Key)entry.getKey()).tag, Process.myUid(), Process.myPid(), 0, ((PostedNotification)entry.getValue()).notification, Process.myUserHandle(), ((PostedNotification)entry.getValue()).postedTimeMillis);
        }
        return statusBarNotifications;
    }

    @Implementation(minSdk=26)
    protected Object getNotificationChannel(String channelId) {
        return this.notificationChannels.get(channelId);
    }

    @Implementation(minSdk=30)
    protected NotificationChannel getNotificationChannel(String channelId, String conversationId) {
        for (Object object : this.getNotificationChannels()) {
            NotificationChannel notificationChannel = (NotificationChannel)object;
            if (!conversationId.equals(notificationChannel.getConversationId()) || !channelId.equals(notificationChannel.getParentChannelId())) continue;
            return notificationChannel;
        }
        return null;
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannelGroup(Object group) {
        String id2 = (String)ReflectionHelpers.callInstanceMethod((Object)group, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        this.notificationChannelGroups.put(id2, group);
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannelGroups(List<Object> groupList) {
        for (Object group : groupList) {
            this.createNotificationChannelGroup(group);
        }
    }

    @Implementation(minSdk=26)
    protected List<Object> getNotificationChannelGroups() {
        return ImmutableList.copyOf(this.notificationChannelGroups.values());
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannel(Object channel) {
        NotificationChannel existingChannel;
        String id2 = (String)ReflectionHelpers.callInstanceMethod((Object)channel, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        if (this.deletedNotificationChannels.containsKey(id2)) {
            this.notificationChannels.put(id2, this.deletedNotificationChannels.remove(id2));
        }
        if ((existingChannel = (NotificationChannel)this.notificationChannels.get(id2)) != null) {
            NotificationChannel newChannel = (NotificationChannel)channel;
            existingChannel.setName(newChannel.getName());
            existingChannel.setDescription(newChannel.getDescription());
            if (newChannel.getImportance() < existingChannel.getImportance()) {
                existingChannel.setImportance(newChannel.getImportance());
            }
            if (Strings.isNullOrEmpty((String)existingChannel.getGroup())) {
                existingChannel.setGroup(newChannel.getGroup());
            }
            return;
        }
        this.notificationChannels.put(id2, channel);
    }

    @Implementation(minSdk=26)
    protected void createNotificationChannels(List<Object> channelList) {
        for (Object channel : channelList) {
            this.createNotificationChannel(channel);
        }
    }

    @Implementation(minSdk=26)
    public List<Object> getNotificationChannels() {
        return ImmutableList.copyOf(this.notificationChannels.values());
    }

    @Implementation(minSdk=26)
    protected void deleteNotificationChannel(String channelId) {
        if (this.getNotificationChannel(channelId) != null) {
            Object channel = this.notificationChannels.remove(channelId);
            this.deletedNotificationChannels.put(channelId, channel);
        }
    }

    @Implementation(minSdk=26)
    protected void deleteNotificationChannelGroup(String channelGroupId) {
        if (this.getNotificationChannelGroup(channelGroupId) != null) {
            for (Object channel : this.getNotificationChannels()) {
                String groupId = (String)ReflectionHelpers.callInstanceMethod((Object)channel, (String)"getGroup", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                if (!channelGroupId.equals(groupId)) continue;
                String channelId = (String)ReflectionHelpers.callInstanceMethod((Object)channel, (String)"getId", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
                this.deleteNotificationChannel(channelId);
            }
            this.notificationChannelGroups.remove(channelGroupId);
        }
    }

    @Implementation(minSdk=23)
    protected final int getCurrentInterruptionFilter() {
        return this.currentInteruptionFilter;
    }

    @Implementation(minSdk=23)
    protected final void setInterruptionFilter(int interruptionFilter) {
        this.currentInteruptionFilter = interruptionFilter;
    }

    @Implementation(minSdk=23)
    protected final NotificationManager.Policy getNotificationPolicy() {
        return this.notificationPolicy;
    }

    @Implementation(minSdk=23)
    protected final boolean isNotificationPolicyAccessGranted() {
        return this.isNotificationPolicyAccessGranted;
    }

    @Implementation(minSdk=27)
    protected final boolean isNotificationListenerAccessGranted(ComponentName componentName) {
        return this.listenerAccessGrantedComponents.getOrDefault(componentName.flattenToString(), false);
    }

    @Implementation(minSdk=23)
    protected final void setNotificationPolicy(NotificationManager.Policy policy) {
        this.notificationPolicy = policy;
    }

    public void setNotificationPolicyAccessGranted(boolean granted) {
        this.isNotificationPolicyAccessGranted = granted;
        if (!granted) {
            this.automaticZenRules.clear();
        }
    }

    @Implementation(minSdk=27)
    public void setNotificationListenerAccessGranted(ComponentName componentName, boolean granted) {
        this.listenerAccessGrantedComponents.put(componentName.flattenToString(), granted);
    }

    @Implementation(minSdk=24)
    protected AutomaticZenRule getAutomaticZenRule(String id2) {
        Preconditions.checkNotNull((Object)id2);
        this.enforcePolicyAccess();
        return this.automaticZenRules.get(id2);
    }

    @Implementation(minSdk=24)
    protected Map<String, AutomaticZenRule> getAutomaticZenRules() {
        this.enforcePolicyAccess();
        ImmutableMap.Builder rules = new ImmutableMap.Builder();
        for (Map.Entry<String, AutomaticZenRule> entry : this.automaticZenRules.entrySet()) {
            rules.put((Object)entry.getKey(), (Object)this.copyAutomaticZenRule(entry.getValue()));
        }
        return rules.build();
    }

    @Implementation(minSdk=24)
    protected String addAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        Preconditions.checkNotNull((Object)automaticZenRule);
        Preconditions.checkNotNull((Object)automaticZenRule.getName());
        Preconditions.checkState((automaticZenRule.getOwner() != null || automaticZenRule.getConfigurationActivity() != null ? 1 : 0) != 0, (Object)"owner/configurationActivity cannot be null at the same time");
        Preconditions.checkNotNull((Object)automaticZenRule.getConditionId());
        this.enforcePolicyAccess();
        String id2 = UUID.randomUUID().toString().replace("-", "");
        this.automaticZenRules.put(id2, this.copyAutomaticZenRule(automaticZenRule));
        return id2;
    }

    @Implementation(minSdk=24)
    protected boolean updateAutomaticZenRule(String id2, AutomaticZenRule automaticZenRule) {
        Preconditions.checkNotNull((Object)automaticZenRule);
        Preconditions.checkNotNull((Object)automaticZenRule.getName());
        Preconditions.checkState((automaticZenRule.getOwner() != null || automaticZenRule.getConfigurationActivity() != null ? 1 : 0) != 0, (Object)"owner/configurationActivity cannot be null at the same time");
        Preconditions.checkNotNull((Object)automaticZenRule.getConditionId());
        this.enforcePolicyAccess();
        if (id2 == null) {
            throw new IllegalArgumentException("Rule doesn't exist");
        }
        if (!this.automaticZenRules.containsKey(id2)) {
            throw new SecurityException("Cannot update rules not owned by your condition provider");
        }
        this.automaticZenRules.put(id2, this.copyAutomaticZenRule(automaticZenRule));
        return true;
    }

    @Implementation(minSdk=24)
    protected boolean removeAutomaticZenRule(String id2) {
        Preconditions.checkNotNull((Object)id2);
        this.enforcePolicyAccess();
        return this.automaticZenRules.remove(id2) != null;
    }

    @Implementation(minSdk=29)
    protected String getNotificationDelegate() {
        return this.notificationDelegate;
    }

    @Implementation(minSdk=29)
    protected boolean canNotifyAsPackage(@NonNull String pkg) {
        return this.canNotifyOnBehalfPackages.contains(pkg);
    }

    public void setCanNotifyAsPackage(@NonNull String otherPackage, boolean canNotify) {
        if (canNotify) {
            this.canNotifyOnBehalfPackages.add(otherPackage);
        } else {
            this.canNotifyOnBehalfPackages.remove(otherPackage);
        }
    }

    @Implementation(minSdk=29)
    protected void setNotificationDelegate(String delegate) {
        this.notificationDelegate = delegate;
    }

    public void setEnforceMaxNotificationLimit(boolean enforceMaxNotificationLimit) {
        this.enforceMaxNotificationLimit = enforceMaxNotificationLimit;
    }

    private void enforcePolicyAccess() {
        if (!this.isNotificationPolicyAccessGranted) {
            throw new SecurityException("Notification policy access denied");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AutomaticZenRule copyAutomaticZenRule(AutomaticZenRule automaticZenRule) {
        Parcel parcel = Parcel.obtain();
        try {
            automaticZenRule.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            AutomaticZenRule automaticZenRule2 = new AutomaticZenRule(parcel);
            return automaticZenRule2;
        }
        finally {
            parcel.recycle();
        }
    }

    public boolean isChannelDeleted(String channelId) {
        return this.deletedNotificationChannels.containsKey(channelId);
    }

    @Implementation(minSdk=28)
    public Object getNotificationChannelGroup(String id2) {
        return this.notificationChannelGroups.get(id2);
    }

    public int size() {
        return this.notifications.size();
    }

    public Notification getNotification(int id2) {
        PostedNotification postedNotification = this.notifications.get(new Key(null, id2));
        return postedNotification == null ? null : postedNotification.notification;
    }

    public Notification getNotification(String tag, int id2) {
        PostedNotification postedNotification = this.notifications.get(new Key(tag, id2));
        return postedNotification == null ? null : postedNotification.notification;
    }

    public List<Notification> getAllNotifications() {
        ArrayList<Notification> result = new ArrayList<Notification>(this.notifications.size());
        for (PostedNotification postedNotification : this.notifications.values()) {
            result.add(postedNotification.notification);
        }
        return result;
    }

    private static final class PostedNotification {
        private final Notification notification;
        private final long postedTimeMillis;

        private PostedNotification(Notification notification, long postedTimeMillis) {
            this.notification = notification;
            this.postedTimeMillis = postedTimeMillis;
        }
    }

    private static final class Key {
        public final String tag;
        public final int id;

        private Key(String tag, int id2) {
            this.tag = tag;
            this.id = id2;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = 37 * hashCode + (this.tag == null ? 0 : this.tag.hashCode());
            hashCode = 37 * hashCode + this.id;
            return hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return (this.tag == null ? other.tag == null : this.tag.equals(other.tag)) && this.id == other.id;
        }
    }
}

