/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.hardware.Camera;
import android.os.Build;
import android.view.SurfaceHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Camera.class)
public class ShadowCamera {
    private static int lastOpenedCameraId;
    private int id;
    private boolean locked;
    private boolean previewing;
    private boolean released;
    private Camera.Parameters parameters;
    private Camera.PreviewCallback previewCallback;
    private List<byte[]> callbackBuffers = new ArrayList<byte[]>();
    private SurfaceHolder surfaceHolder;
    private int displayOrientation;
    private Camera.AutoFocusCallback autoFocusCallback;
    private boolean autoFocusing;
    private boolean shutterSoundEnabled;
    private static Map<Integer, Camera.CameraInfo> cameras;
    @RealObject
    private Camera realCamera;

    @Implementation
    protected void __constructor__() {
        this.locked = true;
        this.previewing = false;
        this.released = false;
        this.shutterSoundEnabled = true;
    }

    @Implementation
    protected static Camera open() {
        lastOpenedCameraId = 0;
        Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
        ShadowCamera shadowCamera = (ShadowCamera)Shadow.extract((Object)camera);
        shadowCamera.id = 0;
        return camera;
    }

    @Implementation
    protected static Camera open(int cameraId) {
        lastOpenedCameraId = cameraId;
        Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
        ShadowCamera shadowCamera = (ShadowCamera)Shadow.extract((Object)camera);
        shadowCamera.id = cameraId;
        return camera;
    }

    public static int getLastOpenedCameraId() {
        return lastOpenedCameraId;
    }

    @Implementation
    protected void unlock() {
        this.locked = false;
    }

    @Implementation
    protected void reconnect() {
        this.locked = true;
    }

    @Implementation
    protected Camera.Parameters getParameters() {
        if (null == this.parameters) {
            this.parameters = (Camera.Parameters)Shadow.newInstanceOf(Camera.Parameters.class);
        }
        return this.parameters;
    }

    @Implementation
    protected void setParameters(Camera.Parameters params) {
        this.parameters = params;
    }

    @Implementation
    protected void setPreviewDisplay(SurfaceHolder holder) {
        this.surfaceHolder = holder;
    }

    @Implementation
    protected void startPreview() {
        this.previewing = true;
    }

    @Implementation
    protected void stopPreview() {
        this.previewing = false;
    }

    @Implementation
    protected void release() {
        this.released = true;
    }

    @Implementation
    protected void setPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    protected void setOneShotPreviewCallback(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    @Implementation
    protected void setPreviewCallbackWithBuffer(Camera.PreviewCallback cb) {
        this.previewCallback = cb;
    }

    public void invokePreviewCallback(byte[] data) {
        if (this.previewCallback != null) {
            this.previewCallback.onPreviewFrame(data, this.realCamera);
        }
    }

    @Implementation
    protected void addCallbackBuffer(byte[] callbackBuffer) {
        this.callbackBuffers.add(callbackBuffer);
    }

    public List<byte[]> getAddedCallbackBuffers() {
        return Collections.unmodifiableList(this.callbackBuffers);
    }

    @Implementation
    protected void setDisplayOrientation(int degrees) {
        this.displayOrientation = degrees;
        if (cameras.containsKey(this.id)) {
            ShadowCamera.cameras.get((Object)Integer.valueOf((int)this.id)).orientation = degrees;
        }
    }

    public int getDisplayOrientation() {
        return this.displayOrientation;
    }

    @Implementation
    protected void autoFocus(Camera.AutoFocusCallback callback) {
        this.autoFocusCallback = callback;
        this.autoFocusing = true;
    }

    @Implementation
    protected void cancelAutoFocus() {
        this.autoFocusCallback = null;
        this.autoFocusing = false;
    }

    public boolean hasRequestedAutoFocus() {
        return this.autoFocusing;
    }

    public void invokeAutoFocusCallback(boolean success, Camera camera) {
        if (this.autoFocusCallback == null) {
            throw new IllegalStateException("cannot invoke AutoFocusCallback before autoFocus() has been called or after cancelAutoFocus() has been called or after the callback has been invoked.");
        }
        this.autoFocusCallback.onAutoFocus(success, camera);
        this.autoFocusCallback = null;
        this.autoFocusing = false;
    }

    @Implementation
    protected static void getCameraInfo(int cameraId, Camera.CameraInfo cameraInfo) {
        Camera.CameraInfo foundCam = cameras.get(cameraId);
        cameraInfo.facing = foundCam.facing;
        cameraInfo.orientation = foundCam.orientation;
        if (Build.VERSION.SDK_INT >= 17) {
            cameraInfo.canDisableShutterSound = foundCam.canDisableShutterSound;
        }
    }

    @Implementation
    protected static int getNumberOfCameras() {
        return cameras.size();
    }

    @Implementation
    protected void takePicture(Camera.ShutterCallback shutter, Camera.PictureCallback raw, Camera.PictureCallback jpeg) {
        if (shutter != null) {
            shutter.onShutter();
        }
        if (raw != null) {
            raw.onPictureTaken(new byte[0], this.realCamera);
        }
        if (jpeg != null) {
            jpeg.onPictureTaken(new byte[0], this.realCamera);
        }
    }

    @Implementation(minSdk=17)
    protected boolean enableShutterSound(boolean enabled) {
        if (!enabled && cameras.containsKey(this.id) && !ShadowCamera.cameras.get((Object)Integer.valueOf((int)this.id)).canDisableShutterSound) {
            return false;
        }
        this.shutterSoundEnabled = enabled;
        return true;
    }

    public boolean isShutterSoundEnabled() {
        return this.shutterSoundEnabled;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isPreviewing() {
        return this.previewing;
    }

    public boolean isReleased() {
        return this.released;
    }

    public SurfaceHolder getPreviewDisplay() {
        return this.surfaceHolder;
    }

    public static void addCameraInfo(int id2, Camera.CameraInfo camInfo) {
        cameras.put(id2, camInfo);
    }

    public static void clearCameraInfo() {
        cameras.clear();
    }

    static {
        cameras = new HashMap<Integer, Camera.CameraInfo>();
    }

    @Implements(value=Camera.Size.class)
    public static class ShadowSize {
        @RealObject
        private Camera.Size realCameraSize;

        @Implementation
        protected void __constructor__(Camera camera, int width, int height) {
            this.realCameraSize.width = width;
            this.realCameraSize.height = height;
        }
    }

    @Implements(value=Camera.Parameters.class)
    public static class ShadowParameters {
        private int pictureWidth = 1280;
        private int pictureHeight = 960;
        private int previewWidth = 640;
        private int previewHeight = 480;
        private int previewFormat = 17;
        private int previewFpsMin = 10;
        private int previewFpsMax = 30;
        private int previewFps = 30;
        private int exposureCompensation = 0;
        private String flashMode;
        private String focusMode;
        private List<String> supportedFlashModes = new ArrayList<String>();
        private List<String> supportedFocusModes = new ArrayList<String>();
        private int maxNumFocusAreas;
        private List<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
        private int maxNumMeteringAreas;
        private List<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
        private final Map<String, String> paramsMap = new HashMap<String, String>();
        private static List<Camera.Size> supportedPreviewSizes;

        public void initSupportedPreviewSizes() {
            supportedPreviewSizes = new ArrayList<Camera.Size>();
        }

        public void addSupportedPreviewSize(int width, int height) {
            Camera camera = (Camera)ReflectionHelpers.newInstance(Camera.class);
            Objects.requireNonNull(camera);
            Camera.Size newSize = new Camera.Size(camera, width, height);
            supportedPreviewSizes.add(newSize);
        }

        @Implementation
        protected Camera.Size getPictureSize() {
            Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
            Objects.requireNonNull(camera);
            Camera.Size pictureSize = new Camera.Size(camera, 0, 0);
            pictureSize.width = this.pictureWidth;
            pictureSize.height = this.pictureHeight;
            return pictureSize;
        }

        @Implementation
        protected int getPreviewFormat() {
            return this.previewFormat;
        }

        @Implementation
        protected void getPreviewFpsRange(int[] range) {
            range[0] = this.previewFpsMin;
            range[1] = this.previewFpsMax;
        }

        @Implementation
        protected int getPreviewFrameRate() {
            return this.previewFps;
        }

        @Implementation
        protected Camera.Size getPreviewSize() {
            Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
            Objects.requireNonNull(camera);
            Camera.Size previewSize = new Camera.Size(camera, 0, 0);
            previewSize.width = this.previewWidth;
            previewSize.height = this.previewHeight;
            return previewSize;
        }

        @Implementation
        protected List<Camera.Size> getSupportedPictureSizes() {
            ArrayList<Camera.Size> supportedSizes = new ArrayList<Camera.Size>();
            this.addSize(supportedSizes, 320, 240);
            this.addSize(supportedSizes, 640, 480);
            this.addSize(supportedSizes, 800, 600);
            return supportedSizes;
        }

        @Implementation
        protected List<Integer> getSupportedPictureFormats() {
            ArrayList<Integer> formats = new ArrayList<Integer>();
            formats.add(17);
            formats.add(256);
            return formats;
        }

        @Implementation
        protected List<Integer> getSupportedPreviewFormats() {
            ArrayList<Integer> formats = new ArrayList<Integer>();
            formats.add(17);
            formats.add(256);
            return formats;
        }

        @Implementation
        protected List<int[]> getSupportedPreviewFpsRange() {
            ArrayList<int[]> supportedRanges = new ArrayList<int[]>();
            this.addRange(supportedRanges, 15000, 15000);
            this.addRange(supportedRanges, 10000, 30000);
            return supportedRanges;
        }

        @Implementation
        protected List<Integer> getSupportedPreviewFrameRates() {
            ArrayList<Integer> supportedRates = new ArrayList<Integer>();
            supportedRates.add(10);
            supportedRates.add(15);
            supportedRates.add(30);
            return supportedRates;
        }

        @Implementation
        protected List<Camera.Size> getSupportedPreviewSizes() {
            if (supportedPreviewSizes == null) {
                this.initSupportedPreviewSizes();
                this.addSupportedPreviewSize(320, 240);
                this.addSupportedPreviewSize(640, 480);
            }
            return supportedPreviewSizes;
        }

        public void setSupportedFocusModes(String ... focusModes) {
            this.supportedFocusModes = Arrays.asList(focusModes);
        }

        @Implementation
        protected List<String> getSupportedFocusModes() {
            return this.supportedFocusModes;
        }

        @Implementation
        protected String getFocusMode() {
            return this.focusMode;
        }

        @Implementation
        protected void setFocusMode(String focusMode) {
            this.focusMode = focusMode;
        }

        public void setMaxNumFocusAreas(int maxNumFocusAreas) {
            this.maxNumFocusAreas = maxNumFocusAreas;
        }

        @Implementation
        protected int getMaxNumFocusAreas() {
            return this.maxNumFocusAreas;
        }

        @Implementation
        protected void setFocusAreas(List<Camera.Area> focusAreas) {
            this.focusAreas = focusAreas;
        }

        @Implementation
        protected List<Camera.Area> getFocusAreas() {
            return this.focusAreas;
        }

        public void setMaxNumMeteringAreas(int maxNumMeteringAreas) {
            this.maxNumMeteringAreas = maxNumMeteringAreas;
        }

        @Implementation
        protected int getMaxNumMeteringAreas() {
            return this.maxNumMeteringAreas;
        }

        @Implementation
        protected void setMeteringAreas(List<Camera.Area> meteringAreas) {
            this.meteringAreas = meteringAreas;
        }

        @Implementation
        protected List<Camera.Area> getMeteringAreas() {
            return this.meteringAreas;
        }

        @Implementation
        protected void setPictureSize(int width, int height) {
            this.pictureWidth = width;
            this.pictureHeight = height;
        }

        @Implementation
        protected void setPreviewFormat(int pixel_format) {
            this.previewFormat = pixel_format;
        }

        @Implementation
        protected void setPreviewFpsRange(int min, int max) {
            this.previewFpsMin = min;
            this.previewFpsMax = max;
        }

        @Implementation
        protected void setPreviewFrameRate(int fps) {
            this.previewFps = fps;
        }

        @Implementation
        protected void setPreviewSize(int width, int height) {
            this.previewWidth = width;
            this.previewHeight = height;
        }

        @Implementation
        protected void setRecordingHint(boolean recordingHint) {
        }

        @Implementation
        protected void setRotation(int rotation) {
        }

        @Implementation
        protected int getMinExposureCompensation() {
            return -6;
        }

        @Implementation
        protected int getMaxExposureCompensation() {
            return 6;
        }

        @Implementation
        protected float getExposureCompensationStep() {
            return 0.5f;
        }

        @Implementation
        protected int getExposureCompensation() {
            return this.exposureCompensation;
        }

        @Implementation
        protected void setExposureCompensation(int compensation) {
            this.exposureCompensation = compensation;
        }

        public void setSupportedFlashModes(String ... flashModes) {
            this.supportedFlashModes = Arrays.asList(flashModes);
        }

        @Implementation
        protected List<String> getSupportedFlashModes() {
            return this.supportedFlashModes;
        }

        @Implementation
        protected String getFlashMode() {
            return this.flashMode;
        }

        @Implementation
        protected void setFlashMode(String flashMode) {
            this.flashMode = flashMode;
        }

        @Implementation
        protected void set(String key, String value) {
            this.paramsMap.put(key, value);
        }

        @Implementation
        protected String get(String key) {
            return this.paramsMap.get(key);
        }

        public int getPreviewWidth() {
            return this.previewWidth;
        }

        public int getPreviewHeight() {
            return this.previewHeight;
        }

        public int getPictureWidth() {
            return this.pictureWidth;
        }

        public int getPictureHeight() {
            return this.pictureHeight;
        }

        private void addSize(List<Camera.Size> sizes, int width, int height) {
            Camera camera = (Camera)Shadow.newInstanceOf(Camera.class);
            Objects.requireNonNull(camera);
            Camera.Size newSize = new Camera.Size(camera, 0, 0);
            newSize.width = width;
            newSize.height = height;
            sizes.add(newSize);
        }

        private void addRange(List<int[]> ranges, int min, int max) {
            int[] range = new int[]{min, max};
            ranges.add(range);
        }
    }
}

