/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.role.RoleManager;
import android.util.ArraySet;
import androidx.annotation.NonNull;
import com.android.internal.util.Preconditions;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;

@Implements(value=RoleManager.class, minSdk=29)
public class ShadowRoleManager {
    @RealObject
    protected RoleManager roleManager;
    private final Set<String> heldRoles = new ArraySet();
    private final Set<String> availableRoles = new ArraySet();

    @Implementation
    protected boolean isRoleHeld(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        return this.heldRoles.contains(roleName);
    }

    public void addHeldRole(@NonNull String roleName) {
        this.heldRoles.add(roleName);
    }

    public void removeHeldRole(@NonNull String roleName) {
        Preconditions.checkArgument((boolean)this.heldRoles.contains(roleName), (Object)"the supplied roleName was never added.");
        this.heldRoles.remove(roleName);
    }

    @Implementation
    protected boolean isRoleAvailable(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        return this.availableRoles.contains(roleName);
    }

    public void addAvailableRole(@NonNull String roleName) {
        Preconditions.checkStringNotEmpty((CharSequence)roleName, (Object)"roleName cannot be null or empty");
        this.availableRoles.add(roleName);
    }

    public void removeAvailableRole(@NonNull String roleName) {
        Preconditions.checkArgument((boolean)this.availableRoles.contains(roleName), (Object)"the supplied roleName was never added.");
        this.availableRoles.remove(roleName);
    }
}

