/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.UiAutomation;
import android.content.ContentResolver;
import android.content.res.Resources;
import android.provider.Settings;
import android.view.Display;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowDisplay;
import org.robolectric.shadows.ShadowDisplayManager;

@Implements(value=UiAutomation.class, minSdk=18)
public class ShadowUiAutomation {
    public static void setAnimationScaleCompat(float scale) {
        ContentResolver cr = RuntimeEnvironment.getApplication().getContentResolver();
        if (RuntimeEnvironment.getApiLevel() >= 17) {
            Settings.Global.putFloat((ContentResolver)cr, (String)"animator_duration_scale", (float)scale);
            Settings.Global.putFloat((ContentResolver)cr, (String)"transition_animation_scale", (float)scale);
            Settings.Global.putFloat((ContentResolver)cr, (String)"window_animation_scale", (float)scale);
        } else {
            Settings.System.putFloat((ContentResolver)cr, (String)"animator_duration_scale", (float)scale);
            Settings.System.putFloat((ContentResolver)cr, (String)"transition_animation_scale", (float)scale);
            Settings.System.putFloat((ContentResolver)cr, (String)"window_animation_scale", (float)scale);
        }
    }

    @Implementation(minSdk=33)
    protected void setAnimationScale(float scale) {
        ShadowUiAutomation.setAnimationScaleCompat(scale);
    }

    @Implementation
    protected boolean setRotation(int rotation) {
        if (rotation == -1 || rotation == -2) {
            return true;
        }
        Display display = ShadowDisplay.getDefaultDisplay();
        int currentRotation = display.getRotation();
        boolean isRotated = (rotation == 0 || rotation == 2) != (currentRotation == 0 || currentRotation == 2);
        Shadows.shadowOf(display).setRotation(rotation);
        if (isRotated) {
            int currentOrientation = Resources.getSystem().getConfiguration().orientation;
            String rotationQualifier = "+" + (currentOrientation == 1 ? "land" : "port");
            ShadowDisplayManager.changeDisplay(display.getDisplayId(), rotationQualifier);
            RuntimeEnvironment.setQualifiers(rotationQualifier);
        }
        return true;
    }

    @Implementation
    protected void throwIfNotConnectedLocked() {
    }
}

