/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioAttributes;
import android.os.VibrationAttributes;
import android.os.Vibrator;
import android.os.vibrator.VibrationEffectSegment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=Vibrator.class)
public class ShadowVibrator {
    boolean vibrating;
    boolean cancelled;
    long milliseconds;
    protected long[] pattern;
    protected final List<VibrationEffectSegment> vibrationEffectSegments = new ArrayList<VibrationEffectSegment>();
    protected final List<PrimitiveEffect> primitiveEffects = new ArrayList<PrimitiveEffect>();
    protected final List<Integer> supportedPrimitives = new ArrayList<Integer>();
    @Nullable
    protected VibrationAttributes vibrationAttributesFromLastVibration;
    @Nullable
    protected AudioAttributes audioAttributesFromLastVibration;
    int repeat;
    boolean hasVibrator = true;
    boolean hasAmplitudeControl = false;
    int effectId;

    public void setHasVibrator(boolean hasVibrator) {
        this.hasVibrator = hasVibrator;
    }

    public void setHasAmplitudeControl(boolean hasAmplitudeControl) {
        this.hasAmplitudeControl = hasAmplitudeControl;
    }

    @Implementation(minSdk=30)
    public boolean isVibrating() {
        return this.vibrating;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public long[] getPattern() {
        return this.pattern;
    }

    public int getEffectId() {
        return this.effectId;
    }

    public int getRepeat() {
        return this.repeat;
    }

    public List<VibrationEffectSegment> getVibrationEffectSegments() {
        return this.vibrationEffectSegments;
    }

    @Nullable
    public List<PrimitiveEffect> getPrimitiveEffects() {
        return this.primitiveEffects;
    }

    @Implementation(minSdk=30)
    protected boolean areAllPrimitivesSupported(int ... primitiveIds) {
        for (int i = 0; i < primitiveIds.length; ++i) {
            if (this.supportedPrimitives.contains(primitiveIds[i])) continue;
            return false;
        }
        return true;
    }

    public void setSupportedPrimitives(Collection<Integer> primitives) {
        this.supportedPrimitives.clear();
        this.supportedPrimitives.addAll(primitives);
    }

    @Nullable
    public VibrationAttributes getVibrationAttributesFromLastVibration() {
        return this.vibrationAttributesFromLastVibration;
    }

    @Nullable
    public AudioAttributes getAudioAttributesFromLastVibration() {
        return this.audioAttributesFromLastVibration;
    }

    public static class PrimitiveEffect {
        public final int id;
        public final float scale;
        public final int delay;

        public PrimitiveEffect(int id2, float scale, int delay) {
            this.id = id2;
            this.scale = scale;
            this.delay = delay;
        }

        public String toString() {
            return "PrimitiveEffect{id=" + this.id + ", scale=" + this.scale + ", delay=" + this.delay + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !this.getClass().isInstance(o)) {
                return false;
            }
            PrimitiveEffect that = (PrimitiveEffect)o;
            return this.id == that.id && Float.compare(that.scale, this.scale) == 0 && this.delay == that.delay;
        }

        public int hashCode() {
            return Objects.hash(this.id, Float.valueOf(this.scale), this.delay);
        }
    }
}

