/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.os.Bundle;
import android.service.voice.VoiceInteractionService;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowService;

@Implements(value=VoiceInteractionService.class, minSdk=21)
public class ShadowVoiceInteractionService
extends ShadowService {
    @Nullable
    private static ComponentName activeService = null;
    private final List<Bundle> hintBundles = Collections.synchronizedList(new ArrayList());
    private final List<Bundle> sessionBundles = Collections.synchronizedList(new ArrayList());
    private boolean isReady = false;

    public static void setActiveService(@Nullable ComponentName activeService) {
        ShadowVoiceInteractionService.activeService = activeService;
    }

    @Implementation
    protected void onReady() {
        this.isReady = true;
    }

    @Implementation(minSdk=29)
    protected void setUiHints(Bundle hints) {
        if (!this.isReady) {
            throw new NullPointerException("setUiHints() called before onReady() callback for VoiceInteractionService!");
        }
        if (hints != null) {
            this.hintBundles.add(hints);
        }
    }

    @Implementation(minSdk=23)
    protected void showSession(Bundle args, int flags) {
        if (!this.isReady) {
            throw new NullPointerException("showSession() called before onReady() callback for VoiceInteractionService!");
        }
        if (args != null) {
            this.sessionBundles.add(args);
        }
    }

    @Implementation
    protected static boolean isActiveService(Context context, ComponentName componentName) {
        return componentName.equals((Object)activeService);
    }

    public List<Bundle> getPreviousUiHintBundles() {
        return Collections.unmodifiableList(this.hintBundles);
    }

    @Nullable
    public Bundle getLastUiHintBundle() {
        if (this.hintBundles.isEmpty()) {
            return null;
        }
        return this.hintBundles.get(this.hintBundles.size() - 1);
    }

    @Nullable
    public Bundle getLastSessionBundle() {
        return (Bundle)Iterables.getLast(this.sessionBundles, null);
    }

    @Resetter
    public static void reset() {
        activeService = null;
    }
}

