/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Strftime {
    public static String format(String format, Date date, Locale locale, TimeZone zone) {
        StringBuilder buffer = new StringBuilder();
        class Formatter {
            SimpleDateFormat formatter;
            final /* synthetic */ Date val$date;

            public Formatter(Date locale, Locale timeZone, TimeZone timeZone2) {
                this.val$date = timeZone2;
                this.formatter = locale != null ? new SimpleDateFormat("", (Locale)((Object)locale)) : new SimpleDateFormat("");
                if (timeZone != null) {
                    this.formatter.setTimeZone((TimeZone)((Object)timeZone));
                }
            }

            public String format(String format) {
                this.formatter.applyPattern(format);
                return this.formatter.format(this.val$date);
            }
        }
        Formatter formatter = new Formatter(date, locale, zone, date);
        Boolean inside = false;
        Boolean removePad = false;
        Boolean zeroPad = false;
        Boolean spacePad = false;
        Boolean upperCase = false;
        Boolean swapCase = false;
        StringBuilder padWidthBuffer = new StringBuilder();
        for (int i = 0; i < format.length(); ++i) {
            Character c = Character.valueOf(format.charAt(i));
            if (!inside.booleanValue() && c.charValue() == '%') {
                inside = true;
                removePad = false;
                zeroPad = false;
                spacePad = false;
                upperCase = false;
                swapCase = false;
                padWidthBuffer = new StringBuilder();
                continue;
            }
            if (inside.booleanValue()) {
                inside = false;
                switch (c.charValue()) {
                    case 'a': {
                        buffer.append(Strftime.correctCase(formatter.format("EEE"), upperCase, swapCase));
                        break;
                    }
                    case 'A': {
                        buffer.append(Strftime.correctCase(formatter.format("EEEE"), upperCase, swapCase));
                        break;
                    }
                    case 'b': {
                        buffer.append(Strftime.correctCase(formatter.format("MMM"), upperCase, swapCase));
                        break;
                    }
                    case 'B': {
                        buffer.append(Strftime.correctCase(formatter.format("MMMM"), upperCase, swapCase));
                        break;
                    }
                    case 'c': {
                        buffer.append(formatter.format("EEE dd MMM yyyy hh:mm:ss aa z"));
                        break;
                    }
                    case 'C': {
                        buffer.append(formatter.format("y").substring(0, 2));
                        break;
                    }
                    case 'd': {
                        buffer.append(formatter.format("dd"));
                        break;
                    }
                    case 'D': {
                        buffer.append(formatter.format("MM/dd/yy"));
                        break;
                    }
                    case 'e': {
                        buffer.append(Strftime.correctPad(formatter.format("dd"), zeroPad, true, removePad, padWidthBuffer.length() <= 0 ? new StringBuilder("2") : padWidthBuffer));
                        break;
                    }
                    case 'E': {
                        inside = true;
                        throw new UnsupportedOperationException("Not implemented yet");
                    }
                    case 'F': {
                        buffer.append(formatter.format("yyyy-MM-dd"));
                        break;
                    }
                    case 'g': {
                        buffer.append(formatter.format("YY"));
                        break;
                    }
                    case 'G': {
                        buffer.append(formatter.format("YYYY"));
                        break;
                    }
                    case 'h': {
                        buffer.append(formatter.format("MMM"));
                        break;
                    }
                    case 'H': {
                        buffer.append(formatter.format("HH"));
                        break;
                    }
                    case 'I': {
                        buffer.append(formatter.format("hh"));
                        break;
                    }
                    case 'j': {
                        buffer.append(formatter.format("DDD"));
                        break;
                    }
                    case 'k': {
                        buffer.append(Strftime.correctPad(formatter.format("HH"), zeroPad, spacePad, removePad, padWidthBuffer.length() <= 0 ? new StringBuilder("2") : padWidthBuffer));
                        break;
                    }
                    case 'l': {
                        buffer.append(Strftime.correctPad(formatter.format("hh"), zeroPad, spacePad != false || zeroPad == false, removePad, padWidthBuffer.length() <= 0 ? new StringBuilder("2") : padWidthBuffer));
                        break;
                    }
                    case 'm': {
                        buffer.append(Strftime.correctPad(formatter.format("MM"), zeroPad, spacePad, removePad, padWidthBuffer.length() <= 0 ? new StringBuilder("2") : padWidthBuffer));
                        break;
                    }
                    case 'M': {
                        buffer.append(Strftime.correctCase(formatter.format("mm"), upperCase, swapCase));
                        break;
                    }
                    case 'n': {
                        buffer.append(formatter.format("\n"));
                        break;
                    }
                    case 'O': {
                        inside = true;
                        throw new UnsupportedOperationException("Not implemented yet");
                    }
                    case 'p': {
                        buffer.append(Strftime.correctCase(formatter.format("a"), upperCase, swapCase));
                        break;
                    }
                    case 'P': {
                        buffer.append(Strftime.correctCase(formatter.format("a").toLowerCase(), upperCase, swapCase));
                        break;
                    }
                    case 'r': {
                        buffer.append(formatter.format("hh:mm:ss a"));
                        break;
                    }
                    case 'R': {
                        buffer.append(formatter.format("HH:mm"));
                        break;
                    }
                    case 's': {
                        buffer.append(Long.valueOf(date.getTime() / 1000L).toString());
                        break;
                    }
                    case 'S': {
                        buffer.append(formatter.format("ss"));
                        break;
                    }
                    case 't': {
                        buffer.append(formatter.format("\t"));
                        break;
                    }
                    case 'T': {
                        buffer.append(formatter.format("HH:mm:ss"));
                        break;
                    }
                    case 'u': {
                        buffer.append(formatter.format("u"));
                        break;
                    }
                    case 'U': {
                        throw new UnsupportedOperationException("Not implemented yet");
                    }
                    case 'V': {
                        buffer.append(formatter.format("ww"));
                        break;
                    }
                    case 'w': {
                        String dayNumberOfWeek = formatter.format("u");
                        buffer.append(dayNumberOfWeek.equals("7") ? "0" : dayNumberOfWeek);
                        break;
                    }
                    case 'W': {
                        throw new UnsupportedOperationException("Not implemented yet");
                    }
                    case 'x': {
                        buffer.append(formatter.format("MM/dd/yyyy"));
                        break;
                    }
                    case 'X': {
                        buffer.append(formatter.format("hh:mm:ss aa"));
                        break;
                    }
                    case 'y': {
                        buffer.append(formatter.format("yy"));
                        break;
                    }
                    case 'Y': {
                        buffer.append(formatter.format("yyyy"));
                        break;
                    }
                    case 'z': {
                        buffer.append(formatter.format("Z"));
                        break;
                    }
                    case 'Z': {
                        buffer.append(formatter.format("z"));
                        break;
                    }
                    case '%': {
                        buffer.append(formatter.format("%"));
                        break;
                    }
                    case '^': {
                        inside = true;
                        upperCase = true;
                        break;
                    }
                    case '#': {
                        inside = true;
                        swapCase = true;
                        break;
                    }
                    case '-': {
                        inside = true;
                        removePad = true;
                        break;
                    }
                    case '_': {
                        inside = true;
                        spacePad = true;
                        break;
                    }
                    case '0': {
                        inside = true;
                        if (padWidthBuffer.length() == 0) {
                            zeroPad = true;
                            spacePad = false;
                            break;
                        }
                        padWidthBuffer.append(c);
                        break;
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        inside = true;
                        padWidthBuffer.append(c);
                        break;
                    }
                    default: {
                        buffer.append(c.toString());
                        break;
                    }
                }
                continue;
            }
            buffer.append(c.toString());
        }
        return buffer.toString();
    }

    private static String correctCase(String simple, Boolean upperCase, Boolean swapCase) {
        if (upperCase.booleanValue()) {
            return simple.toUpperCase();
        }
        if (!swapCase.booleanValue()) {
            return simple;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < simple.length(); ++i) {
            Character c = Character.valueOf(simple.charAt(i));
            buffer.append(Character.isLowerCase(c.charValue()) ? Character.toUpperCase(c.charValue()) : Character.toLowerCase(c.charValue()));
        }
        return buffer.toString();
    }

    private static String correctPad(String simple, Boolean zeroPad, Boolean spacePad, Boolean removePad, StringBuilder padWidthBuffer) {
        String unpadded = simple.replaceFirst("^(0+| +)(?!$)", "");
        if (removePad.booleanValue()) {
            return unpadded;
        }
        int padWidth = 0;
        if (padWidthBuffer.length() > 0) {
            padWidth = Integer.parseInt(padWidthBuffer.toString()) - unpadded.length();
        }
        if (spacePad.booleanValue() || zeroPad.booleanValue()) {
            StringBuilder buffer = new StringBuilder();
            char padChar = spacePad != false ? (char)' ' : '0';
            for (int i = 0; i < padWidth; ++i) {
                buffer.append(padChar);
            }
            buffer.append(unpadded);
            return buffer.toString();
        }
        return simple;
    }
}

