/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.pluginapi.perf.Metadata;
import org.robolectric.pluginapi.perf.Metric;
import org.robolectric.util.Clock;

public class PerfStatsCollector {
    private static final PerfStatsCollector INSTANCE = new PerfStatsCollector();
    private final Clock clock;
    private final Map<Class<?>, Object> metadata = new HashMap();
    private final Map<MetricKey, Metric> metricMap = new HashMap<MetricKey, Metric>();
    private boolean enabled = true;

    public PerfStatsCollector() {
        this(System::nanoTime);
    }

    PerfStatsCollector(Clock clock) {
        this.clock = clock;
    }

    public static PerfStatsCollector getInstance() {
        return INSTANCE;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public Event startEvent(String eventName) {
        return new Event(eventName);
    }

    public <T, E extends Exception> T measure(String eventName, ThrowingSupplier<T, E> supplier) throws E {
        boolean success = true;
        Event event = this.startEvent(eventName);
        try {
            T t = supplier.get();
            return t;
        }
        catch (Exception e) {
            success = false;
            throw e;
        }
        finally {
            event.finished(success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementCount(String eventName) {
        PerfStatsCollector perfStatsCollector = this;
        synchronized (perfStatsCollector) {
            MetricKey key = new MetricKey(eventName, true);
            Metric metric = this.metricMap.get(key);
            if (metric == null) {
                metric = new Metric(key.name, key.success);
                this.metricMap.put(key, metric);
            }
            metric.incrementCount();
        }
    }

    public <E extends Exception> void measure(String eventName, ThrowingRunnable<E> runnable) throws E {
        boolean success = true;
        Event event = this.startEvent(eventName);
        try {
            runnable.run();
        }
        catch (Exception e) {
            success = false;
            throw e;
        }
        finally {
            event.finished(success);
        }
    }

    public synchronized Collection<Metric> getMetrics() {
        return new ArrayList<Metric>(this.metricMap.values());
    }

    public synchronized <T> void putMetadata(Class<T> metadataClass, T metadata) {
        if (!this.enabled) {
            return;
        }
        this.metadata.put(metadataClass, metadata);
    }

    public synchronized Metadata getMetadata() {
        return new Metadata(this.metadata);
    }

    public void reset() {
        this.metadata.clear();
        this.metricMap.clear();
    }

    private static class MetricKey {
        private final String name;
        private final boolean success;

        MetricKey(String name, boolean success) {
            this.name = name;
            this.success = success;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MetricKey)) {
                return false;
            }
            MetricKey metricKey = (MetricKey)o;
            if (this.success != metricKey.success) {
                return false;
            }
            return this.name != null ? this.name.equals(metricKey.name) : metricKey.name == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.success ? 1 : 0);
            return result;
        }
    }

    public class Event {
        private final String name;
        private final long startTimeNs;

        Event(String name) {
            this.name = name;
            this.startTimeNs = PerfStatsCollector.this.clock.nanoTime();
        }

        public void finished() {
            this.finished(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished(boolean success) {
            if (!PerfStatsCollector.this.enabled) {
                return;
            }
            PerfStatsCollector perfStatsCollector = PerfStatsCollector.this;
            synchronized (perfStatsCollector) {
                MetricKey key = new MetricKey(this.name, success);
                Metric metric = (Metric)PerfStatsCollector.this.metricMap.get(key);
                if (metric == null) {
                    metric = new Metric(key.name, key.success);
                    PerfStatsCollector.this.metricMap.put(key, metric);
                }
                metric.record(PerfStatsCollector.this.clock.nanoTime() - this.startTimeNs);
            }
        }
    }

    public static interface ThrowingRunnable<F extends Exception> {
        public void run() throws F;
    }

    public static interface ThrowingSupplier<T, F extends Exception> {
        public T get() throws F;
    }
}

