/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import android.os.RemoteException;
import com.android.vending.billing.IInAppBillingService;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.Purchases;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestType;

abstract class BasePurchasesRequest
extends Request<Purchases> {
    @Nonnull
    protected final String mProduct;
    @Nullable
    protected final String mContinuationToken;

    protected BasePurchasesRequest(@Nonnull RequestType type, int apiVersion, @Nonnull String product, @Nullable String continuationToken) {
        super(type, apiVersion);
        this.mProduct = product;
        this.mContinuationToken = continuationToken;
    }

    protected BasePurchasesRequest(@Nonnull BasePurchasesRequest request, @Nonnull String continuationToken) {
        super(request);
        this.mProduct = request.mProduct;
        this.mContinuationToken = continuationToken;
    }

    @Nonnull
    String getProduct() {
        return this.mProduct;
    }

    @Nullable
    String getContinuationToken() {
        return this.mContinuationToken;
    }

    @Override
    final void start(@Nonnull IInAppBillingService service, @Nonnull String packageName) throws RemoteException {
        Bundle bundle = this.request(service, packageName);
        if (this.handleError(bundle)) {
            return;
        }
        try {
            String continuationToken = Purchases.getContinuationTokenFromBundle(bundle);
            List<Purchase> purchases = Purchases.getListFromBundle(bundle);
            if (purchases.isEmpty()) {
                this.onSuccess(new Purchases(this.mProduct, purchases, continuationToken));
                return;
            }
            this.processPurchases(purchases, continuationToken);
        }
        catch (JSONException e) {
            this.onError((Exception)((Object)e));
        }
    }

    @Nullable
    protected abstract Bundle request(@Nonnull IInAppBillingService var1, @Nonnull String var2) throws RemoteException;

    protected abstract void processPurchases(@Nonnull List<Purchase> var1, @Nullable String var2);

    @Override
    @Nullable
    protected String getCacheKey() {
        if (this.mContinuationToken != null) {
            return this.mProduct + "_" + this.mContinuationToken;
        }
        return this.mProduct;
    }
}

