/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.app.Service;
import android.content.Context;
import java.util.HashSet;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.solovyev.android.checkout.ActivityCheckout;
import org.solovyev.android.checkout.BaseInventory;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.BillingRequests;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.CheckoutInventory;
import org.solovyev.android.checkout.CustomUiCheckout;
import org.solovyev.android.checkout.FallingBackInventory;
import org.solovyev.android.checkout.FragmentCheckout;
import org.solovyev.android.checkout.IntentStarter;
import org.solovyev.android.checkout.Inventory;
import org.solovyev.android.checkout.ProductTypes;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.UiCheckout;

public class Checkout {
    @Nullable
    private final Object mTag;
    @Nonnull
    protected final Billing mBilling;
    @Nonnull
    final Object mLock = new Object();
    @Nonnull
    private final OnLoadExecutor mOnLoadExecutor = new OnLoadExecutor();
    @GuardedBy(value="mLock")
    private Billing.Requests mRequests;
    @Nonnull
    @GuardedBy(value="mLock")
    private State mState = State.INITIAL;

    Checkout(@Nullable Object tag, @Nonnull Billing billing) {
        this.mTag = tag;
        this.mBilling = billing;
    }

    @Nonnull
    public static UiCheckout forUi(@Nonnull IntentStarter intentStarter, @Nonnull Object tag, @Nonnull Billing billing) {
        return new CustomUiCheckout(intentStarter, tag, billing);
    }

    @Nonnull
    @TargetApi(value=24)
    public static UiCheckout forFragment(@Nonnull Fragment fragment, @Nonnull Billing billing) {
        return new FragmentCheckout(fragment, billing);
    }

    @Nonnull
    public static ActivityCheckout forActivity(@Nonnull Activity activity, @Nonnull Billing billing) {
        return new ActivityCheckout(activity, billing);
    }

    @Nonnull
    public static Checkout forService(@Nonnull Service service, @Nonnull Billing billing) {
        return new Checkout(service, billing);
    }

    @Nonnull
    public static Checkout forApplication(@Nonnull Billing billing) {
        return new Checkout(null, billing);
    }

    @Nonnull
    Context getContext() {
        return this.mBilling.getContext();
    }

    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Nullable Listener listener) {
        Check.isMainThread();
        Object object = this.mLock;
        synchronized (object) {
            Check.isFalse(this.mState == State.STARTED, "Already started");
            Check.isNull(this.mRequests, "Already started");
            this.mState = State.STARTED;
            this.mBilling.onCheckoutStarted();
            this.mRequests = this.mBilling.getRequests(this.mTag);
        }
        this.whenReady(listener == null ? new EmptyListener(){} : listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whenReady(final @Nonnull Listener listener) {
        Check.isMainThread();
        Object object = this.mLock;
        synchronized (object) {
            Check.isNotNull(this.mRequests);
            final Billing.Requests requests = this.mRequests;
            final HashSet<String> loadingProducts = new HashSet<String>(ProductTypes.ALL);
            for (final String product : ProductTypes.ALL) {
                requests.isBillingSupported(product, new RequestListener<Object>(){

                    private void onBillingSupported(boolean supported) {
                        listener.onReady(requests, product, supported);
                        loadingProducts.remove(product);
                        if (loadingProducts.isEmpty()) {
                            listener.onReady(requests);
                        }
                    }

                    @Override
                    public void onSuccess(@Nonnull Object result) {
                        this.onBillingSupported(true);
                    }

                    @Override
                    public void onError(int response, @Nonnull Exception e) {
                        this.onBillingSupported(false);
                    }
                });
            }
        }
    }

    private void checkIsNotStopped() {
        Check.isFalse(this.mState == State.STOPPED, "Checkout is stopped");
    }

    @Nonnull
    public Inventory loadInventory(@Nonnull Inventory.Request request, @Nonnull Inventory.Callback callback) {
        Inventory inventory = this.makeInventory();
        inventory.load(request, callback);
        return inventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Inventory makeInventory() {
        Check.isMainThread();
        Object object = this.mLock;
        synchronized (object) {
            this.checkIsNotStopped();
        }
        Inventory fallbackInventory = this.mBilling.getConfiguration().getFallbackInventory(this, this.mOnLoadExecutor);
        BaseInventory inventory = fallbackInventory == null ? new CheckoutInventory(this) : new FallingBackInventory(this, fallbackInventory);
        return inventory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Check.isMainThread();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != State.INITIAL) {
                this.mState = State.STOPPED;
            }
            if (this.mRequests != null) {
                this.mRequests.cancelAll();
                this.mRequests = null;
            }
            if (this.mState == State.STOPPED) {
                this.mBilling.onCheckoutStopped();
            }
        }
    }

    private final class OnLoadExecutor
    implements Executor {
        private OnLoadExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            Executor executor;
            Object object = Checkout.this.mLock;
            synchronized (object) {
                executor = Checkout.this.mRequests != null ? Checkout.this.mRequests.getDeliveryExecutor() : null;
            }
            if (executor != null) {
                executor.execute(command);
            } else {
                Billing.error("Trying to deliver result on a stopped checkout.");
            }
        }
    }

    public static abstract class EmptyListener
    implements Listener {
        @Override
        public void onReady(@Nonnull BillingRequests requests) {
        }

        @Override
        public void onReady(@Nonnull BillingRequests requests, @Nonnull String product, boolean billingSupported) {
        }
    }

    public static interface Listener {
        public void onReady(@Nonnull BillingRequests var1);

        public void onReady(@Nonnull BillingRequests var1, @Nonnull String var2, boolean var3);
    }

    private static enum State {
        INITIAL,
        STARTED,
        STOPPED;

    }
}

