/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.Cache;

@ThreadSafe
final class ConcurrentCache
implements Cache {
    @Nonnull
    private static final String TAG = "Cache";
    @Nullable
    @GuardedBy(value="this")
    private final Cache mCache;

    ConcurrentCache(@Nullable Cache cache) {
        this.mCache = cache;
    }

    public boolean hasCache() {
        return this.mCache != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Cache.Entry get(@Nonnull Cache.Key key) {
        if (this.mCache == null) {
            return null;
        }
        ConcurrentCache concurrentCache = this;
        synchronized (concurrentCache) {
            Cache.Entry entry = this.mCache.get(key);
            if (entry == null) {
                Billing.debug(TAG, "Key=" + key + " is not in the cache");
                return null;
            }
            long now = System.currentTimeMillis();
            if (now >= entry.expiresAt) {
                Billing.debug(TAG, "Key=" + key + " is in the cache but was expired at " + entry.expiresAt + ", now is " + now);
                this.mCache.remove(key);
                return null;
            }
            Billing.debug(TAG, "Key=" + key + " is in the cache");
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@Nonnull Cache.Key key, @Nonnull Cache.Entry entry) {
        if (this.mCache == null) {
            return;
        }
        ConcurrentCache concurrentCache = this;
        synchronized (concurrentCache) {
            Billing.debug(TAG, "Adding entry with key=" + key + " to the cache");
            this.mCache.put(key, entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIfNotExist(@Nonnull Cache.Key key, @Nonnull Cache.Entry entry) {
        if (this.mCache == null) {
            return;
        }
        ConcurrentCache concurrentCache = this;
        synchronized (concurrentCache) {
            if (this.mCache.get(key) == null) {
                Billing.debug(TAG, "Adding entry with key=" + key + " to the cache");
                this.mCache.put(key, entry);
            } else {
                Billing.debug(TAG, "Entry with key=" + key + " is already in the cache, won't add");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.mCache == null) {
            return;
        }
        ConcurrentCache concurrentCache = this;
        synchronized (concurrentCache) {
            Billing.debug(TAG, "Initializing cache");
            this.mCache.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(@Nonnull Cache.Key key) {
        if (this.mCache == null) {
            return;
        }
        ConcurrentCache concurrentCache = this;
        synchronized (concurrentCache) {
            Billing.debug(TAG, "Removing entry with key=" + key + " from the cache");
            this.mCache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(int type) {
        if (this.mCache == null) {
            return;
        }
        ConcurrentCache concurrentCache = this;
        synchronized (concurrentCache) {
            Billing.debug(TAG, "Removing all entries with type=" + type + " from the cache");
            this.mCache.removeAll(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (this.mCache == null) {
            return;
        }
        ConcurrentCache concurrentCache = this;
        synchronized (concurrentCache) {
            Billing.debug(TAG, "Clearing the cache");
            this.mCache.clear();
        }
    }
}

