/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import android.os.RemoteException;
import com.android.vending.billing.IInAppBillingService;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.BasePurchasesRequest;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.Purchases;
import org.solovyev.android.checkout.RequestType;

class GetPurchaseHistoryRequest
extends BasePurchasesRequest {
    @Nonnull
    private final Bundle mExtraParams;

    protected GetPurchaseHistoryRequest(@Nonnull String product, @Nullable String continuationToken, @Nullable Bundle extraParams) {
        super(RequestType.GET_PURCHASE_HISTORY, 6, product, continuationToken);
        this.mExtraParams = extraParams == null ? new Bundle() : extraParams;
    }

    public GetPurchaseHistoryRequest(@Nonnull GetPurchaseHistoryRequest request, @Nonnull String continuationToken) {
        super(request, continuationToken);
        this.mExtraParams = request.mExtraParams;
    }

    @Override
    @Nullable
    protected Bundle request(@Nonnull IInAppBillingService service, @Nonnull String packageName) throws RemoteException {
        return service.getPurchaseHistory(this.mApiVersion, packageName, this.mProduct, this.mContinuationToken, this.mExtraParams);
    }

    @Override
    protected void processPurchases(@Nonnull List<Purchase> purchases, @Nullable String continuationToken) {
        this.onSuccess(new Purchases(this.mProduct, purchases, continuationToken));
    }
}

