/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import android.os.RemoteException;
import com.android.vending.billing.IInAppBillingService;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.BasePurchasesRequest;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseVerifier;
import org.solovyev.android.checkout.Purchases;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.RequestType;

final class GetPurchasesRequest
extends BasePurchasesRequest {
    @Nonnull
    private final PurchaseVerifier mVerifier;

    GetPurchasesRequest(@Nonnull String product, @Nullable String continuationToken, @Nonnull PurchaseVerifier verifier) {
        super(RequestType.GET_PURCHASES, 3, product, continuationToken);
        this.mVerifier = verifier;
    }

    GetPurchasesRequest(@Nonnull GetPurchasesRequest request, @Nonnull String continuationToken) {
        super(request, continuationToken);
        this.mVerifier = request.mVerifier;
    }

    @Override
    protected void processPurchases(@Nonnull List<Purchase> purchases, @Nullable String continuationToken) {
        VerificationListener listener = new VerificationListener(this, this.mProduct, continuationToken);
        this.mVerifier.verify(purchases, listener);
        if (!listener.mCalled) {
            listener.onError(10001, new IllegalStateException("Either onSuccess or onError methods must be called by PurchaseVerifier"));
        }
    }

    @Override
    protected Bundle request(@Nonnull IInAppBillingService service, @Nonnull String packageName) throws RemoteException {
        return service.getPurchases(this.mApiVersion, packageName, this.mProduct, this.mContinuationToken);
    }

    private static class VerificationListener
    implements RequestListener<List<Purchase>> {
        @Nonnull
        private final Request<Purchases> mRequest;
        @Nonnull
        private final String mProduct;
        @Nullable
        private final String mContinuationToken;
        @Nonnull
        private final Thread mOriginalThread;
        private boolean mCalled;

        public VerificationListener(@Nonnull Request<Purchases> request, @Nonnull String product, @Nullable String continuationToken) {
            this.mRequest = request;
            this.mProduct = product;
            this.mContinuationToken = continuationToken;
            this.mOriginalThread = Thread.currentThread();
        }

        @Override
        public void onSuccess(@Nonnull List<Purchase> verifiedPurchases) {
            Check.equals(this.mOriginalThread, Thread.currentThread(), "Must be called on the same thread");
            this.mCalled = true;
            this.mRequest.onSuccess(new Purchases(this.mProduct, verifiedPurchases, this.mContinuationToken));
        }

        @Override
        public void onError(int response, @Nonnull Exception e) {
            Check.equals(this.mOriginalThread, Thread.currentThread(), "Must be called on the same thread");
            this.mCalled = true;
            if (response == 10001) {
                this.mRequest.onError(e);
            } else {
                this.mRequest.onError(response);
            }
        }
    }
}

