/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import android.os.RemoteException;
import com.android.vending.billing.IInAppBillingService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.Request;
import org.solovyev.android.checkout.RequestException;
import org.solovyev.android.checkout.RequestType;
import org.solovyev.android.checkout.Sku;
import org.solovyev.android.checkout.Skus;

final class GetSkuDetailsRequest
extends Request<Skus> {
    private static final int MAX_SIZE_PER_REQUEST = 20;
    @Nonnull
    private final String mProduct;
    @Nonnull
    private final ArrayList<String> mSkus;

    GetSkuDetailsRequest(@Nonnull String product, @Nonnull List<String> skus) {
        super(RequestType.GET_SKU_DETAILS);
        this.mProduct = product;
        this.mSkus = new ArrayList<String>(skus);
        Collections.sort(this.mSkus);
    }

    @Override
    void start(@Nonnull IInAppBillingService service, @Nonnull String packageName) throws RemoteException, RequestException {
        ArrayList<Sku> allSkuDetails = new ArrayList<Sku>();
        for (int start = 0; start < this.mSkus.size(); start += 20) {
            int end = Math.min(this.mSkus.size(), start + 20);
            ArrayList<String> skuBatch = new ArrayList<String>(this.mSkus.subList(start, end));
            Skus skuDetails = this.getSkuDetails(service, packageName, skuBatch);
            if (skuDetails == null) {
                return;
            }
            allSkuDetails.addAll(skuDetails.list);
        }
        this.onSuccess(new Skus(this.mProduct, allSkuDetails));
    }

    @Nullable
    private Skus getSkuDetails(@Nonnull IInAppBillingService service, @Nonnull String packageName, ArrayList<String> skuBatch) throws RemoteException, RequestException {
        Check.isTrue(skuBatch.size() <= 20, "SKU list is too big");
        Bundle skusBundle = new Bundle();
        skusBundle.putStringArrayList("ITEM_ID_LIST", skuBatch);
        Bundle bundle = service.getSkuDetails(3, packageName, this.mProduct, skusBundle);
        if (!this.handleError(bundle)) {
            return Skus.fromBundle(bundle, this.mProduct);
        }
        return null;
    }

    @Override
    @Nullable
    protected String getCacheKey() {
        if (this.mSkus.size() == 1) {
            return this.mProduct + "_" + this.mSkus.get(0);
        }
        StringBuilder sb = new StringBuilder(5 * this.mSkus.size());
        sb.append("[");
        for (int i = 0; i < this.mSkus.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.mSkus.get(i));
        }
        sb.append("]");
        return this.mProduct + "_" + sb.toString();
    }
}

