/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.ProductTypes;
import org.solovyev.android.checkout.Purchase;
import org.solovyev.android.checkout.PurchaseComparator;
import org.solovyev.android.checkout.Purchases;
import org.solovyev.android.checkout.Sku;

public interface Inventory {
    public int load(@Nonnull Request var1, @Nonnull Callback var2);

    public void cancel();

    public void cancel(int var1);

    public boolean isLoading();

    public static final class Request {
        private final Map<String, List<String>> mSkus = new HashMap<String, List<String>>();
        private final Set<String> mProducts = new HashSet<String>();

        private Request() {
            for (String product : ProductTypes.ALL) {
                this.mSkus.put(product, new ArrayList(5));
            }
        }

        @Nonnull
        Request copy() {
            Request copy = new Request();
            copy.mSkus.putAll(this.mSkus);
            copy.mProducts.addAll(this.mProducts);
            return copy;
        }

        @Nonnull
        public static Request create() {
            return new Request();
        }

        @Nonnull
        public Request loadAllPurchases() {
            this.mProducts.addAll(ProductTypes.ALL);
            return this;
        }

        @Nonnull
        public Request loadPurchases(@Nonnull String product) {
            ProductTypes.checkSupported(product);
            this.mProducts.add(product);
            return this;
        }

        boolean shouldLoadPurchases(@Nonnull String product) {
            return this.mProducts.contains(product);
        }

        @Nonnull
        public Request loadSkus(@Nonnull String product, String ... skus) {
            Check.isTrue(skus.length > 0, "No SKUs listed, can't load them");
            return this.loadSkus(product, Arrays.asList(skus));
        }

        @Nonnull
        public Request loadSkus(@Nonnull String product, @Nonnull List<String> skus) {
            for (String sku : skus) {
                this.loadSkus(product, sku);
            }
            return this;
        }

        @Nonnull
        public Request loadSkus(@Nonnull String product, @Nonnull String sku) {
            ProductTypes.checkSupported(product);
            Check.isNotEmpty(sku);
            List<String> list = this.mSkus.get(product);
            Check.isTrue(!list.contains(sku), "Adding same SKU is not allowed");
            list.add(sku);
            return this;
        }

        boolean shouldLoadSkus(@Nonnull String product) {
            ProductTypes.checkSupported(product);
            return !this.mSkus.get(product).isEmpty();
        }

        @Nonnull
        List<String> getSkus(@Nonnull String product) {
            return this.mSkus.get(product);
        }
    }

    @Immutable
    public static final class Product {
        @Nonnull
        public final String id;
        public final boolean supported;
        @Nonnull
        final List<Purchase> mPurchases = new ArrayList<Purchase>();
        @Nonnull
        final List<Sku> mSkus = new ArrayList<Sku>();

        Product(@Nonnull String id, boolean supported) {
            ProductTypes.checkSupported(id);
            this.id = id;
            this.supported = supported;
        }

        public boolean isPurchased(@Nonnull Sku sku) {
            return this.isPurchased(sku.id.code);
        }

        public boolean isPurchased(@Nonnull String sku) {
            return this.hasPurchaseInState(sku, Purchase.State.PURCHASED);
        }

        public boolean hasPurchaseInState(@Nonnull String sku, @Nonnull Purchase.State state) {
            return this.getPurchaseInState(sku, state) != null;
        }

        @Nullable
        public Purchase getPurchaseInState(@Nonnull String sku, @Nonnull Purchase.State state) {
            return Purchases.getPurchaseInState(this.mPurchases, sku, state);
        }

        @Nullable
        public Purchase getPurchaseInState(@Nonnull Sku sku, @Nonnull Purchase.State state) {
            return this.getPurchaseInState(sku.id.code, state);
        }

        @Nonnull
        public List<Purchase> getPurchases() {
            return Collections.unmodifiableList(this.mPurchases);
        }

        void setPurchases(@Nonnull List<Purchase> purchases) {
            Check.isTrue(this.mPurchases.isEmpty(), "Must be called only once");
            this.mPurchases.addAll(Purchases.neutralize(purchases));
            Collections.sort(this.mPurchases, PurchaseComparator.latestFirst());
        }

        @Nonnull
        public List<Sku> getSkus() {
            return Collections.unmodifiableList(this.mSkus);
        }

        void setSkus(@Nonnull List<Sku> skus) {
            Check.isTrue(this.mSkus.isEmpty(), "Must be called only once");
            this.mSkus.addAll(skus);
        }

        @Nullable
        public Sku getSku(@Nonnull String sku) {
            for (Sku s : this.mSkus) {
                if (!s.id.code.equals(sku)) continue;
                return s;
            }
            return null;
        }
    }

    @Immutable
    public static final class Products
    implements Iterable<Product> {
        @Nonnull
        static final Products sEmpty = new Products();
        @Nonnull
        private final Map<String, Product> mMap = new HashMap<String, Product>();

        Products() {
            for (String product : ProductTypes.ALL) {
                this.mMap.put(product, new Product(product, false));
            }
        }

        @Nonnull
        public static Products empty() {
            return sEmpty;
        }

        void add(@Nonnull Product product) {
            this.mMap.put(product.id, product);
        }

        @Nonnull
        public Product get(@Nonnull String productId) {
            ProductTypes.checkSupported(productId);
            return this.mMap.get(productId);
        }

        @Override
        public Iterator<Product> iterator() {
            return Collections.unmodifiableCollection(this.mMap.values()).iterator();
        }

        public int size() {
            return this.mMap.size();
        }

        void merge(@Nonnull Products products) {
            for (Map.Entry<String, Product> entry : this.mMap.entrySet()) {
                Product product;
                if (entry.getValue().supported || (product = products.mMap.get(entry.getKey())) == null) continue;
                entry.setValue(product);
            }
        }
    }

    public static interface Callback {
        public void onLoaded(@Nonnull Products var1);
    }
}

