/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import android.os.Bundle;
import android.os.RemoteException;
import android.text.TextUtils;
import com.android.vending.billing.IInAppBillingService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.solovyev.android.checkout.Billing;
import org.solovyev.android.checkout.BillingException;
import org.solovyev.android.checkout.Check;
import org.solovyev.android.checkout.RequestException;
import org.solovyev.android.checkout.RequestListener;
import org.solovyev.android.checkout.RequestType;
import org.solovyev.android.checkout.ResponseCodes;

abstract class Request<R> {
    @Nonnull
    private static final AtomicInteger sCounter = new AtomicInteger(0);
    protected final int mApiVersion;
    private final int mId;
    @Nonnull
    private final RequestType mType;
    @Nullable
    private Object mTag;
    @Nullable
    @GuardedBy(value="this")
    private RequestListener<R> mListener;
    @GuardedBy(value="this")
    private boolean mListenerCalled;

    Request(@Nonnull RequestType type) {
        this(type, 3);
    }

    Request(@Nonnull RequestType type, int apiVersion) {
        this.mType = type;
        this.mApiVersion = apiVersion;
        this.mId = sCounter.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Request(@Nonnull Request<R> request) {
        this.mType = request.mType;
        this.mId = request.mId;
        this.mApiVersion = request.mApiVersion;
        Request<R> request2 = request;
        synchronized (request2) {
            this.mListener = request.mListener;
        }
    }

    protected int getId() {
        return this.mId;
    }

    abstract void start(@Nonnull IInAppBillingService var1, @Nonnull String var2) throws RemoteException, RequestException;

    @Nullable
    Object getTag() {
        return this.mTag;
    }

    void setTag(@Nullable Object tag) {
        this.mTag = tag;
    }

    @Nonnull
    RequestType getType() {
        return this.mType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Request request = this;
        synchronized (request) {
            if (this.mListener != null) {
                Billing.cancel(this.mListener);
            }
            this.mListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCancelled() {
        Request request = this;
        synchronized (request) {
            return this.mListener == null;
        }
    }

    protected void onSuccess(@Nonnull R result) {
        RequestListener<R> l = this.getListener();
        if (l != null) {
            if (this.checkListenerCalled()) {
                return;
            }
            l.onSuccess(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkListenerCalled() {
        Request request = this;
        synchronized (request) {
            if (this.mListenerCalled) {
                return true;
            }
            this.mListenerCalled = true;
        }
        return false;
    }

    protected void onError(int response) {
        String message = ResponseCodes.toString(response);
        Billing.error("Error response: " + message + " in " + this + " request");
        this.onError(response, new BillingException(response));
    }

    public void onError(@Nonnull Exception e) {
        Check.isFalse(e instanceof BillingException, "Use onError(int) instead");
        Billing.error("Exception in " + this + " request: ", e);
        this.onError(10001, e);
    }

    private void onError(int response, @Nonnull Exception e) {
        Check.notEquals(0, response);
        RequestListener<R> l = this.getListener();
        if (l != null) {
            if (this.checkListenerCalled()) {
                return;
            }
            l.onError(response, e);
        }
    }

    protected final boolean handleError(@Nullable Bundle bundle) {
        int response = bundle != null ? bundle.getInt("RESPONSE_CODE") : 6;
        return this.handleError(response);
    }

    protected final boolean handleError(int response) {
        if (response != 0) {
            this.onError(response);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    RequestListener<R> getListener() {
        Request request = this;
        synchronized (request) {
            return this.mListener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setListener(@Nullable RequestListener<R> listener) {
        Request request = this;
        synchronized (request) {
            Check.isNull(this.mListener);
            this.mListener = listener;
        }
    }

    public String toString() {
        String cacheKey = this.getCacheKey();
        if (!TextUtils.isEmpty((CharSequence)cacheKey)) {
            return this.getClass().getSimpleName() + "(" + cacheKey + ")";
        }
        return this.getClass().getSimpleName();
    }

    @Nullable
    abstract String getCacheKey();
}

