/*
 * Decompiled with CFR 0.152.
 */
package org.solovyev.android.checkout;

import javax.annotation.Nonnull;
import org.solovyev.android.checkout.Cache;

enum RequestType {
    BILLING_SUPPORTED("supported", 86400000L),
    GET_PURCHASES("purchases", 1200000L),
    GET_PURCHASE_HISTORY("history", 0L),
    GET_SKU_DETAILS("skus", 86400000L),
    PURCHASE("purchase", 0L),
    CHANGE_PURCHASE("change", 0L),
    CONSUME_PURCHASE("consume", 0L);

    final long expiresIn;
    @Nonnull
    final String cacheKeyName;

    private RequestType(String cacheKeyName, long expiresIn) {
        this.cacheKeyName = cacheKeyName;
        this.expiresIn = expiresIn;
    }

    @Nonnull
    static String getCacheKeyName(int keyType) {
        return RequestType.values()[keyType].cacheKeyName;
    }

    @Nonnull
    Cache.Key getCacheKey(@Nonnull String key) {
        int keyType = this.getCacheKeyType();
        return new Cache.Key(keyType, key);
    }

    int getCacheKeyType() {
        return this.ordinal();
    }
}

